/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import org.h2.message.DbException;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueGeometry
extends Value {
    private Geometry geometry;
    private byte[] bytes;
    private int hashCode;

    private ValueGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    private ValueGeometry(byte[] byArray) {
        this.bytes = byArray;
    }

    public static ValueGeometry getFromGeometry(Object object) {
        return ValueGeometry.get((Geometry)object);
    }

    private static ValueGeometry get(Geometry geometry) {
        ValueGeometry.toWKB(geometry);
        return (ValueGeometry)Value.cache(new ValueGeometry(geometry));
    }

    public static ValueGeometry get(String string) {
        Geometry geometry = ValueGeometry.fromWKT(string);
        ValueGeometry.toWKB(geometry);
        return (ValueGeometry)Value.cache(new ValueGeometry(geometry));
    }

    public static ValueGeometry get(byte[] byArray) {
        return (ValueGeometry)Value.cache(new ValueGeometry(byArray));
    }

    public Geometry getGeometry() {
        if (this.geometry == null && this.bytes != null) {
            this.geometry = ValueGeometry.fromWKB(this.bytes);
        }
        return this.geometry;
    }

    public boolean intersectsBoundingBox(ValueGeometry valueGeometry) {
        return this.getGeometry().getEnvelopeInternal().intersects(valueGeometry.getGeometry().getEnvelopeInternal());
    }

    public Value getEnvelopeUnion(ValueGeometry valueGeometry) {
        GeometryFactory geometryFactory = new GeometryFactory();
        Envelope envelope = new Envelope(this.getGeometry().getEnvelopeInternal());
        envelope.expandToInclude(valueGeometry.getGeometry().getEnvelopeInternal());
        return ValueGeometry.get(geometryFactory.toGeometry(envelope));
    }

    @Override
    public int getType() {
        return 22;
    }

    @Override
    public String getSQL() {
        return StringUtils.quoteStringSQL(this.toWKT()) + "'::Geometry";
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        Geometry geometry = ((ValueGeometry)value).getGeometry();
        return this.getGeometry().compareTo((Object)geometry);
    }

    @Override
    public String getString() {
        return this.toWKT();
    }

    @Override
    public long getPrecision() {
        return 0L;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(this.toWKB());
        }
        return this.hashCode;
    }

    @Override
    public Object getObject() {
        return this.getGeometry();
    }

    @Override
    public byte[] getBytes() {
        return this.toWKB();
    }

    @Override
    public byte[] getBytesNoCopy() {
        return this.toWKB();
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setObject(n, this.getGeometry());
    }

    @Override
    public int getDisplaySize() {
        return this.toWKT().length();
    }

    @Override
    public int getMemory() {
        return this.toWKB().length * 20 + 24;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueGeometry && Arrays.equals(this.toWKB(), ((ValueGeometry)object).toWKB());
    }

    public String toWKT() {
        return new WKTWriter().write(this.getGeometry());
    }

    public byte[] toWKB() {
        if (this.bytes != null) {
            return this.bytes;
        }
        return ValueGeometry.toWKB(this.getGeometry());
    }

    private static byte[] toWKB(Geometry geometry) {
        int n = ValueGeometry.getDimensionCount(geometry);
        boolean bl = geometry.getSRID() != 0;
        WKBWriter wKBWriter = new WKBWriter(n, bl);
        return wKBWriter.write(geometry);
    }

    private static int getDimensionCount(Geometry geometry) {
        ZVisitor zVisitor = new ZVisitor();
        geometry.apply((CoordinateSequenceFilter)zVisitor);
        return zVisitor.isFoundZ() ? 3 : 2;
    }

    private static Geometry fromWKT(String string) {
        try {
            return new WKTReader().read(string);
        }
        catch (ParseException parseException) {
            throw DbException.convert(parseException);
        }
    }

    private static Geometry fromWKB(byte[] byArray) {
        try {
            return new WKBReader().read(byArray);
        }
        catch (ParseException parseException) {
            throw DbException.convert(parseException);
        }
    }

    @Override
    public Value convertTo(int n) {
        if (n == 19) {
            return this;
        }
        return super.convertTo(n);
    }

    static class ZVisitor
    implements CoordinateSequenceFilter {
        boolean foundZ;

        ZVisitor() {
        }

        public boolean isFoundZ() {
            return this.foundZ;
        }
    }
}

