/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.PageDataLeaf;
import org.h2.message.DbException;
import org.h2.store.Data;
import org.h2.store.Page;
import org.h2.store.PageStore;

public class PageDataOverflow
extends Page {
    private final PageStore store;
    private int type;
    private int parentPageId;
    private int nextPage;
    private final Data data;
    private int start;
    private int size;

    private PageDataOverflow(PageStore pageStore, int n, Data data) {
        this.store = pageStore;
        this.setPos(n);
        this.data = data;
    }

    public static Page read(PageStore pageStore, Data data, int n) {
        PageDataOverflow pageDataOverflow = new PageDataOverflow(pageStore, n, data);
        pageDataOverflow.read();
        return pageDataOverflow;
    }

    static PageDataOverflow create(PageStore pageStore, int n, int n2, int n3, int n4, Data data, int n5, int n6) {
        Data data2 = pageStore.createData();
        PageDataOverflow pageDataOverflow = new PageDataOverflow(pageStore, n, data2);
        pageStore.logUndo(pageDataOverflow, null);
        data2.writeByte((byte)n2);
        data2.writeShortInt(0);
        data2.writeInt(n3);
        if (n2 == 3) {
            data2.writeInt(n4);
        } else {
            data2.writeShortInt(n6);
        }
        pageDataOverflow.start = data2.length();
        data2.write(data.getBytes(), n5, n6);
        pageDataOverflow.type = n2;
        pageDataOverflow.parentPageId = n3;
        pageDataOverflow.nextPage = n4;
        pageDataOverflow.size = n6;
        return pageDataOverflow;
    }

    private void read() {
        this.data.reset();
        this.type = this.data.readByte();
        this.data.readShortInt();
        this.parentPageId = this.data.readInt();
        if (this.type == 19) {
            this.size = this.data.readShortInt();
            this.nextPage = 0;
        } else if (this.type == 3) {
            this.nextPage = this.data.readInt();
            this.size = this.store.getPageSize() - this.data.length();
        } else {
            throw DbException.get(90030, "page:" + this.getPos() + " type:" + this.type);
        }
        this.start = this.data.length();
    }

    int readInto(Data data) {
        data.checkCapacity(this.size);
        if (this.type == 19) {
            data.write(this.data.getBytes(), 9, this.size);
            return 0;
        }
        data.write(this.data.getBytes(), 11, this.size);
        return this.nextPage;
    }

    int getNextOverflow() {
        return this.nextPage;
    }

    private void writeHead() {
        this.data.writeByte((byte)this.type);
        this.data.writeShortInt(0);
        this.data.writeInt(this.parentPageId);
    }

    @Override
    public void write() {
        this.writeData();
        this.store.writePage(this.getPos(), this.data);
    }

    private void writeData() {
        this.data.reset();
        this.writeHead();
        if (this.type == 3) {
            this.data.writeInt(this.nextPage);
        } else {
            this.data.writeShortInt(this.size);
        }
    }

    public String toString() {
        return "page[" + this.getPos() + "] data leaf overflow parent:" + this.parentPageId + " next:" + this.nextPage;
    }

    @Override
    public int getMemory() {
        return 120 + this.store.getPageSize() >> 2;
    }

    void setParentPageId(int n) {
        this.store.logUndo(this, this.data);
        this.parentPageId = n;
    }

    @Override
    public void moveTo(Session session, int n) {
        Page page = this.store.getPage(this.parentPageId);
        if (page == null) {
            throw DbException.throwInternalError();
        }
        PageDataOverflow pageDataOverflow = null;
        if (this.nextPage != 0) {
            pageDataOverflow = (PageDataOverflow)this.store.getPage(this.nextPage);
        }
        this.store.logUndo(this, this.data);
        PageDataOverflow pageDataOverflow2 = PageDataOverflow.create(this.store, n, this.type, this.parentPageId, this.nextPage, this.data, this.start, this.size);
        this.store.update(pageDataOverflow2);
        if (pageDataOverflow != null) {
            pageDataOverflow.setParentPageId(n);
            this.store.update(pageDataOverflow);
        }
        if (page instanceof PageDataOverflow) {
            PageDataOverflow pageDataOverflow3 = (PageDataOverflow)page;
            pageDataOverflow3.setNext(this.getPos(), n);
        } else {
            PageDataLeaf pageDataLeaf = (PageDataLeaf)page;
            pageDataLeaf.setOverflow(this.getPos(), n);
        }
        this.store.update(page);
        this.store.free(this.getPos());
    }

    private void setNext(int n, int n2) {
        if (SysProperties.CHECK && n != this.nextPage) {
            DbException.throwInternalError("move " + this + " " + n2);
        }
        this.store.logUndo(this, this.data);
        this.nextPage = n2;
        this.data.setInt(7, n2);
    }

    void free() {
        this.store.logUndo(this, this.data);
        this.store.free(this.getPos());
    }

    @Override
    public boolean canRemove() {
        return true;
    }

    @Override
    public boolean isStream() {
        return true;
    }
}

