/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.openconcerto.utils.cc.IPredicate;
import org.openconcerto.xml.SimpleXMLPath;

public final class Step<T> {
    private static final Step<Attribute> ANY_ATTRIBUTE = Step.createAttributeStep(null, null);
    private static final Step<Element> ANY_CHILD_ELEMENT = Step.createElementStep(Axis.child, null, null);
    private final Axis axis;
    private final String name;
    private final String ns;
    private final Class<T> clazz;
    private final SimpleXMLPath.Node<T> node;
    private final IPredicate<T> pred;

    public static Step<Attribute> getAnyAttributeStep() {
        return ANY_ATTRIBUTE;
    }

    public static Step<Attribute> createAttributeStep(String name, String ns) {
        return Step.createAttributeStep(name, ns, null);
    }

    public static Step<Attribute> createAttributeStep(String name, String ns, IPredicate<Attribute> pred) {
        return new Step<Attribute>(Axis.attribute, name, ns, Attribute.class, pred);
    }

    public static Step<Element> getAnyChildElementStep() {
        return ANY_CHILD_ELEMENT;
    }

    public static Step<Element> createElementStep(String name, String ns) {
        return Step.createElementStep(name, ns, null);
    }

    public static Step<Element> createElementStep(String name, String ns, IPredicate<Element> pred) {
        return Step.createElementStep(Axis.child, name, ns, pred);
    }

    public static Step<Element> createElementStep(Axis axis, String name) {
        return Step.createElementStep(axis, name, null);
    }

    public static Step<Element> createElementStep(Axis axis, String name, String ns) {
        return Step.createElementStep(axis, name, ns, null);
    }

    public static Step<Element> createElementStep(Axis axis, String name, String ns, IPredicate<Element> pred) {
        return new Step<Element>(axis, name, ns, Element.class, pred);
    }

    private Step(Axis axis, String name, String ns, Class<T> clazz, IPredicate<T> pred) {
        this.axis = axis;
        this.name = name;
        this.ns = ns;
        this.clazz = clazz;
        this.node = SimpleXMLPath.Node.get(this.clazz);
        this.pred = pred;
    }

    public final Axis getAxis() {
        return this.axis;
    }

    public final String getName() {
        return this.name;
    }

    public final IPredicate<T> getPredicate() {
        return this.pred;
    }

    protected final Namespace getNS(Element elem) {
        return this.ns == null ? Namespace.NO_NAMESPACE : elem.getNamespace(this.ns);
    }

    protected final T evaluate(Object node) {
        if (node == null) {
            return null;
        }
        T n = this.clazz.cast(node);
        T filtered = this.node.filter(n, this.getName(), this.ns);
        if (filtered == null) {
            return null;
        }
        return (T)(this.pred == null || this.pred.evaluateChecked(filtered) ? filtered : null);
    }

    protected final void add(Object node, List<T> l) {
        T filtered = this.evaluate(node);
        if (filtered != null) {
            l.add(filtered);
        }
    }

    final <U> List<T> nextNodes(SimpleXMLPath.Node<U> n, U jdom) {
        return this.nextNodes(new ArrayList(), n, jdom);
    }

    final <U> List<T> nextNodes(List<T> res, SimpleXMLPath.Node<U> n, U jdom) {
        n.nextNodes(res, jdom, this);
        return res;
    }

    final <U> List<T> nextNodes(List<U> jdom) {
        int stop = jdom.size();
        if (stop == 0) {
            return Collections.emptyList();
        }
        SimpleXMLPath.Node<U> n = SimpleXMLPath.Node.get(jdom.get(0));
        ArrayList res = new ArrayList();
        int i = 0;
        while (i < stop) {
            this.nextNodes(res, n, jdom.get(i));
            ++i;
        }
        return res;
    }

    public final String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + (Object)((Object)this.getAxis()) + " " + this.ns + ":" + this.name;
    }

    public static enum Axis {
        attribute,
        child,
        ancestor,
        descendantOrSelf;

    }
}

