/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.swing.event.ListDataListener;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.change.CollectionChangeEventCreator;
import org.openconcerto.utils.change.ConstructorCreator;
import org.openconcerto.utils.change.IListDataEvent;
import org.openconcerto.utils.model.DefaultIListModel;
import org.openconcerto.utils.model.IMutableListModel;
import org.openconcerto.utils.model.NewSelection;

public class DefaultIMutableListModel<T>
extends DefaultIListModel<T>
implements IMutableListModel<T> {
    private T selectedObject;
    private boolean selectOnAdd = true;
    private NewSelection selectOnRm;
    private NewSelection selectOnReplace;

    public DefaultIMutableListModel() {
        this(Collections.emptyList());
    }

    public DefaultIMutableListModel(T[] v) {
        this(Arrays.asList(v));
    }

    public DefaultIMutableListModel(Collection<? extends T> v) {
        super(v);
        this.setOnRemovingOrReplacingSelection(null);
        this.selectedObject = this.getSize() > 0 && this.isSelectOnAdd() ? this.getElementAt(0) : null;
    }

    public void setSelectedItem(T anObject) {
        if (this.selectedObject != null && !this.selectedObject.equals(anObject) || this.selectedObject == null && anObject != null) {
            this.selectedObject = anObject;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public T getSelectedItem() {
        return this.selectedObject;
    }

    @Override
    public final void addElement(T anObject) {
        this.addAll(Collections.singleton(anObject));
    }

    public void addAll(Collection<? extends T> items) {
        this.addAll(-1, items);
    }

    public void addAll(int index, Collection<? extends T> items) {
        this.addAll(index, items, true);
    }

    public void addAll(int index, Collection<? extends T> items, boolean setSelection) {
        if (items.size() > 0) {
            int size = this.objects.size();
            if (index < 0) {
                index = size;
                this.objects.addAll(items);
            } else {
                this.objects.addAll(index, items);
            }
            this.fireIntervalAdded(this, index, index + items.size() - 1);
            if (setSelection && this.isSelectOnAdd() && size == 0 && this.getSelectedItem() == null) {
                this.setSelectedItem(items.iterator().next());
            }
        }
    }

    @Override
    public void insertElementAt(T anObject, int index) {
        this.objects.add(index, anObject);
        this.fireIntervalAdded(this, index, index);
    }

    @Override
    public void removeElementAt(int index) {
        this.removeElementsAt(index, index);
    }

    public void removeElementsAt(int from, int to) {
        ConstructorCreator c = this.createCreator();
        int selectedIndex = this.objects.indexOf(this.getSelectedItem());
        NewSelection onRm = this.getOnRemovingSelection();
        if (selectedIndex >= from && selectedIndex <= to && onRm != NewSelection.NO) {
            this.setSelectedItem(onRm.getNewSelection(this, selectedIndex, from, to, Collections.emptyList()));
        }
        this.objects.subList(from, to + 1).clear();
        this.fireIntervalRemoved(from, to, c);
    }

    public void set(int index, T o) {
        this.replace(index, index, Collections.singleton(o));
    }

    public void replace(int index0, int index1, Collection<? extends T> l) {
        this.replace(index0, index1, l, true);
    }

    public void replace(int index0, int index1, Collection<? extends T> l, boolean setSelection) {
        ConstructorCreator c = this.createCreator();
        int selectedIndex = this.objects.indexOf(this.getSelectedItem());
        if (index0 == index1 && l.size() == 1) {
            this.objects.set(index0, l.iterator().next());
        } else {
            this.objects.subList(index0, index1 + 1).clear();
            this.objects.addAll(index0, l);
        }
        NewSelection onReplace = this.getOnReplacingSelection();
        if (setSelection && onReplace != NewSelection.NO && selectedIndex >= 0 && this.objects.indexOf(this.getSelectedItem()) < 0) {
            this.setSelectedItem(onReplace.getNewSelection(this, selectedIndex, index0, index1, l.size()));
        }
        this.fireContentsChanged(index0, index1, c);
    }

    public final void setAllElements(List<? extends T> items) {
        this.setAllElements(items, true);
    }

    public void setAllElements(Collection<? extends T> items, boolean setSelection) {
        int size = this.getSize();
        if (size == 0) {
            this.addAll(0, items, setSelection);
        } else {
            this.replace(0, size - 1, items, setSelection);
        }
    }

    public void replace(T old, T o) {
        this.set(this.getList().indexOf(old), o);
    }

    @Override
    public void removeElement(T anObject) {
        int index = this.objects.indexOf(anObject);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    public void removeAll(Collection<? extends T> items) {
        TreeSet<Integer> indexes = new TreeSet<Integer>();
        for (T item : items) {
            int index = this.objects.indexOf(item);
            if (index < 0) continue;
            indexes.add(index);
        }
        for (int[] interval : CollectionUtils.aggregate(indexes)) {
            this.removeElementsAt(interval[0], interval[1]);
        }
    }

    @Override
    public void removeAllElements() {
        int size = this.objects.size();
        if (size > 0) {
            this.removeElementsAt(0, size - 1);
        }
    }

    private ConstructorCreator createCreator() {
        return new ConstructorCreator(this, "items", this.objects);
    }

    protected void fireIntervalRemoved(int index0, int index1, CollectionChangeEventCreator c) {
        this.fire(2, index0, index1, c);
    }

    protected void fireContentsChanged(int index0, int index1, CollectionChangeEventCreator c) {
        this.fire(0, index0, index1, c);
    }

    protected void fire(int type, int index0, int index1, CollectionChangeEventCreator c) {
        Object[] listeners = this.listenerList.getListenerList();
        IListDataEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ListDataListener.class) {
                if (e == null) {
                    e = c.create(this.objects, type, index0, index1);
                }
                switch (type) {
                    case 2: {
                        ((ListDataListener)listeners[i + 1]).intervalRemoved(e);
                        break;
                    }
                    case 0: {
                        ((ListDataListener)listeners[i + 1]).contentsChanged(e);
                        break;
                    }
                    case 1: {
                        ((ListDataListener)listeners[i + 1]).intervalAdded(e);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("wrong type: " + type);
                    }
                }
            }
            i -= 2;
        }
    }

    public final boolean isSelectOnAdd() {
        return this.selectOnAdd;
    }

    public final void setSelectOnAdd(boolean selectOnAdd) {
        this.selectOnAdd = selectOnAdd;
    }

    public final NewSelection getOnRemovingSelection() {
        return this.selectOnRm;
    }

    public final NewSelection getOnReplacingSelection() {
        return this.selectOnReplace;
    }

    public final void setOnRemovingOrReplacingSelection(NewSelection newSel) {
        if (newSel == null) {
            this.setOnRemovingSelection(NewSelection.DIFFERENT_INDEX);
            this.setOnReplacingSelection(NewSelection.NONE);
        } else {
            this.setOnRemovingSelection(newSel);
            this.setOnReplacingSelection(newSel);
        }
    }

    public final void setOnRemovingSelection(NewSelection selectOnRm) {
        if (selectOnRm == null) {
            throw new NullPointerException();
        }
        this.selectOnRm = selectOnRm;
    }

    public final void setOnReplacingSelection(NewSelection newSel) {
        if (newSel == null) {
            throw new NullPointerException();
        }
        this.selectOnReplace = newSel;
    }
}

