/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.i18n;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public final class I18nUtils {
    private static final SameLanguageControl INSTANCE = new SameLanguageControl();
    public static final String RSRC_BASENAME = I18nUtils.getBaseName(I18nUtils.class);
    public static final String TRUE_KEY = "true_key";
    public static final String FALSE_KEY = "false_key";
    public static final String YES_KEY = "yes_key";
    public static final String NO_KEY = "no_key";

    public static final String getPackageName(Class<?> c) {
        return String.valueOf(c.getPackage().getName()) + ".translation";
    }

    protected static final String getBaseName(Class<?> c) {
        return String.valueOf(I18nUtils.getPackageName(c)) + ".messages";
    }

    public static ResourceBundle.Control getSameLanguageControl() {
        return INSTANCE;
    }

    public static final String getBooleanKey(boolean b) {
        return b ? TRUE_KEY : FALSE_KEY;
    }

    public static final String getYesNoKey(boolean b) {
        return b ? YES_KEY : NO_KEY;
    }

    public static Locale createLocaleFromString(String localeString) {
        String variant;
        String country;
        String language;
        if (localeString == null) {
            return null;
        }
        int languageIndex = localeString.indexOf(95);
        if (languageIndex == -1) {
            language = localeString;
            country = "";
            variant = "";
        } else {
            language = localeString.substring(0, languageIndex);
            int countryIndex = localeString.indexOf(95, languageIndex + 1);
            if (countryIndex == -1) {
                country = localeString.substring(languageIndex + 1);
                variant = "";
            } else {
                country = localeString.substring(languageIndex + 1, countryIndex);
                variant = localeString.substring(countryIndex + 1);
            }
        }
        return new Locale(language, country, variant);
    }

    public static class SameLanguageControl
    extends ResourceBundle.Control {
        @Override
        public List<Locale> getCandidateLocales(String baseName, Locale locale) {
            List<Locale> res = super.getCandidateLocales(baseName, locale);
            int superSize = res.size();
            assert (res.get(superSize - 1) == Locale.ROOT);
            if (superSize == 1) {
                return res;
            }
            res = res.subList(0, superSize - 1);
            assert (res.get(res.size() - 1).getLanguage().equals(locale.getLanguage()));
            return res;
        }

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            if (baseName == null) {
                throw new NullPointerException();
            }
            return null;
        }
    }
}

