/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cc;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.Tuple2;

public class IncludeExclude<T> {
    private static final IncludeExclude<Object> EMPTY = new IncludeExclude(Collections.emptySet(), Collections.emptySet(), true);
    private static final IncludeExclude<Object> FULL = new IncludeExclude(null, Collections.emptySet(), true);
    private final Set<T> includes;
    private final Set<T> excludes;
    private final IncludeExclude<T> normal;

    public static <T> IncludeExclude<T> getEmpty() {
        return EMPTY;
    }

    public static <T> IncludeExclude<T> getFull() {
        return FULL;
    }

    public static <T> IncludeExclude<T> getNormalized(Collection<? extends T> includes) {
        return IncludeExclude.getNormalized(includes, Collections.emptySet());
    }

    public static <T> IncludeExclude<T> getNormalized(Collection<? extends T> includes, Collection<? extends T> excludes) {
        return new IncludeExclude<T>(includes, excludes).normal;
    }

    public IncludeExclude(Collection<? extends T> includes) {
        this(includes, Collections.emptySet());
    }

    public IncludeExclude(Collection<? extends T> includes, Collection<? extends T> excludes) {
        this(includes, excludes, false);
    }

    private IncludeExclude(Collection<? extends T> includes, Collection<? extends T> excludes, boolean isNormal) {
        this.includes = includes == null ? null : Collections.unmodifiableSet(new HashSet<T>(includes));
        this.excludes = excludes == null ? null : Collections.unmodifiableSet(new HashSet<T>(excludes));
        IncludeExclude<T> includeExclude = this.normal = isNormal ? this : this.normalize();
        assert (this.normal.excludes.isEmpty() || this.normal.includes == null);
    }

    private final IncludeExclude<T> normalize() {
        if (this.excludes == null) {
            return IncludeExclude.getEmpty();
        }
        if (this.excludes.isEmpty() && this.includes == null) {
            return IncludeExclude.getFull();
        }
        if (this.excludes.isEmpty() || this.includes == null) {
            return this;
        }
        return new IncludeExclude<T>(CollectionUtils.substract(this.includes, this.excludes), Collections.emptySet(), true);
    }

    public final IncludeExclude<T> getNormal() {
        return this.normal;
    }

    public final boolean isIncluded(T s) {
        if (this.isAllIncluded()) {
            return true;
        }
        if (this.isNoneIncluded()) {
            return false;
        }
        return (this.normal.includes == null || this.normal.includes.contains(s)) && !this.normal.excludes.contains(s);
    }

    public final boolean isAllIncluded() {
        return this.normal == FULL;
    }

    public final boolean isNoneIncluded() {
        return this.normal == EMPTY;
    }

    public final Tuple2<Boolean, T> getSole() {
        if (this.normal.includes == null) {
            return Tuple2.create(false, null);
        }
        assert (this.normal.excludes.isEmpty());
        boolean res = this.normal.includes.size() == 1;
        return Tuple2.create(res, res ? (Object)this.normal.includes.iterator().next() : null);
    }

    public final T getSole(T ifNoSole) {
        Tuple2<Boolean, T> sole = this.getSole();
        if (sole.get0().booleanValue()) {
            return sole.get1();
        }
        return ifNoSole;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.excludes == null ? 0 : this.excludes.hashCode());
        result = 31 * result + (this.includes == null ? 0 : this.includes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IncludeExclude other = (IncludeExclude)obj;
        return CompareUtils.equals(this.includes, other.includes) && CompareUtils.equals(this.excludes, other.excludes);
    }
}

