/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.state;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public abstract class AbstractStateManager<T> {
    private File configFile;
    private final T src;

    public AbstractStateManager(T src, File f) {
        this(src, f, true);
    }

    public AbstractStateManager(T src, File f, boolean autosave) {
        this.src = src;
        this.configFile = f;
        if (autosave) {
            this.beginAutoSave();
        }
    }

    public final File getConfigFile() {
        return this.configFile;
    }

    public final void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    protected final T getSrc() {
        return this.src;
    }

    public abstract void beginAutoSave();

    public abstract void endAutoSave();

    public final void deleteState() {
        this.check();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                AbstractStateManager.this.getConfigFile().delete();
                return null;
            }
        });
    }

    private void check() {
        if (this.configFile == null) {
            throw new IllegalStateException("configFile undefined.");
        }
    }

    public final void saveState() throws IOException {
        this.check();
        this.saveState(this.getConfigFile());
    }

    public final void saveState(final File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("null File specified");
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException {
                    if (file.getParentFile() != null && !file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    AbstractStateManager.this.writeState(file);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    protected abstract void writeState(File var1) throws IOException;

    public final boolean loadState() {
        this.check();
        return this.loadState(this.getConfigFile());
    }

    public final boolean loadState(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                if (file.exists() && file.length() > 0L) {
                    AbstractStateManager.this.setConfigFile(file);
                    return AbstractStateManager.this.readState(file);
                }
                return false;
            }
        });
    }

    protected abstract boolean readState(File var1);
}

