/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

public class Row
implements Externalizable {
    private long id;
    private List<Object> values;

    public Row() {
    }

    public Row(long id, int valueCount) {
        this.id = id;
        if (valueCount > 0) {
            this.values = new ArrayList<Object>(valueCount);
        }
    }

    public Row(long id) {
        this.id = id;
    }

    public void setValues(List<Object> values) {
        this.values = values;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public long getId() {
        return this.id;
    }

    public String toString() {
        return "Row id: " + this.id + " values: " + this.values;
    }

    public void addValue(Object v) {
        this.values.add(v);
    }

    public void setValue(int index, Object v) {
        this.values.set(index, v);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        out.writeObject(this.values);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readLong();
        this.values = (List)in.readObject();
    }
}

