/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.ui.light.LightUIElement;

public class LightUILine
implements Serializable {
    public static final int ALIGN_GRID = 0;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;
    private static final long serialVersionUID = 4132718509484530435L;
    private int weightY;
    private boolean fillHeight;
    private int gridAlignment = 0;
    private List<LightUIElement> elements = new ArrayList<LightUIElement>();

    public int getSize() {
        return this.elements.size();
    }

    public void add(LightUIElement element) {
        this.elements.add(element);
    }

    public void dump(PrintStream out) {
        int size = this.elements.size();
        out.println("LightUILine " + size + " elements, weightY: " + this.weightY + " fillHeight: " + this.fillHeight);
        int i = 0;
        while (i < size) {
            LightUIElement element = this.elements.get(i);
            out.print("Element " + i + " : ");
            element.dump(out);
            ++i;
        }
    }

    public int getWidth() {
        int w = 0;
        int size = this.elements.size();
        int i = 0;
        while (i < size) {
            w += this.elements.get(i).getGridWidth();
            ++i;
        }
        return w;
    }

    public int getWeightY() {
        return this.weightY;
    }

    public void setWeightY(int weightY) {
        this.weightY = weightY;
    }

    public boolean isFillHeight() {
        return this.fillHeight;
    }

    public void setFillHeight(boolean fillHeight) {
        this.fillHeight = fillHeight;
    }

    public LightUIElement getElement(int i) {
        return this.elements.get(i);
    }

    public int getGridAlignment() {
        return this.gridAlignment;
    }

    public void setGridAlignment(int gridAlignment) {
        this.gridAlignment = gridAlignment;
    }
}

