/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.awt.Color;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.ui.light.LightUIDescriptor;

public class LightUIElement
implements Serializable {
    private static final long serialVersionUID = 3272357171610073289L;
    public static final int TYPE_LABEL = 0;
    public static final int TYPE_TEXT_FIELD = 1;
    public static final int TYPE_DATE = 2;
    public static final int TYPE_COMBOBOX = 3;
    public static final int TYPE_LIST = 4;
    public static final int TYPE_CHECKBOX = 5;
    public static final int TYPE_TABBED_UI = 6;
    public static final int TYPE_COMBOBOX_ELEMENT = 7;
    public static final int TYPE_DESCRIPTOR = 8;
    public static final int TYPE_TREE = 9;
    public static final int TYPE_BUTTON = 20;
    public static final int TYPE_BUTTON_WITH_CONTEXT = 21;
    public static final int TYPE_BUTTON_CANCEL = 22;
    public static final int TYPE_BUTTON_UNMANAGED = 23;
    public static final int TYPE_BUTTON_WITH_SELECTION_CONTEXT = 24;
    public static final int VALUE_TYPE_STRING = 0;
    public static final int VALUE_TYPE_INTEGER = 1;
    public static final int VALUE_TYPE_DATE = 2;
    public static final int VALUE_TYPE_REF = 3;
    public static final int VALUE_TYPE_LIST = 4;
    public static final int VALUE_TYPE_DECIMAL = 5;
    public static final int COMMIT_ONCE = 0;
    public static final int COMMIT_INTERACTIVE = 1;
    private int type;
    private int gridWidth;
    private boolean fillWidth;
    private String id;
    private String label;
    private String value;
    private Serializable rawContent;
    private int valueType;
    private int commitMode;
    private String valuePrecision;
    private String displayPrecision;
    private String valueRange;
    private int minInputSize;
    private List<LightUIDescriptor> tabs;
    private Color color;
    private String icon;
    private boolean required;
    private String toolTip;
    private boolean verticalyResizable;
    private boolean horizontalyResizable;

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public void setGridWidth(int gridWidth) {
        this.gridWidth = gridWidth;
    }

    public boolean isFillWidth() {
        return this.fillWidth;
    }

    public void setFillWidth(boolean fillWidth) {
        this.fillWidth = fillWidth;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getValue() {
        return this.value;
    }

    public int getCommitMode() {
        return this.commitMode;
    }

    public void setCommitMode(int commitMode) {
        this.commitMode = commitMode;
    }

    public String getDisplayPrecision() {
        return this.displayPrecision;
    }

    public void setDisplayPrecision(String displayPrecision) {
        this.displayPrecision = displayPrecision;
    }

    public String getValuePrecision() {
        return this.valuePrecision;
    }

    public void setValuePrecision(String valuePrecision) {
        this.valuePrecision = valuePrecision;
    }

    public String getValueRange() {
        return this.valueRange;
    }

    public void setValueRange(String valueRange) {
        this.valueRange = valueRange;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int getValueType() {
        return this.valueType;
    }

    public void setValueType(int valueType) {
        this.valueType = valueType;
    }

    public int getMinInputSize() {
        return this.minInputSize;
    }

    public void setMinInputSize(int minInputSize) {
        this.minInputSize = minInputSize;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public List<LightUIDescriptor> getTabs() {
        return this.tabs;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
    }

    public void addTab(LightUIDescriptor desc) {
        if (this.tabs == null) {
            this.tabs = new ArrayList<LightUIDescriptor>(5);
        }
        this.tabs.add(desc);
    }

    public final boolean isVerticalyResizable() {
        return this.verticalyResizable;
    }

    public final void setVerticalyResizable(boolean verticalyResizable) {
        this.verticalyResizable = verticalyResizable;
    }

    public final boolean isHorizontalyResizable() {
        return this.horizontalyResizable;
    }

    public final void setHorizontalyResizable(boolean horizontalyResizable) {
        this.horizontalyResizable = horizontalyResizable;
    }

    public void dump(PrintStream out) {
        String type = "?";
        if (this.type == 5) {
            type = "checkbox";
        } else if (this.type == 3) {
            type = "combobox";
        } else if (this.type == 0) {
            type = "label";
        } else if (this.type == 1) {
            type = "textfield";
        } else if (this.type == 4) {
            type = "list";
        } else if (this.type == 6) {
            type = "tabs";
        } else if (this.type == 9) {
            type = "tree";
        } else if (this.type == 20) {
            type = "button";
        } else if (this.type == 21) {
            type = "button with context";
        } else if (this.type == 22) {
            type = "cancel button";
        } else if (this.type == 7) {
            type = "combo element";
        } else if (this.type == 24) {
            type = "button with selection context";
        }
        String valueType = "?";
        if (this.valueType == 0) {
            valueType = "string";
        } else if (this.valueType == 1) {
            valueType = "int";
        } else if (this.valueType == 3) {
            valueType = "ref";
        } else if (this.valueType == 4) {
            valueType = "list";
        } else if (this.valueType == 5) {
            valueType = "decimal";
        }
        String str = "LightUIElement " + type + " id:" + this.id + " w:" + this.gridWidth + " fill:" + this.fillWidth;
        str = String.valueOf(str) + " value:" + this.value + "(" + valueType + ")";
        if (this.valueRange != null) {
            str = String.valueOf(str) + "range: " + this.valueRange;
        }
        if (this.valuePrecision != null) {
            str = String.valueOf(str) + "precision: " + this.valuePrecision;
        }
        if (this.displayPrecision != null) {
            str = String.valueOf(str) + "display prec.: " + this.displayPrecision;
        }
        if (this.label != null) {
            str = String.valueOf(str) + " label:" + this.label;
        }
        if (this.horizontalyResizable) {
            str = String.valueOf(str) + "|- H ->";
        }
        if (this.verticalyResizable) {
            str = String.valueOf(str) + "|- V ->";
        }
        out.println(str);
    }

    public String toString() {
        return String.valueOf(super.toString()) + " " + this.id;
    }

    public Serializable getRawContent() {
        return this.rawContent;
    }

    public void setRawContent(Serializable rawContent) {
        this.rawContent = rawContent;
    }
}

