/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openconcerto.ui.light.ColumnSpec;
import org.openconcerto.ui.light.LightUIElement;

public class ColumnsSpec
implements Externalizable {
    private String id;
    private List<ColumnSpec> columns;
    private List<String> visibleIds;
    private List<String> sortedIds;
    private int fixedColumns;

    public ColumnsSpec() {
    }

    public ColumnsSpec(String id, List<ColumnSpec> columns, List<String> visibleIds, List<String> sortedIds) {
        if (id == null) {
            throw new IllegalArgumentException("null id");
        }
        this.id = id;
        this.columns = columns;
        if (visibleIds == null) {
            throw new IllegalArgumentException("null visible columns");
        }
        if (visibleIds.isEmpty()) {
            throw new IllegalArgumentException("empty visible columns");
        }
        this.visibleIds = visibleIds;
        if (sortedIds == null) {
            sortedIds = Collections.EMPTY_LIST;
        }
        this.sortedIds = sortedIds;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getVisibleIds() {
        return this.visibleIds;
    }

    public List<String> getSortedIds() {
        return this.sortedIds;
    }

    public int getFixedColumns() {
        return this.fixedColumns;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public ColumnSpec getColumn(int i) {
        return this.columns.get(i);
    }

    public List<String> getColumnsIds() {
        ArrayList<String> result = new ArrayList<String>(this.columns.size());
        for (ColumnSpec c : this.columns) {
            result.add(c.getId());
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.id);
        out.writeInt(this.fixedColumns);
        out.writeObject(this.columns);
        out.writeObject(this.visibleIds);
        out.writeObject(this.sortedIds);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readUTF();
        this.fixedColumns = in.readInt();
        this.columns = (List)in.readObject();
        this.visibleIds = (List)in.readObject();
        this.sortedIds = (List)in.readObject();
    }

    public List<Object> getDefaultValues() {
        ArrayList<Object> l = new ArrayList<Object>();
        for (String id : this.visibleIds) {
            Object v = this.getColumn(id).getDefaultValue();
            l.add(v);
        }
        return l;
    }

    public ColumnSpec getColumn(String id) {
        for (ColumnSpec c : this.columns) {
            if (!c.getId().equals(id)) continue;
            return c;
        }
        return null;
    }

    public ColumnSpec getColumnWithEditor(String id) {
        for (ColumnSpec c : this.columns) {
            LightUIElement editor = c.getEditor();
            if (editor == null || !c.getEditor().getId().equals(id)) continue;
            return c;
        }
        return null;
    }
}

