/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.date;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.openconcerto.ui.date.DateRange;

public class DateRangeTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 5076344567233395335L;
    private final List<DateRange> ranges = new ArrayList<DateRange>();
    private final boolean withDesc;

    public DateRangeTableModel(boolean withDesc) {
        this.withDesc = withDesc;
    }

    @Override
    public int getRowCount() {
        return this.ranges.size();
    }

    @Override
    public int getColumnCount() {
        return this.withDesc ? 4 : 3;
    }

    public DateRange getRange(int index) {
        return this.ranges.get(index);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Calendar c = Calendar.getInstance();
        if (columnIndex == 0) {
            c.setTimeInMillis(this.ranges.get(rowIndex).getStart());
        } else if (columnIndex == 1) {
            c.setTimeInMillis(this.ranges.get(rowIndex).getStop());
        } else {
            if (columnIndex == 2) {
                DateRange r = this.ranges.get(rowIndex);
                int minutes = (int)(r.getStop() - r.getStart()) / 60000;
                return minutes;
            }
            return this.ranges.get(rowIndex).getInfos();
        }
        return c.getTime();
    }

    @Override
    public void setValueAt(Object aValue, final int rowIndex, int columnIndex) {
        if (!(columnIndex >= 2 || aValue != null && aValue instanceof Date)) {
            throw new IllegalArgumentException("Cannot set " + aValue + " at " + rowIndex + ":" + columnIndex);
        }
        if (columnIndex == 0) {
            long startTime = ((Date)aValue).getTime();
            this.ranges.get(rowIndex).setStart(startTime);
            long endTime = this.ranges.get(rowIndex).getStop();
            if (startTime > endTime) {
                Calendar c = Calendar.getInstance();
                c.setTimeInMillis(startTime);
                c.add(11, 1);
                this.setValueAt(c.getTime(), rowIndex, 1);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DateRangeTableModel.this.fireTableCellUpdated(rowIndex, 1);
                    }
                });
            }
        } else if (columnIndex == 1) {
            long endTime = ((Date)aValue).getTime();
            this.ranges.get(rowIndex).setStop(endTime);
            long startTime = this.ranges.get(rowIndex).getStart();
            if (startTime > endTime) {
                Calendar c = Calendar.getInstance();
                c.setTimeInMillis(endTime);
                c.add(11, -1);
                this.setValueAt(c.getTime(), rowIndex, 0);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DateRangeTableModel.this.fireTableCellUpdated(rowIndex, 0);
                    }
                });
            }
        } else if (columnIndex == 2) {
            int m = (Integer)aValue;
            this.ranges.get(rowIndex).setStop(this.ranges.get(rowIndex).getStart() + (long)(60000 * m));
        } else {
            this.ranges.get(rowIndex).setInfos((String)aValue);
        }
        this.fireTableDataChanged();
    }

    public void addNewLine() {
        long start = System.currentTimeMillis();
        for (DateRange r : this.ranges) {
            if (r.getStart() + 3600000L <= start) continue;
            start = r.getStart() + 86400000L;
        }
        this.ranges.add(new DateRange(start));
        this.fireTableDataChanged();
    }

    public void fillFrom(List<DateRange> list) {
        this.ranges.clear();
        this.ranges.addAll(list);
        Collections.sort(this.ranges);
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "D\u00e9but";
        }
        if (column == 1) {
            return "Fin";
        }
        if (column == 2) {
            return "Dur\u00e9e (minutes)";
        }
        return "R\u00e9sum\u00e9";
    }

    public void remove(int[] selection) {
        int i = selection.length - 1;
        while (i >= 0) {
            this.ranges.remove(selection[i]);
            --i;
        }
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }
}

