/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.date;

import com.ibm.icu.text.RuleBasedNumberFormat;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.JTime;
import org.openconcerto.ui.TM;
import org.openconcerto.ui.component.JRadioButtons;
import org.openconcerto.ui.date.DateRange;
import org.openconcerto.ui.date.DayOfWeek;
import org.openconcerto.ui.date.EventProvider;
import org.openconcerto.ui.date.EventProviders;
import org.openconcerto.ui.date.Period;
import org.openconcerto.utils.StringInputStream;
import org.openconcerto.utils.TimeUtils;
import org.openconcerto.utils.i18n.TM;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DateRangePlannerPanel
extends JPanel {
    private static final long serialVersionUID = 1006612828847678846L;
    private JTime timeStart;
    private JTime timeEnd;
    private Component currentPanel;
    private JRadioButtons<Period> radioPeriod;
    private Map<Period, Component> panels;
    private JRadioButton dayRadio1;
    private JRadioButton dayRadio2;
    private JDate dateStart;
    private JDate dateEnd;
    private JSpinner spinDateRangeCount;
    private JSpinner dayEveryDay;
    private JSpinner weekIncrementSpinner;
    private Set<DayOfWeek> weekDays;
    List<JCheckBox> weekCheckboxes = new ArrayList<JCheckBox>();
    private JRadioButton monthRadio1;
    private JRadioButton monthRadio2;
    private int monthIncrement = -1;
    private JSpinner spinDayOfMonth;
    private JComboBox comboWeekOfMonth;
    private JComboBox comboWeekDayOfMonth;
    private JSpinner spinMonth2;
    private JSpinner spinMonth3;
    private int yearlyMonth = -1;
    private JSpinner yearlyDayOfMonth;
    private JComboBox yearlyComboWeekOfMonth;
    private JComboBox yearlyComboWeekDayOfMonth;
    private JComboBox yearMonthCombo;
    private JComboBox yearMonthCombo2;
    private JRadioButton yearRadio1;
    private JRadioButton yearRadio2;
    private JRadioButton radioPeriodEndAt;
    private JRadioButton radioPeriodRepeat;
    private JRadioButton radioPeriodNeverEnd;

    public DateRangePlannerPanel() {
        this.weekDays = new HashSet<DayOfWeek>();
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        JLabelBold timeLabel = new JLabelBold("Horaires");
        this.add((Component)timeLabel, c);
        c.fill = 2;
        c.anchor = 18;
        c.weightx = 1.0;
        ++c.gridy;
        this.add(this.createTimePanel(), c);
        ++c.gridy;
        JLabelBold periodLabel = new JLabelBold("P\u00e9riodicit\u00e9");
        this.add((Component)periodLabel, c);
        ++c.gridy;
        this.add(this.createPerdiodPanel(), c);
        ++c.gridy;
        JLabel rangeLabel = new JLabel("Plage de p\u00e9riodicit\u00e9");
        this.add((Component)rangeLabel, c);
        ++c.gridy;
        c.weighty = 1.0;
        this.add(this.createRangePanel(), c);
    }

    private Component createTimePanel() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(0));
        p.add(new JLabel("Heure de d\u00e9but"));
        this.timeStart = new JTime(true, false);
        p.add(this.timeStart);
        p.add(new JLabel("  Fin"));
        this.timeEnd = new JTime(true, false);
        this.timeEnd.setTimeInMillis(Math.min(86399999L, this.timeStart.getTimeInMillis() + 3600000L));
        p.add(this.timeEnd);
        p.add(new JLabel("  Dur\u00e9e"));
        final JTextField duration = new JTextField(6);
        p.add(duration);
        p.add(new JLabel("minutes"));
        long delta = this.timeEnd.getTimeInMillis() - this.timeStart.getTimeInMillis();
        if (delta < 60000L) {
            this.timeStart.setTimeInMillis(this.timeEnd.getTimeInMillis() - 60000L);
        }
        duration.setText(String.valueOf(delta / 60000L));
        this.timeStart.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                long delta = DateRangePlannerPanel.this.timeEnd.getTimeInMillis() - DateRangePlannerPanel.this.timeStart.getTimeInMillis();
                if (delta < 60000L) {
                    DateRangePlannerPanel.this.timeEnd.setTimeInMillis(DateRangePlannerPanel.this.timeStart.getTimeInMillis() + 60000L);
                }
                duration.setText(String.valueOf(delta / 60000L));
            }
        });
        this.timeEnd.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                long delta = DateRangePlannerPanel.this.timeEnd.getTimeInMillis() - DateRangePlannerPanel.this.timeStart.getTimeInMillis();
                if (delta < 60000L) {
                    DateRangePlannerPanel.this.timeStart.setTimeInMillis(DateRangePlannerPanel.this.timeEnd.getTimeInMillis() - 60000L);
                }
                duration.setText(String.valueOf(delta / 60000L));
            }
        });
        duration.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                try {
                    int min = Integer.valueOf(duration.getText());
                    if (min > 0) {
                        long ms = DateRangePlannerPanel.this.timeStart.getTimeInMillis() + (long)(min * 60 * 1000);
                        DateRangePlannerPanel.this.timeEnd.setTimeInMillis(ms);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return p;
    }

    private Component createPerdiodPanel() {
        final JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        final DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        LinkedHashMap<Period, String> choices = new LinkedHashMap<Period, String>();
        choices.put(Period.DAY, "Quotidienne");
        choices.put(Period.WEEK, "Hebdomadaire");
        choices.put(Period.MONTH, "Mensuelle");
        choices.put(Period.YEAR, "Annuelle");
        this.radioPeriod = new JRadioButtons(false, choices);
        this.radioPeriod.setValue(Period.DAY);
        p.add(this.radioPeriod, c);
        ++c.gridx;
        c.fill = 3;
        p.add((Component)new JSeparator(1), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 1;
        this.panels = new HashMap<Period, Component>();
        this.panels.put(Period.DAY, this.createDayPanel());
        this.panels.put(Period.WEEK, this.createWeekPanel());
        this.panels.put(Period.MONTH, this.createMonthPanel());
        this.panels.put(Period.YEAR, this.createYearPanel());
        this.currentPanel = this.panels.get((Object)Period.DAY);
        p.add(this.currentPanel, c);
        this.currentPanel.setPreferredSize(new Dimension(this.currentPanel.getPreferredSize().width + 80, this.currentPanel.getPreferredSize().height));
        this.radioPeriod.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null) {
                    Period id = (Period)((Object)evt.getNewValue());
                    p.remove(DateRangePlannerPanel.this.currentPanel);
                    DateRangePlannerPanel.this.currentPanel = (Component)DateRangePlannerPanel.this.panels.get((Object)id);
                    p.add(DateRangePlannerPanel.this.currentPanel, c);
                    p.revalidate();
                    p.repaint();
                }
            }
        });
        return p;
    }

    private Component createRangePanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        p.add((Component)new JLabel("D\u00e9but"), c);
        c.fill = 0;
        ++c.gridx;
        this.dateStart = new JDate(true, true);
        p.add((Component)((Object)this.dateStart), c);
        ++c.gridx;
        c.anchor = 17;
        this.radioPeriodEndAt = new JRadioButton("Fin le");
        this.radioPeriodEndAt.setSelected(true);
        p.add((Component)this.radioPeriodEndAt, c);
        ++c.gridx;
        this.dateEnd = new JDate(false, true);
        Calendar cal = Calendar.getInstance();
        cal.add(6, 7);
        this.dateEnd.setValue(cal.getTime());
        c.gridwidth = 2;
        p.add((Component)((Object)this.dateEnd), c);
        ++c.gridy;
        c.gridwidth = 1;
        c.gridx = 2;
        this.radioPeriodRepeat = new JRadioButton("Fin apr\u00e8s");
        p.add((Component)this.radioPeriodRepeat, c);
        ++c.gridx;
        this.spinDateRangeCount = new JSpinner(new SpinnerNumberModel(1, 1, 36500, 1));
        this.spinDateRangeCount.setEnabled(false);
        p.add((Component)this.spinDateRangeCount, c);
        ++c.gridx;
        c.weightx = 1.0;
        p.add((Component)new JLabel("occurences"), c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.gridx = 2;
        this.radioPeriodNeverEnd = new JRadioButton("Pas de fin");
        p.add((Component)this.radioPeriodNeverEnd, c);
        ++c.gridx;
        ButtonGroup group = new ButtonGroup();
        group.add(this.radioPeriodEndAt);
        group.add(this.radioPeriodRepeat);
        group.add(this.radioPeriodNeverEnd);
        this.radioPeriodEndAt.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DateRangePlannerPanel.this.spinDateRangeCount.setEnabled(DateRangePlannerPanel.this.radioPeriodRepeat.isSelected());
                DateRangePlannerPanel.this.dateEnd.setEnabled(!DateRangePlannerPanel.this.radioPeriodRepeat.isSelected());
            }
        });
        this.radioPeriodRepeat.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DateRangePlannerPanel.this.spinDateRangeCount.setEnabled(DateRangePlannerPanel.this.radioPeriodRepeat.isSelected());
                DateRangePlannerPanel.this.dateEnd.setEnabled(!DateRangePlannerPanel.this.radioPeriodRepeat.isSelected());
            }
        });
        this.radioPeriodNeverEnd.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DateRangePlannerPanel.this.spinDateRangeCount.setEnabled(false);
                DateRangePlannerPanel.this.dateEnd.setEnabled(false);
            }
        });
        return p;
    }

    private Component createDayPanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.insets = new Insets(0, 0, 0, 2);
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0, 4, 0));
        this.dayRadio1 = new JRadioButton("Tous les ");
        this.dayRadio1.setSelected(true);
        this.dayEveryDay = new JSpinner(new SpinnerNumberModel(1, 1, 365, 1));
        final JLabel labelEvery = new JLabel("jour");
        this.dayEveryDay.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DateRangePlannerPanel.this.dayEveryDay.getValue().toString().equals("1")) {
                    labelEvery.setText("jour");
                } else {
                    labelEvery.setText("jours");
                }
            }
        });
        p1.add(this.dayRadio1);
        p1.add(this.dayEveryDay);
        p1.add(labelEvery);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(0, 2, 0));
        this.dayRadio2 = new JRadioButton("Tous les jours ouvrables");
        p2.add(this.dayRadio2);
        this.dayRadio1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DateRangePlannerPanel.this.dayEveryDay.setEnabled(DateRangePlannerPanel.this.dayRadio1.isSelected());
            }
        });
        this.dayRadio2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DateRangePlannerPanel.this.dayEveryDay.setEnabled(DateRangePlannerPanel.this.dayRadio1.isSelected());
            }
        });
        ButtonGroup g = new ButtonGroup();
        g.add(this.dayRadio1);
        g.add(this.dayRadio2);
        p1.setOpaque(false);
        p2.setOpaque(false);
        c.anchor = 18;
        c.weightx = 1.0;
        c.fill = 2;
        p.add((Component)p1, c);
        ++c.gridy;
        c.weighty = 1.0;
        p.add((Component)p2, c);
        return p;
    }

    private Component createWeekPanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.insets = new Insets(0, 4, 0, 4);
        c.anchor = 18;
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0, 4, 0));
        p1.add(new JLabel("Toutes les"));
        this.weekIncrementSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 365, 1));
        final JLabel labelEvery = new JLabel("semaine, le :");
        this.weekIncrementSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DateRangePlannerPanel.this.weekIncrementSpinner.getValue().toString().equals("1")) {
                    labelEvery.setText("semaine, le :");
                } else {
                    labelEvery.setText("semaines, le :");
                }
            }
        });
        p1.add(this.weekIncrementSpinner);
        p1.add(labelEvery);
        c.gridwidth = 4;
        p.add((Component)p1, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        String[] namesOfDays = DateFormatSymbols.getInstance().getWeekdays();
        DayOfWeek[] week = DayOfWeek.getWeek(Calendar.getInstance());
        int weekLength = week.length;
        int midWeek = weekLength / 2;
        int i = 0;
        while (i < weekLength) {
            final DayOfWeek d = week[i];
            c.weightx = i == midWeek ? 1.0 : 0.0;
            JCheckBox cb = new JCheckBox(namesOfDays[d.getCalendarField()]);
            cb.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        DateRangePlannerPanel.this.weekDays.add(d);
                    } else {
                        DateRangePlannerPanel.this.weekDays.remove((Object)d);
                    }
                }
            });
            p.add((Component)cb, c);
            this.weekCheckboxes.add(cb);
            if (i == midWeek) {
                c.gridx = 0;
                ++c.gridy;
                c.weighty = 1.0;
            } else {
                ++c.gridx;
            }
            ++i;
        }
        return p;
    }

    protected final void setMonthIncrement(Object src) {
        this.monthIncrement = (Integer)((JSpinner)src).getValue();
    }

    private Component createMonthPanel() {
        Calendar cal = Calendar.getInstance();
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.insets = new Insets(0, 4, 0, 4);
        c.anchor = 18;
        c.weightx = 1.0;
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0, 4, 0));
        this.monthRadio1 = new JRadioButton("Le");
        this.monthRadio1.setSelected(true);
        p1.add(this.monthRadio1);
        this.spinDayOfMonth = this.createDayOfMonthSpinner(cal);
        p1.add(this.spinDayOfMonth);
        p1.add(new JLabel("tous les"));
        this.spinMonth2 = new JSpinner(new SpinnerNumberModel(1, 1, 96, 1));
        ChangeListener setMonthIncrementCL = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DateRangePlannerPanel.this.setMonthIncrement(e.getSource());
            }
        };
        this.spinMonth2.addChangeListener(setMonthIncrementCL);
        p1.add(this.spinMonth2);
        p1.add(new JLabel("mois"));
        p.add((Component)p1, c);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(0, 4, 0));
        this.monthRadio2 = new JRadioButton("Le");
        p2.add(this.monthRadio2);
        this.comboWeekOfMonth = this.createWeekOfMonthCombo();
        p2.add(this.comboWeekOfMonth);
        this.comboWeekDayOfMonth = this.createWeekDayOfMonthCombo(cal);
        p2.add(this.comboWeekDayOfMonth);
        p2.add(new JLabel("tous les"));
        this.spinMonth3 = new JSpinner(new SpinnerNumberModel(1, 1, 96, 1));
        p2.add(this.spinMonth3);
        p2.add(new JLabel("mois"));
        this.spinMonth3.addChangeListener(setMonthIncrementCL);
        ++c.gridy;
        c.weighty = 1.0;
        p.add((Component)p2, c);
        ButtonGroup g = new ButtonGroup();
        g.add(this.monthRadio1);
        g.add(this.monthRadio2);
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = DateRangePlannerPanel.this.monthRadio1.isSelected();
                DateRangePlannerPanel.this.spinDayOfMonth.setEnabled(selected);
                DateRangePlannerPanel.this.spinMonth2.setEnabled(selected);
                DateRangePlannerPanel.this.comboWeekOfMonth.setEnabled(!selected);
                DateRangePlannerPanel.this.comboWeekDayOfMonth.setEnabled(!selected);
                DateRangePlannerPanel.this.spinMonth3.setEnabled(!selected);
                DateRangePlannerPanel.this.setMonthIncrement(selected ? DateRangePlannerPanel.this.spinMonth2 : DateRangePlannerPanel.this.spinMonth3);
            }
        };
        this.monthRadio1.addItemListener(listener);
        this.monthRadio2.addItemListener(listener);
        listener.itemStateChanged(null);
        return p;
    }

    protected JSpinner createDayOfMonthSpinner(Calendar cal) {
        int minDayOfMonth = cal.getMinimum(5);
        int maxDayOfMonth = cal.getMaximum(5);
        return new JSpinner(new SpinnerNumberModel(minDayOfMonth, minDayOfMonth, maxDayOfMonth, 1));
    }

    protected JComboBox createWeekOfMonthCombo() {
        JComboBox<Object> res = new JComboBox<Object>(new Object[]{1, 2, 3, 4, -2, -1});
        final RuleBasedNumberFormat f = new RuleBasedNumberFormat(1);
        String rule = TM.getInstance().translate(TM.MissingMode.NULL, "day.spelloutRule", new Object[0]);
        if (rule != null) {
            f.setDefaultRuleSet(rule);
        }
        res.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                long weekIndex = ((Number)value).longValue();
                String v = weekIndex == -2L ? TM.getInstance().translate("day.spellout.beforeLast", new Object[0]) : (weekIndex == -1L ? TM.getInstance().translate("day.spellout.last", new Object[0]) : f.format(weekIndex));
                return super.getListCellRendererComponent((JList<?>)list, v, index, isSelected, cellHasFocus);
            }
        });
        return res;
    }

    protected JComboBox createWeekDayOfMonthCombo(Calendar cal) {
        final String[] namesOfDays = DateFormatSymbols.getInstance().getWeekdays();
        DayOfWeek[] week = DayOfWeek.getWeek(cal);
        JComboBox<DayOfWeek> res = new JComboBox<DayOfWeek>(week);
        res.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, namesOfDays[((DayOfWeek)((Object)value)).getCalendarField()], index, isSelected, cellHasFocus);
            }
        });
        return res;
    }

    protected JComboBox createMonthCombo() {
        final String[] namesOfMonths = DateFormatSymbols.getInstance().getMonths();
        Object[] monthsIndex = new Object[namesOfMonths.length];
        int i = 0;
        while (i < namesOfMonths.length) {
            monthsIndex[i] = i;
            ++i;
        }
        JComboBox<Object> res = new JComboBox<Object>(monthsIndex);
        res.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, namesOfMonths[((Number)value).intValue()], index, isSelected, cellHasFocus);
            }
        });
        return res;
    }

    private Component createYearPanel() {
        Calendar cal = Calendar.getInstance();
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.insets = new Insets(0, 4, 0, 4);
        c.anchor = 18;
        c.weightx = 1.0;
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0, 4, 0));
        this.yearRadio1 = new JRadioButton("Chaque");
        this.yearRadio1.setSelected(true);
        p1.add(this.yearRadio1);
        this.yearlyDayOfMonth = this.createDayOfMonthSpinner(cal);
        p1.add(this.yearlyDayOfMonth);
        this.yearMonthCombo = this.createMonthCombo();
        p1.add(this.yearMonthCombo);
        p.add((Component)p1, c);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(0, 4, 0));
        this.yearRadio2 = new JRadioButton("Le");
        p2.add(this.yearRadio2);
        this.yearlyComboWeekOfMonth = this.createWeekOfMonthCombo();
        p2.add(this.yearlyComboWeekOfMonth);
        this.yearlyComboWeekDayOfMonth = this.createWeekDayOfMonthCombo(cal);
        p2.add(this.yearlyComboWeekDayOfMonth);
        p2.add(new JLabel("de"));
        this.yearMonthCombo2 = this.createMonthCombo();
        p2.add(this.yearMonthCombo2);
        ++c.gridy;
        c.weighty = 1.0;
        p.add((Component)p2, c);
        ButtonGroup g = new ButtonGroup();
        g.add(this.yearRadio1);
        g.add(this.yearRadio2);
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = DateRangePlannerPanel.this.yearRadio1.isSelected();
                DateRangePlannerPanel.this.yearlyDayOfMonth.setEnabled(selected);
                DateRangePlannerPanel.this.yearMonthCombo.setEnabled(selected);
                DateRangePlannerPanel.this.yearlyComboWeekOfMonth.setEnabled(!selected);
                DateRangePlannerPanel.this.yearlyComboWeekDayOfMonth.setEnabled(!selected);
                DateRangePlannerPanel.this.yearMonthCombo2.setEnabled(!selected);
                DateRangePlannerPanel.this.setYearlyMonth(selected ? DateRangePlannerPanel.this.yearMonthCombo : DateRangePlannerPanel.this.yearMonthCombo2);
            }
        };
        this.yearRadio1.addItemListener(listener);
        this.yearRadio2.addItemListener(listener);
        ItemListener monthL = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DateRangePlannerPanel.this.setYearlyMonth(e.getSource());
                }
            }
        };
        this.yearMonthCombo.addItemListener(monthL);
        this.yearMonthCombo2.addItemListener(monthL);
        listener.itemStateChanged(null);
        return p;
    }

    protected final void setYearlyMonth(Object comp) {
        this.yearlyMonth = (Integer)((JComboBox)comp).getSelectedItem();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                JFrame f = new JFrame();
                JPanel p = new JPanel();
                final DateRangePlannerPanel planner = new DateRangePlannerPanel();
                p.setLayout(new BorderLayout());
                p.add((Component)planner, "Center");
                JButton b = new JButton("Print ranges");
                p.add((Component)b, "South");
                b.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        List<DateRange> ranges = planner.getRanges();
                        System.out.println("---- " + ranges.size() + " ranges :");
                        for (DateRange dateRange : ranges) {
                            System.out.println(dateRange);
                        }
                        String configXML = planner.getConfigXML();
                        System.out.println(configXML);
                        try {
                            planner.configureFromXML(configXML);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                });
                f.setContentPane(p);
                f.pack();
                f.setDefaultCloseOperation(3);
                f.setVisible(true);
            }
        });
    }

    public List<DateRange> getRanges() {
        EventProvider prov;
        int incr;
        Calendar c;
        int eventCount;
        Date endDate;
        Period type = this.radioPeriod.getValue();
        Date startDate = this.dateStart.getValue();
        int timeStartInMS = this.timeStart.getTimeInMillis().intValue();
        int timeEndInMS = this.timeEnd.getTimeInMillis().intValue();
        if (this.radioPeriodEndAt.isSelected()) {
            endDate = this.dateEnd.getValue();
            if (endDate.compareTo(startDate) < 0) {
                throw new IllegalArgumentException("End before start");
            }
            eventCount = -1;
        } else if (this.radioPeriodNeverEnd.isSelected()) {
            c = Calendar.getInstance();
            c.add(1, 20);
            endDate = c.getTime();
            if (endDate.compareTo(startDate) < 0) {
                throw new IllegalArgumentException("End before start");
            }
            eventCount = -1;
        } else {
            endDate = null;
            eventCount = ((Number)this.spinDateRangeCount.getValue()).intValue();
            if (eventCount <= 0) {
                throw new IllegalArgumentException("Negative event count : " + eventCount);
            }
        }
        c = Calendar.getInstance();
        c.setTime(startDate);
        if (type == Period.DAY) {
            if (this.dayRadio1.isSelected()) {
                incr = ((Number)this.dayEveryDay.getValue()).intValue();
                prov = new EventProviders.Daily(incr);
            } else {
                prov = new EventProviders.Weekly(1, DayOfWeek.WORKING_DAYS);
            }
        } else if (type == Period.WEEK) {
            if (this.weekDays.isEmpty()) {
                prov = null;
            } else {
                incr = ((Number)this.weekIncrementSpinner.getValue()).intValue();
                prov = new EventProviders.Weekly(incr, this.weekDays);
            }
        } else if (type == Period.MONTH) {
            prov = this.spinDayOfMonth.isEnabled() ? new EventProviders.Monthly((Integer)this.spinDayOfMonth.getValue(), this.monthIncrement) : new EventProviders.MonthlyDayOfWeek((Integer)this.comboWeekOfMonth.getSelectedItem(), (DayOfWeek)((Object)this.comboWeekDayOfMonth.getSelectedItem()), this.monthIncrement);
        } else if (type == Period.YEAR) {
            prov = this.yearlyDayOfMonth.isEnabled() ? new EventProviders.Yearly((Integer)this.yearlyDayOfMonth.getValue(), this.yearlyMonth, 1) : new EventProviders.YearlyDayOfWeekEventProvider((Integer)this.yearlyComboWeekOfMonth.getSelectedItem(), (DayOfWeek)((Object)this.yearlyComboWeekDayOfMonth.getSelectedItem()), this.yearlyMonth, 1);
        } else {
            throw new IllegalStateException("invalid type: " + (Object)((Object)type));
        }
        if (prov == null) {
            return new ArrayList<DateRange>(0);
        }
        prov.next(c, true);
        ArrayList<DateRange> result = new ArrayList<DateRange>();
        Calendar startStopCal = (Calendar)c.clone();
        while (this.before(c, endDate) && this.lessThan(result.size(), eventCount)) {
            DateRange r = new DateRange();
            Date currentTime = c.getTime();
            startStopCal.setTime(currentTime);
            this.setStartAndStop(r, startStopCal, timeStartInMS, timeEndInMS);
            result.add(r);
            prov.next(c, false);
            if (currentTime.compareTo(c.getTime()) < 0) continue;
            throw new IllegalStateException("Provider hasn't moved time forward");
        }
        return result;
    }

    private boolean before(Calendar c, Date endDate) {
        if (endDate == null) {
            return true;
        }
        return c.getTime().compareTo(endDate) <= 0;
    }

    private boolean lessThan(int currentEventCount, int eventCount) {
        if (eventCount < 0) {
            return true;
        }
        return currentEventCount < eventCount;
    }

    protected void setStartAndStop(DateRange r, Calendar c, int timeStartInMS, int timeEndInMS) {
        int day = c.get(6);
        TimeUtils.clearTime(c);
        c.add(14, timeStartInMS);
        if (c.get(6) != day) {
            throw new IllegalArgumentException("More than a day : " + timeStartInMS);
        }
        r.setStart(c.getTimeInMillis());
        if (timeEndInMS < timeStartInMS) {
            TimeUtils.clearTime(c);
            c.add(6, 1);
            c.add(14, timeEndInMS);
            assert (c.get(6) == day + 1);
        } else {
            c.add(14, timeEndInMS - timeStartInMS);
            if (c.get(6) != day) {
                throw new IllegalArgumentException("More than a day : " + timeEndInMS);
            }
        }
        r.setStop(c.getTimeInMillis());
    }

    public String getConfigXML() {
        StringBuilder b = new StringBuilder();
        b.append("<planner>");
        b.append("<schedule start=\"");
        b.append(this.timeStart.getTimeInMillis());
        b.append("\" end=\"");
        b.append(this.timeEnd.getTimeInMillis());
        b.append("\" />");
        Period p = this.radioPeriod.getValue();
        int f = p.getCalendarField();
        b.append("<period type=\"");
        b.append(f);
        b.append("\">");
        if (f == Period.DAY.getCalendarField()) {
            b.append("<day every=\"");
            if (this.dayRadio1.isSelected()) {
                b.append(this.dayEveryDay.getValue());
            } else {
                b.append("wd");
            }
            b.append("\" />");
        } else if (f == Period.WEEK.getCalendarField()) {
            b.append("<week every=\"");
            b.append(this.weekIncrementSpinner.getValue());
            b.append("\">");
            for (JCheckBox cb : this.weekCheckboxes) {
                if (cb.isSelected()) {
                    b.append("<true/>");
                    continue;
                }
                b.append("<false/>");
            }
            b.append("</week>");
        } else if (f == Period.MONTH.getCalendarField()) {
            if (this.monthRadio1.isSelected()) {
                b.append("<month day=\"");
                b.append(this.spinDayOfMonth.getValue());
                b.append("\" every=\"");
                b.append(this.spinMonth2.getValue());
                b.append("\" />");
            } else {
                b.append("<month weekOfMonth=\"");
                b.append(this.comboWeekOfMonth.getSelectedIndex());
                b.append("\" dayOfMonth=\"");
                b.append(this.comboWeekDayOfMonth.getSelectedIndex());
                b.append("\" every=\"");
                b.append(this.spinMonth3.getValue());
                b.append("\" />");
            }
        } else if (f == Period.YEAR.getCalendarField()) {
            if (this.yearRadio1.isSelected()) {
                b.append("<year day=\"");
                b.append(this.yearlyDayOfMonth.getValue());
                b.append("\" month=\"");
                b.append(this.yearMonthCombo.getSelectedIndex());
                b.append("\" />");
            } else {
                b.append("<year weekOfMonth=\"");
                b.append(this.yearlyComboWeekOfMonth.getSelectedIndex());
                b.append("\" weekDayOfMonth=\"");
                b.append(this.yearlyComboWeekDayOfMonth.getSelectedIndex());
                b.append("\" month=\"");
                b.append(this.yearMonthCombo2.getSelectedIndex());
                b.append("\" />");
            }
        } else {
            throw new IllegalStateException("Unknown period:" + f);
        }
        b.append("</period>");
        b.append("<range start=\"");
        b.append(this.dateStart.getValue().getTime());
        b.append("\" ");
        if (this.radioPeriodEndAt.isSelected()) {
            b.append("end=\"");
            b.append(this.dateEnd.getValue().getTime());
            b.append("\"");
        } else if (this.radioPeriodRepeat.isSelected()) {
            b.append("repeat=\"");
            b.append(this.spinDateRangeCount.getValue().toString());
            b.append("\"");
        }
        b.append("/>");
        b.append("</planner>");
        return b.toString();
    }

    public void configureFromXML(String xml) throws Exception {
        Integer weekOfMonth;
        Integer d;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = db.parse(new StringInputStream(xml, "UTF8"));
        NodeList l1 = dom.getElementsByTagName("schedule");
        Node nSchedule = l1.item(0);
        long tStart = this.getAttributeAsLong(nSchedule, "start");
        long tStop = this.getAttributeAsLong(nSchedule, "end");
        this.timeEnd.setTimeInMillis(tStop);
        this.timeStart.setTimeInMillis(tStart);
        NodeList l2 = dom.getElementsByTagName("period");
        Node nPeriod = l2.item(0);
        int perioType = Integer.parseInt(nPeriod.getAttributes().getNamedItem("type").getTextContent());
        if (perioType == Period.DAY.getCalendarField()) {
            this.radioPeriod.setValue(Period.DAY);
            Node nDay = nPeriod.getFirstChild();
            Integer l = this.getAttributeAsInteger(nDay, "every");
            if (l != null) {
                this.dayRadio1.setSelected(true);
                this.dayEveryDay.setValue(l);
            } else {
                this.dayRadio2.setSelected(false);
            }
        } else if (perioType == Period.WEEK.getCalendarField()) {
            this.radioPeriod.setValue(Period.WEEK);
            Node nWeek = nPeriod.getFirstChild();
            Integer e = this.getAttributeAsInteger(nWeek, "every");
            this.weekIncrementSpinner.setValue(e);
            NodeList l = nWeek.getChildNodes();
            int i = 0;
            while (i < l.getLength()) {
                Node n = l.item(i);
                this.weekCheckboxes.get(i).setSelected(n.getNodeName().equals("true"));
                ++i;
            }
        } else if (perioType == Period.MONTH.getCalendarField()) {
            this.radioPeriod.setValue(Period.MONTH);
            Node nMonth = nPeriod.getFirstChild();
            d = this.getAttributeAsInteger(nMonth, "day");
            if (d != null) {
                this.monthRadio1.setSelected(true);
                Integer every = this.getAttributeAsInteger(nMonth, "every");
                this.spinDayOfMonth.setValue(d);
                this.spinMonth2.setValue(every);
            } else {
                this.monthRadio2.setSelected(true);
                weekOfMonth = this.getAttributeAsInteger(nMonth, "weekOfMonth");
                Integer dayOfMonth = this.getAttributeAsInteger(nMonth, "dayOfMonth");
                Integer every = this.getAttributeAsInteger(nMonth, "every");
                this.comboWeekOfMonth.setSelectedIndex(weekOfMonth);
                this.comboWeekDayOfMonth.setSelectedIndex(dayOfMonth);
                this.spinMonth3.setValue(every);
            }
        } else if (perioType == Period.YEAR.getCalendarField()) {
            this.radioPeriod.setValue(Period.YEAR);
            Node nYear = nPeriod.getFirstChild();
            d = this.getAttributeAsInteger(nYear, "day");
            if (d != null) {
                this.yearRadio1.setSelected(true);
                Integer m = this.getAttributeAsInteger(nYear, "month");
                this.yearlyDayOfMonth.setValue(d);
                this.yearMonthCombo.setSelectedIndex(m);
            } else {
                this.yearRadio2.setSelected(true);
                weekOfMonth = this.getAttributeAsInteger(nYear, "weekOfMonth");
                this.yearlyComboWeekOfMonth.setSelectedIndex(weekOfMonth);
                Integer weekDayOfMonth = this.getAttributeAsInteger(nYear, "weekDayOfMonth");
                this.yearlyComboWeekDayOfMonth.setSelectedIndex(weekDayOfMonth);
                Integer m = this.getAttributeAsInteger(nYear, "month");
                this.yearMonthCombo2.setSelectedIndex(m);
            }
        } else {
            throw new IllegalStateException("Unknown period:" + perioType);
        }
        NodeList l3 = dom.getElementsByTagName("range");
        Node nRange = l3.item(0);
        Long start = this.getAttributeAsLong(nRange, "start");
        Long end = this.getAttributeAsLong(nRange, "end");
        Integer repeat = this.getAttributeAsInteger(nRange, "repeat");
        this.dateStart.setValue(new Date(start));
        if (end != null) {
            this.radioPeriodEndAt.setSelected(true);
            this.dateEnd.setValue(new Date(end));
        } else if (repeat != null) {
            this.radioPeriodRepeat.setSelected(true);
            this.spinDateRangeCount.setValue(repeat);
        } else {
            this.radioPeriodNeverEnd.setSelected(true);
        }
    }

    private Long getAttributeAsLong(Node item, String attrName) {
        Node n = item.getAttributes().getNamedItem(attrName);
        if (n == null) {
            return null;
        }
        try {
            long l = Long.parseLong(n.getTextContent());
            return l;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Integer getAttributeAsInteger(Node item, String attrName) {
        Node n = item.getAttributes().getNamedItem(attrName);
        if (n == null) {
            return null;
        }
        try {
            int l = Integer.parseInt(n.getTextContent());
            return l;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setStartDate(Date d) {
        this.dateStart.setDate(d);
    }
}

