/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.calendar.DateSpan;
import org.jdesktop.swingx.calendar.JMonthViewListener;
import org.jdesktop.swingx.calendar.JXMonthView;
import org.openconcerto.ui.SpinnerCyclicModel;
import org.openconcerto.ui.table.TimestampTableCellEditor;

public class TimestampEditorPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private JSpinner spinHour;
    private JSpinner spinMinute;
    private JPanel panelHour;
    private JXMonthView monthView;
    private List<ActionListener> listeners = new Vector<ActionListener>();
    private TimestampTableCellEditor aCellEditor;

    public TimestampEditorPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 3, 0, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 13;
        c.fill = 2;
        this.panelHour = new JPanel(new GridBagLayout());
        JLabel labelHour = new JLabel("Heure: ");
        labelHour.setFont(labelHour.getFont().deriveFont(1));
        this.panelHour.add((Component)labelHour, c);
        ++c.gridx;
        this.spinHour = new JSpinner(new SpinnerCyclicModel(0L, 0L, 23L, 1L));
        this.spinHour.setEditor(new JSpinner.NumberEditor(this.spinHour, "00"));
        this.panelHour.add((Component)this.spinHour, c);
        ++c.gridx;
        JLabel labelSeparator = new JLabel(":");
        labelSeparator.setFont(labelSeparator.getFont().deriveFont(1));
        this.panelHour.add((Component)labelSeparator, c);
        ++c.gridx;
        this.spinMinute = new JSpinner(new SpinnerCyclicModel(0L, 0L, 59L, 1L));
        this.spinMinute.setEditor(new JSpinner.NumberEditor(this.spinMinute, "00"));
        this.panelHour.add((Component)this.spinMinute, c);
        ++c.gridx;
        final JButton buttonClose = new JButton(new ImageIcon(TimestampEditorPanel.class.getResource("close_popup.png")));
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TimestampEditorPanel.this.aCellEditor != null) {
                    TimestampEditorPanel.this.aCellEditor.hidePopup();
                    TimestampEditorPanel.this.aCellEditor.stopCellEditing();
                }
            }
        });
        buttonClose.setBorderPainted(false);
        buttonClose.setOpaque(false);
        buttonClose.setFocusPainted(false);
        buttonClose.setMargin(new Insets(0, 1, 0, 1));
        c.gridx = 0;
        this.panelHour.setOpaque(false);
        this.add((Component)this.panelHour, c);
        c.fill = 0;
        c.anchor = 12;
        c.weightx = 1.0;
        ++c.gridx;
        this.add((Component)buttonClose, c);
        this.setBackground(Color.WHITE);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.fill = 1;
        c.weighty = 1.0;
        this.monthView = new JXMonthView();
        this.monthView.setFirstDayOfWeek(Calendar.getInstance().getFirstDayOfWeek());
        this.monthView.setTraversable(true);
        JXDatePicker p = new JXDatePicker();
        p.setMonthView(this.monthView);
        this.add((Component)this.monthView, c);
        ++c.gridy;
        this.add((Component)new JXDatePicker.TodayPanel(p), c);
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.monthView.addActionListener((ActionListener)this);
        this.spinHour.addChangeListener(this);
        this.spinMinute.addChangeListener(this);
        this.monthView.addMouseListener(new JMonthViewListener(){

            public void doubleClickOnDayPerformed() {
                buttonClose.doClick();
            }
        });
    }

    public void setTime(Date time) {
        Calendar c = Calendar.getInstance();
        c.setTime(time);
        this.spinHour.setValue(new Long(c.get(11)));
        this.spinMinute.setValue(new Long(c.get(12)));
        this.monthView.setFirstDayOfWeek(c.getFirstDayOfWeek());
        this.monthView.setFlaggedDates(new long[]{time.getTime()});
        this.monthView.ensureDateVisible(time.getTime());
        this.monthView.setSelectedDateSpan(new DateSpan(time, time));
    }

    public Timestamp getTime() {
        long t = this.monthView.getSelectedDateSpan().getStart();
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(t);
        try {
            String h = this.spinHour.getValue().toString().trim();
            Integer iH = Integer.valueOf(h);
            h = this.spinMinute.getValue().toString().trim();
            Integer iM = Integer.valueOf(h);
            c.set(11, iH);
            c.set(12, iM);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Timestamp(c.getTimeInMillis());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireTimeChangedPerformed();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireTimeChangedPerformed();
    }

    private void fireTimeChangedPerformed() {
        int i = 0;
        while (i < this.listeners.size()) {
            ActionListener element = this.listeners.get(i);
            element.actionPerformed(null);
            ++i;
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    public void setCellEditor(TimestampTableCellEditor editor) {
        this.aCellEditor = editor;
    }

    public void setHourVisible(boolean b) {
        this.panelHour.setVisible(b);
    }

    public final class TodayPanel
    extends JXPanel {
        public TodayPanel() {
            super((LayoutManager)new FlowLayout());
            this.setDrawGradient(true);
            this.setGradientPaint(new GradientPaint(0.0f, 0.0f, new Color(238, 238, 238), 0.0f, 1.0f, Color.WHITE));
            JXHyperlink todayLink = new JXHyperlink((Action)new TodayAction());
            Color textColor = new Color(16, 66, 104);
            todayLink.setUnclickedColor(textColor);
            todayLink.setClickedColor(textColor);
            this.add((Component)todayLink);
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(new Color(187, 187, 187));
            g.drawLine(0, 0, this.getWidth(), 0);
            g.setColor(new Color(221, 221, 221));
            g.drawLine(0, 1, this.getWidth(), 1);
        }

        private final class TodayAction
        extends AbstractAction {
            TodayAction() {
                super(new MessageFormat(UIManager.getString("JXDatePicker.linkFormat")).format(new Object[]{new Date(System.currentTimeMillis())}));
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                long _linkDate = System.currentTimeMillis();
                DateSpan span = new DateSpan(_linkDate, _linkDate);
                TimestampEditorPanel.this.monthView.ensureDateVisible(span.getStart());
            }
        }
    }
}

