/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DateFormat;
import java.util.Calendar;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class RangeSlider
extends JPanel
implements ComponentListener,
MouseListener,
MouseMotionListener {
    private boolean isResized;
    private Image backgroundImage;
    private Image cursor1;
    private Image cursor2;
    private int cursor_size;
    private int width;
    private int height;
    private int margin;
    private int c1_pos;
    private int c2_pos;
    private double tk;
    private int old_pos;
    private int scaleY;
    private int last_dragged;
    private int precision;
    private long min;
    private long max;
    private double cur_min;
    private double cur_max;
    private boolean isCurMinSet;
    private boolean isCurMaxSet;
    protected boolean draggable1;
    protected boolean draggable2;
    private String leftHintText;
    private Rectangle leftHintRect;
    private String rightHintText;
    private Rectangle rightHintRect;
    private Font font;
    private FontMetrics fm;
    private static Calendar cal = Calendar.getInstance();
    private int year;
    long COEF = 86400000L;

    public RangeSlider(int year) {
        this.year = year;
        this.isResized = true;
        this.cursor_size = 20;
        this.margin = 5;
        this.width = 2 * this.margin + RangeSlider.getNbDayOfYear(year - 1) + RangeSlider.getNbDayOfYear(year);
        this.height = 50;
        this.last_dragged = 1;
        this.isCurMinSet = false;
        this.isCurMaxSet = false;
        this.draggable1 = false;
        this.draggable2 = false;
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.cursor1 = new ImageIcon(RangeSlider.class.getResource("cursor.png")).getImage();
        this.cursor2 = new ImageIcon(RangeSlider.class.getResource("cursor.png")).getImage();
        this.min = RangeSlider.timeOfFirstDayOfYear(year - 1);
        this.max = RangeSlider.timeOfLastDayOfYear(year);
        this.c1_pos = 0;
        this.c2_pos = 365;
    }

    private static long timeOfFirstDayOfYear(int ayear) {
        cal.set(ayear, 0, 1);
        return cal.getTimeInMillis();
    }

    private static long timeOfLastDayOfYear(int ayear) {
        cal.set(ayear, 11, 31);
        return cal.getTimeInMillis();
    }

    private static int getNbDayOfYear(int ayear) {
        cal.set(ayear, 11, 31);
        int nbday = cal.get(6);
        return nbday;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.font = this.getFont();
        if (this.isResized) {
            Dimension dimension = this.getSize();
            this.width = dimension.width;
            this.height = dimension.height;
            this.scaleY = this.height / 2;
            this.createScale(g);
            if (this.isCurMinSet) {
                this.setValue(0, this.cur_min);
            } else {
                this.c1_pos = this.margin;
            }
            if (this.isCurMaxSet) {
                this.setValue(1, this.cur_max);
            } else {
                this.c2_pos = dimension.width - this.margin;
            }
            this.isResized = false;
        }
        if (this.fm == null) {
            this.fm = g.getFontMetrics(this.font);
            this.c1_pos = this.margin;
            this.c2_pos = this.width - this.margin;
            this.computeLeftRect(this.c1_pos);
            this.computeRightRect(this.c2_pos);
        }
        g.drawImage(this.backgroundImage, 0, 0, this);
        if (this.c1_pos == this.c2_pos && this.last_dragged == 1 || this.c1_pos != this.c2_pos) {
            g.drawImage(this.cursor1, 2 + this.c1_pos - this.cursor_size / 2, 9 + this.scaleY - this.cursor_size / 2, this);
        }
        if (this.c1_pos == this.c2_pos && this.last_dragged == 2 || this.c1_pos != this.c2_pos) {
            g.drawImage(this.cursor2, 2 + this.c2_pos - this.cursor_size / 2, 9 + this.scaleY - this.cursor_size / 2, this);
        }
        g.setFont(this.font);
        if (this.leftHintRect != null) {
            g.setColor(Color.WHITE);
            g.fillRect(this.leftHintRect.x, this.leftHintRect.y, this.leftHintRect.width, this.leftHintRect.height);
            g.setColor(Color.black);
            g.drawString(this.leftHintText, this.leftHintRect.x, this.leftHintRect.y + this.fm.getHeight() - 3);
        }
        if (this.rightHintRect != null) {
            g.setColor(Color.WHITE);
            g.fillRect(this.rightHintRect.x, this.rightHintRect.y, this.rightHintRect.width, this.rightHintRect.height);
            g.setColor(Color.black);
            g.drawString(this.rightHintText, this.rightHintRect.x, this.rightHintRect.y + this.fm.getHeight() - 3);
        }
    }

    public long getValue(int i) {
        long d = 0L;
        d = i == 0 ? (this.c1_pos == this.margin ? this.min : (this.c1_pos == this.width - this.margin ? this.max : (long)(this.c1_pos - this.margin) * this.COEF + this.min)) : (this.c2_pos == this.margin ? this.min : (this.c2_pos == this.width - this.margin ? this.max : (long)(this.c2_pos - this.margin) * this.COEF + this.min));
        return d;
    }

    public void setValue(int i, double d) {
        int j = this.margin + (int)((d - (double)this.min) * this.tk);
        if (i == 0) {
            this.c1_pos = j;
        } else {
            this.c2_pos = j;
        }
        this.repaint();
    }

    private void createScale(Graphics g) {
        Dimension dimension = this.getSize();
        this.backgroundImage = this.createImage(dimension.width, dimension.height);
        Graphics g1 = this.backgroundImage.getGraphics();
        g1.setColor(this.getBackground());
        g1.fillRect(0, 0, dimension.width, dimension.height);
        g1.setFont(this.font);
        g1.setColor(Color.BLACK);
        g1.drawLine(this.margin, this.scaleY, this.width - this.margin, this.scaleY);
        g1.drawLine(this.margin, this.scaleY - 4, this.width - this.margin, this.scaleY - 4);
        g1.setColor(Color.WHITE);
        g1.drawLine(this.margin, this.scaleY - 3, this.width - this.margin, this.scaleY - 3);
        g1.setColor(Color.LIGHT_GRAY);
        g1.drawLine(this.margin, this.scaleY - 2, this.width - this.margin, this.scaleY - 2);
        g1.drawLine(this.margin, this.scaleY - 1, this.width - this.margin, this.scaleY - 1);
        g1.setColor(new Color(200, 200, 200));
        g1.drawLine(this.margin, this.scaleY - 3, this.margin + RangeSlider.getNbDayOfYear(this.year - 1), this.scaleY - 3);
        g1.setColor(new Color(160, 160, 160));
        g1.drawLine(this.margin, this.scaleY - 2, this.margin + RangeSlider.getNbDayOfYear(this.year - 1), this.scaleY - 2);
        g1.setColor(new Color(120, 120, 120));
        g1.drawLine(this.margin, this.scaleY - 1, this.margin + RangeSlider.getNbDayOfYear(this.year - 1), this.scaleY - 1);
        int x = this.margin;
        int i = 1;
        while (i >= 0) {
            int month = 0;
            while (month < 12) {
                if (month % 2 == 0) {
                    g1.setColor(Color.WHITE);
                } else {
                    g1.setColor(new Color(252, 252, 252));
                }
                cal.set(this.year - i, month, 1);
                int nbday = cal.getActualMaximum(5);
                g1.setColor(Color.DARK_GRAY);
                g1.drawLine(x, this.scaleY - 3, x, this.scaleY - 2);
                x += nbday;
                if (i == 1 && month == 11) {
                    g1.drawLine(x, this.scaleY - 7, x, this.scaleY - 0);
                }
                ++month;
            }
            --i;
        }
        g1.drawLine(x, this.scaleY - 7, x, this.scaleY);
        long currenttime = System.currentTimeMillis();
        long delta = currenttime - this.min;
        int nbpixel = this.margin + (int)(delta / this.COEF);
        if (nbpixel > 0) {
            g1.setColor(Color.RED);
            g1.drawLine(nbpixel, this.scaleY + 2, nbpixel, this.scaleY - 7);
        }
        g1.setColor(Color.DARK_GRAY);
        g1.drawString(String.valueOf(this.year - 1), 176, this.scaleY + 12);
        g1.setColor(Color.BLACK);
        g1.drawString(String.valueOf(this.year), 540, this.scaleY + 12);
    }

    public String getDateFromMillis(long millis) {
        cal.setTimeInMillis(millis);
        DateFormat df = DateFormat.getDateInstance(1);
        String r = df.format(cal.getTime());
        return r;
    }

    public int getPrecision() {
        return this.precision;
    }

    public static int getOrder(double d) {
        int i = 0;
        if (d == 0.0) {
            return i;
        }
        if (Math.abs(d) >= 1.0) {
            do {
                ++i;
            } while ((d /= 10.0) >= 1.0);
            return --i;
        }
        if (Math.abs(d) < 1.0) {
            while (d < 1.0) {
                d *= 10.0;
                ++i;
            }
            return -i;
        }
        return i;
    }

    @Override
    public void mouseReleased(MouseEvent mouseevent) {
        this.draggable1 = false;
        this.draggable2 = false;
    }

    private String getLeftCursorText() {
        return " Du " + this.getDateFromMillis(this.getValue(0)) + " ";
    }

    private String getRightCursorText() {
        return " au " + this.getDateFromMillis(this.getValue(1)) + " ";
    }

    @Override
    public void mousePressed(MouseEvent mouseevent) {
        int x = mouseevent.getX();
        int y = mouseevent.getY();
        boolean flag = false;
        if (this.isOnLeftCursor(x, y)) {
            this.draggable1 = true;
            this.old_pos = x;
            flag = true;
            this.leftHintText = this.getLeftCursorText();
            this.leftHintRect = new Rectangle(x, this.scaleY - this.fm.getHeight() - 6, this.fm.stringWidth(this.leftHintText), this.fm.getHeight());
        } else if (this.isOnRightCursor(x, y)) {
            this.draggable2 = true;
            this.old_pos = x;
            flag = true;
            this.rightHintText = " au " + this.getRightCursorText() + " ";
            this.rightHintRect = new Rectangle(x, this.scaleY - this.fm.getHeight() - 6, this.fm.stringWidth(this.rightHintText), this.fm.getHeight());
        } else {
            return;
        }
        if (this.c1_pos == this.c2_pos && flag) {
            if (this.last_dragged == 1) {
                this.draggable1 = true;
                this.draggable2 = false;
            }
            if (this.last_dragged == 2) {
                this.draggable1 = false;
                this.draggable2 = true;
            }
        }
        this.mouseDragged(mouseevent);
    }

    private boolean isOnRightCursor(int x, int y) {
        return x >= this.c2_pos - this.cursor_size / 2 && x <= this.c2_pos + this.cursor_size / 2 && y >= this.scaleY - this.cursor_size / 2 - 1 && y <= this.scaleY + this.cursor_size / 2 + 1;
    }

    private boolean isOnLeftCursor(int x, int y) {
        return x >= this.c1_pos - this.cursor_size / 2 && x <= this.c1_pos + this.cursor_size / 2 && y >= this.scaleY - this.cursor_size / 2 - 1 && y <= this.scaleY + this.cursor_size / 2 + 1;
    }

    @Override
    public void mouseDragged(MouseEvent mouseevent) {
        int x = mouseevent.getX();
        mouseevent.getY();
        int j = 0;
        if (this.draggable1) {
            this.c1_pos = x > this.c2_pos ? this.c2_pos : (x < this.margin ? this.margin : x);
            if (this.c1_pos > this.old_pos) {
                this.repaint(this.old_pos - this.cursor_size, this.scaleY - this.cursor_size / 2, this.c1_pos + this.cursor_size, this.scaleY + this.cursor_size / 2);
            } else {
                this.repaint(this.c1_pos - this.cursor_size, this.scaleY - this.cursor_size / 2, this.old_pos + this.cursor_size, this.scaleY + this.cursor_size / 2);
            }
            this.old_pos = x;
            this.last_dragged = 1;
            j = this.c1_pos;
        }
        if (this.draggable2) {
            this.c2_pos = x < this.c1_pos ? this.c1_pos : (x > this.getSize().width - this.margin ? this.getSize().width - this.margin : x);
            if (this.c2_pos > this.old_pos) {
                this.repaint(this.old_pos - this.cursor_size, this.scaleY - this.cursor_size / 2, this.c2_pos + this.cursor_size, this.scaleY + this.cursor_size / 2);
            } else {
                this.repaint(this.c2_pos - this.cursor_size, this.scaleY - this.cursor_size / 2, this.old_pos + this.cursor_size, this.scaleY + this.cursor_size / 2);
            }
            this.old_pos = x;
            this.last_dragged = 2;
            j = this.c2_pos;
        }
        if (this.draggable1) {
            this.computeLeftRect(j);
        }
        if (this.draggable2) {
            this.computeRightRect(j);
        }
        this.repaint();
    }

    private void computeRightRect(int j) {
        this.rightHintText = this.getRightCursorText();
        this.rightHintRect = new Rectangle(j, this.scaleY - this.fm.getHeight() - 6, this.fm.stringWidth(this.rightHintText), this.fm.getHeight());
        if (this.leftHintRect != null && this.c2_pos - this.leftHintRect.x < this.fm.stringWidth(this.leftHintText)) {
            this.rightHintRect.x = this.leftHintRect.x + this.fm.stringWidth(this.leftHintText);
        }
        if (this.rightHintRect.x + this.rightHintRect.width > this.width) {
            this.rightHintRect.x = this.width - this.rightHintRect.width - 1;
        }
    }

    private void computeLeftRect(int j) {
        this.leftHintText = this.getLeftCursorText();
        this.leftHintRect = new Rectangle(j, this.scaleY - this.fm.getHeight() - 6, this.fm.stringWidth(this.leftHintText), this.fm.getHeight());
        if (this.rightHintRect != null && this.rightHintRect.x - this.c1_pos < this.fm.stringWidth(this.leftHintText)) {
            this.leftHintRect.x = this.rightHintRect.x - this.fm.stringWidth(this.leftHintText);
        }
        if (this.leftHintRect.x + this.leftHintRect.width > this.width) {
            this.leftHintRect.x = this.width - this.leftHintRect.width - 1;
        }
    }

    @Override
    public void componentResized(ComponentEvent componentevent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentevent) {
    }

    @Override
    public void componentShown(ComponentEvent componentevent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentevent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseevent) {
        int y;
        int x = mouseevent.getX();
        if (this.isOnLeftCursor(x, y = mouseevent.getY()) || this.isOnRightCursor(x, y)) {
            if (this.getCursor() != Cursor.getPredefinedCursor(12)) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            }
        } else if (this.getCursor() != Cursor.getPredefinedCursor(0)) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseevent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseevent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseevent) {
    }

    @Override
    public boolean imageUpdate(Image image, int i, int j, int k, int l, int i1) {
        boolean flag = super.imageUpdate(image, i, j, k, l, i1);
        if (flag) {
            this.repaint();
        }
        return true;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(this.width, this.height);
    }
}

