/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXDatePickerFormatter;
import org.openconcerto.ui.Log;
import org.openconcerto.ui.TM;
import org.openconcerto.ui.component.text.TextComponent;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.FormatGroup;
import org.openconcerto.utils.TimeUtils;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.i18n.TM;

public final class JDate
extends JXDatePicker
implements TextComponent,
ValueWrapper<Date> {
    private static boolean CommitEachValidEditDefault;
    private final boolean fillWithCurrentDate;
    private final boolean commitEachValidEdit;
    private final Calendar cal;

    static {
        String formats = TM.getInstance().translate(TM.MissingMode.NULL, "jdate.formats", new Object[0]);
        if (formats != null) {
            String[] array = formats.split("\n");
            UIDefaults lafDefaults = UIManager.getLookAndFeelDefaults();
            if (array.length > 0) {
                lafDefaults.put("JXDatePicker.longFormat", array[0]);
            }
            if (array.length > 1) {
                lafDefaults.put("JXDatePicker.mediumFormat", array[1]);
            }
            if (array.length > 2) {
                lafDefaults.put("JXDatePicker.shortFormat", array[2]);
            }
            if (array.length > 3) {
                Log.get().warning("Some formats ignored " + formats);
            }
        }
        CommitEachValidEditDefault = false;
    }

    public static void setCommitEachValidEditDefault(boolean commitEachValidEditDefault) {
        CommitEachValidEditDefault = commitEachValidEditDefault;
    }

    public static boolean getCommitEachValidEditDefault() {
        return CommitEachValidEditDefault;
    }

    public JDate() {
        this(false);
    }

    public JDate(boolean fillWithCurrentDate) {
        this(fillWithCurrentDate, JDate.getCommitEachValidEditDefault());
    }

    public JDate(boolean fillWithCurrentDate, boolean commitEachValidEdit) {
        this.fillWithCurrentDate = fillWithCurrentDate;
        this.commitEachValidEdit = commitEachValidEdit;
        InputMap inputMap = this.getEditor().getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "dayToFuture");
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "dayToPast");
        inputMap.put(KeyStroke.getKeyStroke(38, 512), "monthToFuture");
        inputMap.put(KeyStroke.getKeyStroke(40, 512), "monthToPast");
        ActionMap actionMap = this.getEditor().getActionMap();
        this.cal = Calendar.getInstance(this.getMonthView().getLocale());
        actionMap.put("dayToPast", this.createChangeDateAction(6, -1));
        actionMap.put("dayToFuture", this.createChangeDateAction(6, 1));
        actionMap.put("monthToPast", this.createChangeDateAction(2, -1));
        actionMap.put("monthToFuture", this.createChangeDateAction(2, 1));
        this.resetValue();
    }

    public final boolean fillsWithCurrentDate() {
        return this.fillWithCurrentDate;
    }

    protected final Calendar getCal() {
        return this.cal;
    }

    protected AbstractAction createChangeDateAction(final int field, final int amount) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Date currentVal = JDate.this.getDate();
                if (currentVal == null && JDate.this.fillsWithCurrentDate()) {
                    currentVal = new Date();
                }
                if (currentVal != null) {
                    JDate.this.getCal().setTime(currentVal);
                    JDate.this.getCal().add(field, amount);
                    JDate.this.setValue(JDate.this.getCal().getTime());
                }
            }
        };
    }

    public void setFormats(DateFormat[] formats) {
        InternationalFormatter formatter = new InternationalFormatter(new FormatGroup(formats)){

            @Override
            public Object stringToValue(String text) throws ParseException {
                if (text == null || text.isEmpty()) {
                    return null;
                }
                return super.stringToValue(text);
            }
        };
        formatter.setCommitsOnValidEdit(this.commitEachValidEdit);
        this.getEditor().setFormatterFactory(new DefaultFormatterFactory(formatter));
    }

    public DateFormat[] getFormats() {
        JFormattedTextField.AbstractFormatterFactory factory = this.getEditor().getFormatterFactory();
        if (factory != null) {
            JFormattedTextField.AbstractFormatter formatter = factory.getFormatter(this.getEditor());
            if (formatter instanceof JXDatePickerFormatter) {
                return ((JXDatePickerFormatter)formatter).getFormats();
            }
            if (formatter instanceof InternationalFormatter) {
                Format format = ((InternationalFormatter)formatter).getFormat();
                if (format instanceof DateFormat) {
                    return new DateFormat[]{(DateFormat)format};
                }
                if (format instanceof FormatGroup) {
                    ArrayList<? extends Format> formats = new ArrayList<Format>(((FormatGroup)format).getFormats());
                    Iterator iter = formats.iterator();
                    while (iter.hasNext()) {
                        Format element = (Format)iter.next();
                        if (element instanceof DateFormat) continue;
                        iter.remove();
                    }
                    return formats.toArray(new DateFormat[formats.size()]);
                }
            }
        }
        return null;
    }

    public void updateUI() {
        super.updateUI();
        this.setFormats(this.getFormats());
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component child = componentArray[n2];
            if (child instanceof JButton) {
                ((JComponent)child).setOpaque(false);
                ((JButton)child).setContentAreaFilled(false);
            }
            ++n2;
        }
    }

    @Override
    public final void resetValue() {
        if (this.fillsWithCurrentDate()) {
            this.setValue(new Date());
        } else {
            this.setValue(null);
        }
    }

    @Override
    public final void setValue(Date date) {
        Date timeless;
        if (date == null) {
            timeless = null;
        } else {
            this.getCal().setTime(date);
            TimeUtils.clearTime(this.getCal());
            timeless = this.getCal().getTime();
        }
        this.setDate(timeless);
    }

    @Override
    public final Date getValue() {
        return this.getDate();
    }

    public final boolean isEmpty() {
        return this.getValue() == null;
    }

    @Override
    public final void addValueListener(PropertyChangeListener l) {
        this.getEditor().addPropertyChangeListener("value", l);
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.getEditor().removePropertyChangeListener("value", l);
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    @Override
    public ValidState getValidState() {
        return ValidState.getTrueInstance();
    }

    @Override
    public void addValidListener(ValidListener l) {
    }

    @Override
    public void removeValidListener(ValidListener l) {
    }

    @Override
    public JTextComponent getTextComp() {
        return this.getEditor();
    }
}

