/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.task.ui;

import java.util.List;
import javax.swing.DefaultListModel;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.users.User;
import org.openconcerto.sql.users.UserManager;

public class UserListModel
extends DefaultListModel {
    private final SQLTableModifiedListener l = new SQLTableModifiedListener(){

        @Override
        public void tableModified(SQLTableEvent evt) {
            UserListModel.this.clearAndReload();
        }
    };
    private SQLTable t = null;

    public final void start() {
        if (this.t == null) {
            this.t = UserManager.getInstance().getTable();
            this.t.addTableModifiedListener(this.l);
            this.l.tableModified(null);
        }
    }

    public final void stop() {
        if (this.t != null) {
            this.t.removeTableModifiedListener(this.l);
            this.t = null;
        }
    }

    private void reload() {
        List<User> users = UserManager.getInstance().getAllUser();
        int i = 0;
        while (i < users.size()) {
            User u = users.get(i);
            this.addElement(u);
            ++i;
        }
    }

    public final void clearAndReload() {
        this.clear();
        this.reload();
    }
}

