/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.util.Collections;
import org.openconcerto.sql.model.IFieldPath;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.request.BaseFillSQLRequest;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelLinesSourceOnline;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.sql.view.list.SQLTableModelSourceState;
import org.openconcerto.sql.view.list.SQLTableModelSourceStateOnline;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.change.ListChangeIndex;

public class SQLTableModelSourceOnline
extends SQLTableModelSource {
    private final ListSQLRequest req;

    public SQLTableModelSourceOnline(ListSQLRequest req) {
        super(req.getGraph());
        this.req = req;
    }

    public SQLTableModelSourceOnline(SQLTableModelSourceOnline src) {
        super(src);
        this.req = src.req;
    }

    public final ListSQLRequest getReq() {
        return this.req;
    }

    @Override
    protected SQLTableModelSourceState createState() {
        return new SQLTableModelSourceStateOnline(this.getAllColumns(), this.getReq());
    }

    @Override
    protected void colsChanged(final ListChangeIndex<SQLTableModelColumn> change) {
        super.colsChanged(change);
        this.getReq().changeGraphToFetch(new IClosure<SQLRowValues>(){

            @Override
            public void executeChecked(SQLRowValues g) {
                for (SQLTableModelColumn col : change.getItemsAdded()) {
                    if (col instanceof SQLTableModelSource.DebugRow) continue;
                    for (IFieldPath iFieldPath : col.getPaths()) {
                        BaseFillSQLRequest.addToFetch(g, iFieldPath.getPath(), Collections.singleton(iFieldPath.getFieldName()));
                    }
                }
            }
        });
    }

    @Override
    protected SQLTableModelLinesSourceOnline _createLinesSource(ITableModel model) {
        return new SQLTableModelLinesSourceOnline(this, model);
    }

    @Override
    public SQLRowValues getMaxGraph() {
        return this.getReq().getGraphToFetch();
    }
}

