/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLFieldsSet;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelColumnPath;
import org.openconcerto.sql.view.list.SQLTableModelColumns;
import org.openconcerto.sql.view.list.SQLTableModelLinesSource;
import org.openconcerto.sql.view.list.SQLTableModelSourceState;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.change.ListChangeIndex;
import org.openconcerto.utils.change.ListChangeRecorder;

public abstract class SQLTableModelSource {
    private final SQLTable table;
    private SQLRowValues inited;
    private SQLTableModelColumns allCols;
    private final ListChangeRecorder<SQLTableModelColumn> cols;
    private final List<SQLTableModelColumn> debugCols;
    private final List<WeakReference<SQLTableModelLinesSource>> lines;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);

    public SQLTableModelSource(SQLRowValues graph) {
        this.lines = new ArrayList<WeakReference<SQLTableModelLinesSource>>();
        this.table = graph.getTable();
        this.setAllCols(SQLTableModelColumns.empty());
        this.cols = new ListChangeRecorder(new ArrayList());
        this.debugCols = new ArrayList<SQLTableModelColumn>();
        this.inited = graph;
    }

    public void init() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.inited == null) {
            return;
        }
        SQLRowValues graph = this.inited;
        graph.walkFields(new IClosure<FieldPath>(){

            @Override
            public void executeChecked(FieldPath input) {
                SQLField f = input.getField();
                if (f.getTable().getLocalContentFields().contains(f)) {
                    SQLTableModelColumnPath col = new SQLTableModelColumnPath(input);
                    SQLTableModelSource.this.cols.add(col);
                } else {
                    SQLTableModelSource.this.debugCols.add(new SQLTableModelColumnPath(input.getPath(), f.getName(), f.toString()){

                        @Override
                        protected Object show_(SQLRowAccessor r) {
                            Object res = super.show_(r);
                            return res instanceof SQLRowValues ? Integer.valueOf(((SQLRowValues)res).getID()) : res;
                        }
                    });
                }
            }
        }, true);
        this.debugCols.add(new DebugRow(this.getPrimaryTable()));
        SQLField orderField = this.getPrimaryTable().getOrderField();
        if (orderField != null) {
            this.debugCols.add(new SQLTableModelColumnPath(Path.get(this.getPrimaryTable()), orderField.getName(), "Order"));
        }
        this.debugCols.add(new SQLTableModelColumnPath(Path.get(this.getPrimaryTable()), this.getPrimaryTable().getKey().getName(), "PrimaryKey"));
        this.inited = null;
        this.listenToCols();
        this.updateCols(null);
    }

    public SQLTableModelSource(SQLTableModelSource src) {
        this.lines = new ArrayList<WeakReference<SQLTableModelLinesSource>>();
        this.table = src.table;
        this.setAllCols(src.getAllColumns());
        this.cols = new ListChangeRecorder<SQLTableModelColumn>(new ArrayList<SQLTableModelColumn>(src.cols));
        this.debugCols = new ArrayList<SQLTableModelColumn>(src.debugCols);
        this.inited = null;
        this.listenToCols();
    }

    private void listenToCols() {
        assert (SwingUtilities.isEventDispatchThread());
        this.cols.getRecipe().addListener(new IClosure<ListChangeIndex<SQLTableModelColumn>>(){

            @Override
            public void executeChecked(ListChangeIndex<SQLTableModelColumn> change) {
                SQLTableModelSource.this.updateCols(change);
            }
        });
    }

    protected final void updateCols(ListChangeIndex<SQLTableModelColumn> change) {
        assert (SwingUtilities.isEventDispatchThread());
        assert (this.inited == null);
        if (change != null && ((ListChangeIndex)change).getItemsAdded().isEmpty() && ((ListChangeIndex)change).getItemsRemoved().isEmpty()) {
            return;
        }
        SQLTableModelSourceState beforeState = this.createState();
        this.setAllCols(new SQLTableModelColumns(this.cols, this.debugCols));
        this.colsChanged((ListChangeIndex<SQLTableModelColumn>)(change == null ? new ListChangeIndex.Add<SQLTableModelColumn>(0, this.getAllColumns().getAllColumns()) : change));
        SQLTableModelSourceState afterState = this.createState();
        this.fireColsChanged(beforeState, afterState);
    }

    protected abstract SQLTableModelSourceState createState();

    protected void colsChanged(ListChangeIndex<SQLTableModelColumn> change) {
    }

    private void fireColsChanged(SQLTableModelSourceState beforeState, SQLTableModelSourceState afterState) {
        int i = 0;
        while (i < this.lines.size()) {
            WeakReference<SQLTableModelLinesSource> l = this.lines.get(i);
            SQLTableModelLinesSource line = (SQLTableModelLinesSource)l.get();
            if (line == null) {
                this.lines.remove(i);
                continue;
            }
            line.colsChanged(beforeState, afterState);
            ++i;
        }
        this.supp.firePropertyChange("cols", null, this.cols);
    }

    public final SQLTableModelLinesSource createLinesSource(ITableModel model) {
        this.init();
        SQLTableModelLinesSource res = this._createLinesSource(model);
        this.lines.add(new WeakReference<SQLTableModelLinesSource>(res));
        return res;
    }

    protected abstract SQLTableModelLinesSource _createLinesSource(ITableModel var1);

    public abstract SQLRowValues getMaxGraph();

    public final List<SQLTableModelColumn> getColumns() {
        this.init();
        return this.cols;
    }

    private synchronized void setAllCols(SQLTableModelColumns allCols) {
        this.allCols = allCols;
    }

    public final synchronized SQLTableModelColumns getAllColumns() {
        return this.allCols;
    }

    public final void addDebugColumn(SQLTableModelColumn col) {
        this.init();
        this.debugCols.add(col);
        this.updateCols(new ListChangeIndex.Add<SQLTableModelColumn>(this.getAllColumns().size(), Collections.singleton(col)));
    }

    public final SQLTableModelColumn getColumn(int index) {
        return this.getAllColumns().getAllColumns().get(index);
    }

    public final List<SQLTableModelColumn> getColumns(SQLField f) {
        return this.getAllColumns().getColumns(f);
    }

    public final SQLTableModelColumn getColumn(SQLField f) {
        return this.getAllColumns().getColumn(f);
    }

    public final SQLTableModelColumn getColumn(FieldPath fp) {
        return this.getAllColumns().getColumn(fp);
    }

    public final void addColumnListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener("cols", l);
    }

    public final void rmColumnListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener("cols", l);
    }

    public final SQLTable getPrimaryTable() {
        return this.table;
    }

    public final Set<SQLTable> getTables() {
        return new SQLFieldsSet(this.getLineFields()).getTables();
    }

    public final Set<SQLField> getLineFields() {
        HashSet<SQLField> res = new HashSet<SQLField>();
        for (SQLRowValues v : this.getMaxGraph().getGraph().getItems()) {
            for (String f : v.getFields()) {
                res.add(v.getTable().getField(f));
            }
            if (!v.getTable().isArchivable()) continue;
            res.add(v.getTable().getArchiveField());
        }
        return res;
    }

    protected static final class DebugRow
    extends BaseSQLTableModelColumn {
        private final SQLTable t;

        protected DebugRow(SQLTable t) {
            super("Fields", Object.class);
            this.t = t;
        }

        @Override
        protected Object show_(SQLRowAccessor r) {
            if (r instanceof SQLRow) {
                return r;
            }
            return new SQLRowValues((SQLRowValues)r, SQLRowValues.ForeignCopyMode.COPY_ID_OR_RM);
        }

        @Override
        public Set<SQLField> getFields() {
            return this.t.getFields();
        }

        @Override
        public Set<FieldPath> getPaths() {
            return FieldPath.create(Path.get(this.t), this.t.getFieldsName());
        }
    }
}

