/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.swing.SwingUtilities;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.utils.ReOrder;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.SleepingQueue;

public final class MoveQueue
extends SleepingQueue {
    private final ITableModel tableModel;

    MoveQueue(ITableModel model) {
        super(String.valueOf(MoveQueue.class.getSimpleName()) + " on " + model);
        this.tableModel = model;
    }

    public Future<?> move(final List<? extends SQLRowAccessor> rows, final int inc) {
        if (inc == 0 || rows.size() == 0) {
            return null;
        }
        final boolean after = inc > 0;
        SQLRowAccessor outerR = null;
        for (SQLRowAccessor sQLRowAccessor : rows) {
            if (outerR == null) {
                outerR = sQLRowAccessor;
                continue;
            }
            int compare = sQLRowAccessor.getOrder().compareTo(outerR.getOrder());
            if ((!after || compare <= 0) && (after || compare >= 0)) continue;
            outerR = sQLRowAccessor;
        }
        final int n = outerR.getID();
        return this.put(new Runnable(){

            @Override
            public void run() {
                final FutureTask<ListSQLLine> destID = new FutureTask<ListSQLLine>(new Callable<ListSQLLine>(){

                    @Override
                    public ListSQLLine call() {
                        return MoveQueue.this.tableModel.getDestLine(n, inc);
                    }
                });
                MoveQueue.this.tableModel.invokeLater(destID);
                try {
                    if (destID.get() != null) {
                        SQLUtils.executeAtomic(MoveQueue.this.getTable().getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, Exception>(){

                            @Override
                            public Object handle(SQLDataSource ds) throws Exception {
                                MoveQueue.this.moveQuick(rows, after, ((ListSQLLine)destID.get()).getRow().asRow());
                                return null;
                            }
                        });
                    }
                }
                catch (Exception e) {
                    throw ExceptionUtils.createExn(IllegalStateException.class, "move failed", e);
                }
            }
        });
    }

    public Future<?> moveTo(final List<? extends Number> rows, int rowIndex) {
        if (rows.size() == 0) {
            return null;
        }
        assert (rowIndex >= 0);
        assert (SwingUtilities.isEventDispatchThread());
        int rowCount = this.tableModel.getRowCount();
        final boolean after = rowIndex >= rowCount;
        int index = after ? rowCount - 1 : rowIndex;
        final SQLRowValues line = this.tableModel.getRow(index).getRow();
        assert (line.isFrozen()) : "row could change by the time move() is called";
        return this.put(new Runnable(){

            @Override
            public void run() {
                try {
                    SQLUtils.executeAtomic(MoveQueue.this.getTable().getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, Exception>(){

                        @Override
                        public Object handle(SQLDataSource ds) throws Exception {
                            MoveQueue.this.moveQuick(rows, after, line.asRow());
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    throw ExceptionUtils.createExn(IllegalStateException.class, "move failed", e);
                }
            }
        });
    }

    final void moveQuick(List<?> srcRows, boolean after, SQLRow destRow) throws SQLException {
        int rowCount = srcRows.size();
        if (rowCount < 5 && rowCount < this.tableModel.getTotalRowCount() / 3) {
            List<?> l;
            if (after) {
                l = new ArrayList(srcRows);
                Collections.reverse(l);
            } else {
                l = srcRows;
            }
            SQLTable t = this.getTable();
            SQLRowValues vals = new SQLRowValues(t);
            for (Object src : l) {
                vals.setOrder(destRow, after).update(MoveQueue.getID(src, t).intValue());
            }
        } else {
            MoveQueue.moveAtOnce(srcRows, rowCount, after, destRow);
        }
    }

    private static Number getID(Object o, SQLTable t) {
        Number res;
        if (o instanceof SQLRowAccessor) {
            SQLRowAccessor row = (SQLRowAccessor)o;
            if (row.getTable() != t) {
                throw new IllegalArgumentException("Not from the same table : " + row + " != " + t);
            }
            res = row.getIDNumber();
        } else {
            res = (Number)o;
        }
        return res;
    }

    private SQLTable getTable() {
        return this.tableModel.getTable();
    }

    public static void moveAtOnce(List<? extends SQLRowAccessor> srcRows, boolean after, SQLRow destRow) throws SQLException {
        MoveQueue.moveAtOnce(srcRows, srcRows.size(), after, destRow);
    }

    private static void moveAtOnce(List<?> srcRows, int rowCount, boolean after, SQLRow destRow) throws SQLException {
        boolean destRowReordered;
        BigDecimal inc;
        if (rowCount == 0) {
            return;
        }
        SQLTable t = destRow.getTable();
        BigDecimal minDistance = t.getOrderULP().scaleByPowerOfTen(1);
        assert (minDistance.signum() > 0);
        BigDecimal places = BigDecimal.valueOf(rowCount + 1);
        BigDecimal room = minDistance.multiply(places);
        BigDecimal destOrder = destRow.getOrder();
        SQLRow nextRow = destRow.getRow(true);
        if (nextRow == null) {
            inc = ReOrder.DISTANCE;
            destRowReordered = false;
        } else {
            BigDecimal nextOrder = nextRow.getOrder();
            assert (nextOrder.compareTo(destOrder) > 0);
            BigDecimal diff = nextOrder.subtract(destOrder);
            assert (diff.signum() > 0);
            if (diff.compareTo(room) < 0) {
                int count = 100;
                int tableRowCount = t.getRowCount();
                boolean reordered = false;
                while (!reordered) {
                    reordered = ReOrder.create(t, destOrder, !after, count, destOrder.add(room)).exec();
                    if (!reordered && count > tableRowCount) {
                        throw new IllegalStateException("Unable to reorder " + count + " rows in " + t);
                    }
                    count *= 10;
                }
                inc = minDistance;
                destRowReordered = true;
            } else {
                inc = DecimalUtils.round(diff.divide(places, DecimalUtils.HIGH_PRECISION), t.getOrderDecimalDigits(), RoundingMode.DOWN);
                destRowReordered = false;
            }
        }
        assert (inc.compareTo(minDistance) >= 0);
        BigDecimal newOrder = destOrder;
        if (after) {
            newOrder = newOrder.add(inc);
        }
        ArrayList<List<String>> newOrdersAndIDs = new ArrayList<List<String>>(rowCount);
        for (Object src : srcRows) {
            Number srcID = MoveQueue.getID(src, t);
            newOrdersAndIDs.add(Arrays.asList(srcID.toString(), newOrder.toPlainString()));
            newOrder = newOrder.add(inc);
        }
        if (!after && !destRowReordered) {
            UpdateBuilder updateDestRow = new UpdateBuilder(t);
            updateDestRow.setObject(t.getOrderField(), (Object)newOrder);
            updateDestRow.setWhere(destRow.getWhere());
            t.getDBSystemRoot().getDataSource().execute(updateDestRow.asString());
        }
        SQLSyntax syntax = SQLSyntax.get(t);
        UpdateBuilder update = new UpdateBuilder(t);
        String constantTableAlias = "newOrdersAndIDs";
        update.addVirtualJoin(syntax.getConstantTable(newOrdersAndIDs, "newOrdersAndIDs", Arrays.asList("ID", "newOrder")), "newOrdersAndIDs", true, "ID", t.getKey().getName());
        update.setFromVirtualJoinField(t.getOrderField().getName(), "newOrdersAndIDs", "newOrder");
        t.getDBSystemRoot().getDataSource().execute(update.asString());
        t.fireTableModified(-1, Collections.singletonList(t.getOrderField().getName()));
    }
}

