/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.util.ArrayList;
import java.util.List;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.utils.ChangePrivileges;

public class CreateUser {
    private final String name;
    private final String password;
    private final ChangePrivileges grant;

    public CreateUser(String name, String pass) {
        this.name = name;
        this.password = pass;
        this.grant = new ChangePrivileges(name);
    }

    public final ChangePrivileges getGrant() {
        return this.grant;
    }

    public final List<String> getStatements(DBSystemRoot sysRoot) {
        ArrayList<String> res = new ArrayList<String>();
        String qName = SQLBase.quoteIdentifier(this.name);
        String passKeyWord = sysRoot.getServer().getSQLSystem() == SQLSystem.MYSQL ? " IDENTIFIED BY " : " PASSWORD ";
        res.add("CREATE USER " + qName + passKeyWord + SQLBase.quoteStringStd(this.password));
        res.addAll(this.grant.getStatements(sysRoot));
        return res;
    }

    public final void execute(DBSystemRoot sysRoot) {
        SQLDataSource ds = sysRoot.getDataSource();
        for (String s : this.getStatements(sysRoot)) {
            ds.execute(s);
        }
    }
}

