/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui.light;

import java.awt.Color;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.model.FieldMapper;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.Item;
import org.openconcerto.ui.group.LayoutHints;
import org.openconcerto.ui.light.CustomEditorProvider;
import org.openconcerto.ui.light.LightUIDescriptor;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUILine;
import org.openconcerto.utils.i18n.TranslationManager;

public class GroupToLightUIConvertor {
    private final int maxColumnCount;
    private PropsConfiguration configuration;
    private Map<String, CustomEditorProvider> customEditorProviders = new HashMap<String, CustomEditorProvider>();

    public GroupToLightUIConvertor(PropsConfiguration conf) {
        this(conf, 4);
    }

    public GroupToLightUIConvertor(PropsConfiguration conf, int columns) {
        this.maxColumnCount = columns;
        this.configuration = conf;
    }

    public LightUIDescriptor convert(Group group) {
        LightUIDescriptor desc = new LightUIDescriptor(group.getId());
        this.append(desc, group);
        return desc;
    }

    private void append(LightUIDescriptor desc, Item item) {
        if (item instanceof Group) {
            Group gr = (Group)item;
            int size = gr.getSize();
            int i = 0;
            while (i < size) {
                Item it = gr.getItem(i);
                this.append(desc, it);
                ++i;
            }
        } else {
            LightUIElement elementEditor;
            LayoutHints localHint = item.getLocalHint();
            LightUILine currentLine = desc.getLastLine();
            if (localHint.isSeparated() && currentLine.getWidth() > 0) {
                currentLine = new LightUILine();
                desc.addLine(currentLine);
            }
            if (localHint.fillHeight()) {
                currentLine.setFillHeight(true);
            }
            if (localHint.largeHeight()) {
                currentLine.setWeightY(1);
            }
            if (currentLine.getWidth() >= this.maxColumnCount) {
                currentLine = new LightUILine();
                desc.addLine(currentLine);
            }
            LightUIElement elementLabel = null;
            if (localHint.showLabel()) {
                elementLabel = new LightUIElement();
                elementLabel.setId(item.getId());
                elementLabel.setType(0);
                String label = TranslationManager.getInstance().getTranslationForItem(item.getId());
                if (label == null) {
                    label = item.getId();
                    elementLabel.setColor(Color.ORANGE);
                    elementLabel.setToolTip("No translation for " + item.getId());
                    Log.get().warning("No translation for " + item.getId());
                }
                elementLabel.setLabel(label);
                if (localHint.isSplit()) {
                    elementLabel.setGridWidth(4);
                } else {
                    elementLabel.setGridWidth(1);
                }
                currentLine.add(elementLabel);
            }
            if ((elementEditor = this.getCustomEditor(item.getId())) == null) {
                elementEditor = new LightUIElement();
                elementEditor.setId(item.getId());
                FieldMapper fieldMapper = this.configuration.getFieldMapper();
                if (fieldMapper == null) {
                    throw new IllegalStateException("null field mapper");
                }
                SQLField field = fieldMapper.getSQLFieldForItem(item.getId());
                if (field != null) {
                    Class<?> javaType = field.getType().getJavaType();
                    if (field.isKey()) {
                        elementEditor.setType(7);
                        elementEditor.setMinInputSize(20);
                    } else if (javaType.equals(String.class)) {
                        elementEditor.setType(1);
                        elementEditor.setValue("");
                        elementEditor.setMinInputSize(10);
                    } else if (javaType.equals(Date.class)) {
                        elementEditor.setType(2);
                    } else {
                        elementEditor.setType(1);
                        Log.get().warning("unsupported type " + javaType.getName());
                        elementEditor.setValue("unsupported type " + javaType.getName());
                    }
                } else {
                    elementEditor.setType(1);
                    elementEditor.setMinInputSize(10);
                    elementEditor.setToolTip("No field attached to " + item.getId());
                    Log.get().warning("No field attached to " + item.getId());
                    if (elementLabel != null) {
                        elementLabel.setColor(Color.ORANGE);
                        elementLabel.setToolTip("No field attached to " + item.getId());
                    }
                }
            }
            if (localHint.isSplit() && currentLine.getWidth() > 0) {
                currentLine = new LightUILine();
                desc.addLine(currentLine);
            }
            if (localHint.isSplit()) {
                elementEditor.setGridWidth(4);
            } else if (localHint.largeWidth()) {
                if (localHint.showLabel()) {
                    elementEditor.setGridWidth(3);
                } else {
                    elementEditor.setGridWidth(4);
                }
            } else {
                elementEditor.setGridWidth(1);
            }
            elementEditor.setFillWidth(localHint.fillWidth());
            currentLine.add(elementEditor);
        }
    }

    private LightUIElement getCustomEditor(String id) {
        CustomEditorProvider customEditorProvider = this.customEditorProviders.get(id);
        if (customEditorProvider != null) {
            LightUIElement element = customEditorProvider.createUIElement(id);
            if (element.getId() == null) {
                throw new IllegalStateException("Null id for custom editor for id: " + id);
            }
            return element;
        }
        return null;
    }

    public void setCustomEditorProvider(String id, CustomEditorProvider provider) {
        this.customEditorProviders.put(id, provider);
    }
}

