/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.users.User;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.users.rights.UserRights;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.component.HTMLTextField;
import org.openconcerto.utils.ProductInfo;
import org.openconcerto.utils.SystemInfo;
import org.openconcerto.utils.cc.IFactory;
import org.openconcerto.utils.i18n.I18nUtils;

public class SoftwareInfoPanel
extends JPanel {
    public static final IFactory<String> FACTORY = new IFactory<String>(){

        @Override
        public String createChecked() {
            return SoftwareInfoPanel.get(false).toString();
        }
    };

    public static Map<Info, String> get(boolean html) {
        String version;
        String name;
        ProductInfo productInfo;
        PropsConfiguration propsConf;
        Configuration conf;
        HashMap<Info, String> res = new HashMap<Info, String>();
        UserRightsManager userRightsManager = UserRightsManager.getInstance();
        res.put(Info.RIGHTS, org.openconcerto.utils.i18n.TM.tr(I18nUtils.getYesNoKey(userRightsManager != null), new Object[0]));
        User user = UserManager.getUser();
        if (user != null) {
            UserRights userRights = UserRightsManager.getCurrentUserRights();
            res.put(Info.USER, String.valueOf(user.toString()) + (userRights.isSuperUser() ? " (superuser)" : ""));
        }
        if ((conf = Configuration.getInstance()) instanceof PropsConfiguration) {
            propsConf = (PropsConfiguration)conf;
            productInfo = propsConf.getProductInfo();
        } else {
            propsConf = null;
            productInfo = ProductInfo.getInstance();
        }
        if (productInfo == null) {
            name = TM.tr("infoPanel.noAppName", new Object[0]);
            version = TM.tr("infoPanel.noVersion", new Object[0]);
        } else {
            name = productInfo.getName();
            version = productInfo.getProperty("VERSION", TM.tr("infoPanel.noVersion", new Object[0]));
        }
        res.put(Info.APP_NAME, name);
        res.put(Info.APP_VERSION, version);
        if (propsConf != null && propsConf.isUsingSSH()) {
            res.put(Info.SECURE_LINK, propsConf.getWanHostAndPort());
        }
        res.put(Info.DB_URL, conf.getSystemRoot().getDataSource().getUrl());
        String logs = propsConf == null ? "" : " ; " + SystemInfo.getLink(TM.tr("infoPanel.logs", new Object[0]), propsConf.getLogDir().toURI(), html);
        res.put(Info.DIRS, String.valueOf(SystemInfo.getLink(TM.tr("infoPanel.docs", new Object[0]), conf.getWD().toURI(), html)) + logs);
        return res;
    }

    public SoftwareInfoPanel() {
        Map<Info, String> infos = SoftwareInfoPanel.get(true);
        FormLayouter l = new FormLayouter(this, 1);
        l.add(TM.tr("infoPanel.rights", new Object[0]), new JLabel(infos.get((Object)Info.RIGHTS)));
        String user = infos.get((Object)Info.USER);
        if (user != null) {
            l.add(org.openconcerto.utils.i18n.TM.tr("user", new Object[0]), new JLabel(user));
        }
        l.add(TM.tr("infoPanel.appName", new Object[0]), new JLabel(infos.get((Object)Info.APP_NAME)));
        l.add(TM.tr("infoPanel.version", new Object[0]), new JLabel(infos.get((Object)Info.APP_VERSION)));
        String secureLink = infos.get((Object)Info.SECURE_LINK);
        if (secureLink != null) {
            l.add(TM.tr("infoPanel.secureLink", new Object[0]), new JLabel(secureLink));
        }
        l.add(TM.tr("infoPanel.dbURL", new Object[0]), new JLabel(infos.get((Object)Info.DB_URL)));
        l.add(TM.tr("infoPanel.dirs", new Object[0]), new HTMLTextField(infos.get((Object)Info.DIRS)));
    }

    public static enum Info {
        RIGHTS,
        USER,
        APP_NAME,
        APP_VERSION,
        SECURE_LINK,
        DB_URL,
        DIRS;

    }
}

