/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.utils.Base64;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.Tuple2;

public class Login {
    public static final String UNKNOWN_USER = "unknownUser";
    public static final String MORE_THAN_ONE_USER = "multipleUser";
    public static final String WRONG_PASSWORD = "wrongPass";
    private final DBRoot root;
    private final SQLTable userT;
    private static MessageDigest md;

    public Login(DBRoot root) {
        this.root = root;
        this.userT = root.findTable("USER_COMMON");
        if (this.userT == null) {
            SQLCreateTable ct = new SQLCreateTable(root, "USER_COMMON");
            ((SQLCreateTable)ct.addVarCharColumn("LOGIN", 45)).addVarCharColumn("PASSWORD", 45);
            ((SQLCreateTable)ct.addVarCharColumn("NOM", 45)).addVarCharColumn("PRENOM", 45);
            ct.addVarCharColumn("SURNOM", 45);
            throw new IllegalStateException("Table " + ct.getName() + " missing :\n" + ct.asString());
        }
    }

    public final SQLTable getUserTable() {
        return this.userT;
    }

    public final Tuple2<String, String> connectEnc(String login, String pass) {
        return this.connect(login, Collections.singletonList(pass), true);
    }

    public final Tuple2<String, String> connectClear(String login, String pass) {
        return this.connectClear(login, Arrays.asList(pass));
    }

    final Tuple2<String, String> connectClear(String login, String pass, String pass2) {
        return this.connectClear(login, Arrays.asList(pass, pass2));
    }

    private final Tuple2<String, String> connectClear(String login, List<String> pass) {
        return this.connect(login, pass, false);
    }

    private final Tuple2<String, String> connect(String login, List<String> passwords, boolean encoded) {
        Tuple2<String, Object> res;
        List<SQLRow> users = this.findUser(login);
        if (users.size() == 1) {
            SQLRow userRow = users.get(0);
            int size = passwords.size();
            if (size == 0) {
                throw new IllegalArgumentException("No passwords");
            }
            String encPass = null;
            int i = 0;
            while (i < size && encPass == null) {
                String pass = passwords.get(i);
                encPass = this.connect(userRow, pass, encoded);
                ++i;
            }
            res = Tuple2.create(encPass == null ? WRONG_PASSWORD : null, encPass);
        } else if (users.size() > 1) {
            res = Tuple2.create(MORE_THAN_ONE_USER, null);
        } else {
            assert (users.size() == 0);
            res = Tuple2.create(UNKNOWN_USER, null);
        }
        try {
            this.logConnection(login, res.get0() == null, passwords);
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        return res;
    }

    private final List<SQLRow> findUser(String login) {
        SQLSelect selUser = new SQLSelect();
        selUser.addSelect(this.userT.getField("ID"));
        selUser.addSelect(this.userT.getField("PASSWORD"));
        SQLName name = this.userT.getField("LOGIN").getSQLName(this.userT);
        String req = String.valueOf(selUser.toString()) + " AND LOWER(" + name.quote() + ")=LOWER('" + login + "')";
        List users = (List)this.root.getDBSystemRoot().getDataSource().execute(req, SQLRowListRSH.createFromSelect(selUser));
        return users;
    }

    private final String connect(SQLRow userRow, String pass, boolean encoded) {
        String res;
        if (pass == null) {
            throw new NullPointerException("No password");
        }
        String encPass = encoded ? pass : Login.encodePassword(pass);
        String dbPass = userRow.getString("PASSWORD");
        if (dbPass == null || dbPass.equals(encPass) || dbPass.equals(Login.encodePassword(""))) {
            UserManager.getInstance().setCurrentUser(userRow.getID());
            res = encPass;
            assert (res != null);
        } else {
            res = null;
        }
        return res;
    }

    private final void logConnection(String login, boolean succeeded, List<String> passwords) throws SQLException {
        if (!this.root.contains("CONNEXION")) {
            return;
        }
        SQLRowValues rowValsConnect = new SQLRowValues(this.root.getTable("CONNEXION"));
        rowValsConnect.put("LOGIN", login);
        rowValsConnect.put("DATE", new Date());
        try {
            InetAddress Ip = InetAddress.getLocalHost();
            rowValsConnect.put("IP", String.valueOf(Ip.getHostName()) + " On " + Ip.getHostAddress());
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
        rowValsConnect.put("FAILED", !succeeded);
        if (!succeeded) {
            rowValsConnect.put("MDP", CollectionUtils.join(passwords, " || "));
        }
        rowValsConnect.commit();
    }

    private static synchronized MessageDigest getMessageDigest() {
        if (md == null) {
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("no SHA1", e);
            }
        }
        return md;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encodePassword(String clearPassword) {
        byte[] s;
        MessageDigest messageDigest = Login.getMessageDigest();
        synchronized (messageDigest) {
            Login.getMessageDigest().reset();
            Login.getMessageDigest().update(clearPassword.getBytes());
            s = Login.getMessageDigest().digest();
        }
        return Base64.encodeBytes(s);
    }
}

