/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.sqlobject;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.IComboSelectionItem;
import org.openconcerto.sql.sqlobject.IComboSelectionItemCache;
import org.openconcerto.sql.sqlobject.IComboSelectionItemListener;
import org.openconcerto.sql.sqlobject.ITextWithCompletionPopUp;
import org.openconcerto.sql.sqlobject.SelectionListener;
import org.openconcerto.ui.component.text.TextComponent;
import org.openconcerto.utils.OrderedSet;
import org.openconcerto.utils.SwingWorker2;
import org.openconcerto.utils.checks.MutableValueObject;
import org.openconcerto.utils.model.DefaultIMutableListModel;
import org.openconcerto.utils.text.DocumentFilterList;
import org.openconcerto.utils.text.LimitedSizeDocumentFilter;

public class ITextWithCompletion
extends JPanel
implements DocumentListener,
IComboSelectionItemListener,
TextComponent,
MutableValueObject<String> {
    public static final int MODE_STARTWITH = 1;
    public static final int MODE_CONTAINS = 2;
    private int modeCompletion = 2;
    private static final long serialVersionUID = -6916931802603023440L;
    private JTextComponent text;
    private DefaultIMutableListModel<IComboSelectionItem> model = new DefaultIMutableListModel();
    private IComboSelectionItemCache mainCache = new IComboSelectionItemCache();
    private boolean completionEnabled = true;
    private int selectedId = -1;
    private boolean selectAuto = true;
    ComboSQLRequest comboRequest;
    protected ITextWithCompletionPopUp popup;
    OrderedSet<SelectionListener> listeners = new OrderedSet();
    Component popupInvoker;
    private boolean isLoading = false;
    private int idToSelect = -1;
    private String fillWith = null;
    private final PropertyChangeSupport supp;
    private boolean isDispatching = false;

    public ITextWithCompletion(ComboSQLRequest r, boolean multiline) {
        this.comboRequest = r;
        this.supp = new PropertyChangeSupport(this);
        this.popup = new ITextWithCompletionPopUp(this.model, this);
        JTextField textField = new JTextField();
        if (!multiline) {
            this.text = textField;
            this.setLayout(new GridLayout(1, 1));
            this.add(this.text);
            this.setTextEditor(this.text);
            this.setPopupInvoker(this);
        } else {
            this.text = new JTextArea();
            this.text.setBorder(textField.getBorder());
            this.text.setFont(textField.getFont());
            this.setLayout(new GridLayout(1, 1));
            this.add(this.text);
            this.setTextEditor(this.text);
            this.setPopupInvoker(this);
        }
        this.isLoading = true;
        this.loadCacheAsynchronous();
        this.comboRequest.addTableListener(new SQLTableModifiedListener(){

            @Override
            public void tableModified(SQLTableEvent evt) {
                ITextWithCompletion.this.loadCacheAsynchronous();
            }
        });
    }

    public void setPopupListEnabled(boolean b) {
        this.popup.setListEnabled(b);
    }

    public void setTextEditor(final JTextComponent atext) {
        if (atext == null) {
            throw new IllegalArgumentException("null textEditor");
        }
        this.text = atext;
        atext.getDocument().addDocumentListener(this);
        atext.addKeyListener(new KeyListener(){
            private boolean consume;

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    ITextWithCompletion.this.updateAutoCompletion(true);
                    e.consume();
                } else if (e.getKeyCode() == 40) {
                    if (ITextWithCompletion.this.popup.isShowing()) {
                        ITextWithCompletion.this.popup.selectNext();
                        e.consume();
                    } else if (ITextWithCompletion.this.getSelectedId() <= 1) {
                        ITextWithCompletion.this.showPopup();
                    }
                } else if (e.getKeyCode() == 38) {
                    if (ITextWithCompletion.this.popup.isShowing()) {
                        ITextWithCompletion.this.popup.selectPrevious();
                        e.consume();
                    }
                } else if (e.getKeyCode() == 10 || e.getKeyCode() == 9) {
                    if (ITextWithCompletion.this.popup.isShowing()) {
                        ITextWithCompletion.this.popup.validateSelection();
                        e.consume();
                    }
                } else if (e.getKeyCode() == 34) {
                    if (ITextWithCompletion.this.popup.isShowing()) {
                        ITextWithCompletion.this.popup.selectNextPage();
                        e.consume();
                    }
                } else if (e.getKeyCode() == 33) {
                    if (ITextWithCompletion.this.popup.isShowing()) {
                        ITextWithCompletion.this.popup.selectPreviousPage();
                        e.consume();
                    }
                } else if (e.getKeyCode() == 27 && ITextWithCompletion.this.popup.isShowing()) {
                    ITextWithCompletion.this.hidePopup();
                }
                if (ITextWithCompletion.this.text.getDocument().getLength() == 0 && (e.getKeyCode() == 127 || e.getKeyCode() == 8)) {
                    System.err.println("consume");
                    this.consume = true;
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (this.consume) {
                    e.consume();
                    this.consume = false;
                }
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                ITextWithCompletion.this.popup.setMinWith(atext.getBounds().width);
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        atext.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                ITextWithCompletion.this.hidePopup();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCache() {
        ITextWithCompletion iTextWithCompletion = this;
        synchronized (iTextWithCompletion) {
            this.isLoading = true;
        }
        List<IComboSelectionItem> comboItems = this.comboRequest.getComboItems();
        ITextWithCompletion iTextWithCompletion2 = this;
        synchronized (iTextWithCompletion2) {
            this.mainCache.clear();
            this.mainCache.addAll(comboItems);
            this.isLoading = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadCacheAsynchronous() {
        ITextWithCompletion iTextWithCompletion = this;
        synchronized (iTextWithCompletion) {
            this.isLoading = true;
        }
        SwingWorker2<Object, Object> worker = new SwingWorker2<Object, Object>(){

            @Override
            public void done() {
                ITextWithCompletion.this.popup.getAccessibleContext().setAccessibleParent(ITextWithCompletion.this.text);
                if (ITextWithCompletion.this.idToSelect != -1) {
                    ITextWithCompletion.this.selectId(ITextWithCompletion.this.idToSelect);
                    ITextWithCompletion.this.idToSelect = -1;
                }
            }

            @Override
            protected Object doInBackground() throws Exception {
                ITextWithCompletion.this.loadCache();
                return null;
            }
        };
        worker.execute();
    }

    /*
     * Enabled aggressive block sorting
     */
    List<IComboSelectionItem> getPossibleValues(String aText) {
        Vector<IComboSelectionItem> result = new Vector<IComboSelectionItem>();
        if (aText.isEmpty()) {
            return result;
        }
        HashMap<String, IComboSelectionItem> map = new HashMap<String, IComboSelectionItem>();
        aText = aText.trim().toLowerCase();
        List<String> values = this.cut(aText);
        int stop = values.size();
        if (aText.length() > 0) {
            Collection col = this.mainCache.getItems();
            for (IComboSelectionItem item : col) {
                boolean ok = false;
                String lowerCase = item.getLabel().toLowerCase();
                int j = 0;
                while (j < stop) {
                    block10: {
                        if (this.modeCompletion == 2) {
                            if (lowerCase.indexOf(values.get(j)) >= 0) {
                                ok = true;
                                break block10;
                            } else {
                                ok = false;
                                break;
                            }
                        }
                        if (lowerCase.startsWith(values.get(j))) {
                            ok = true;
                        } else {
                            ok = false;
                            break;
                        }
                    }
                    ++j;
                }
                boolean removeDuplicate = true;
                if (!ok) continue;
                if (removeDuplicate) {
                    if (map.get(lowerCase) != null) continue;
                    map.put(lowerCase, item);
                    result.add(item);
                    continue;
                }
                result.add(item);
            }
        }
        return result;
    }

    private List<String> cut(String value) {
        Vector<String> v = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(value);
        while (tokenizer.hasMoreElements()) {
            String element = (String)tokenizer.nextElement();
            v.add(element.toLowerCase());
        }
        return v;
    }

    private void updateAutoCompletion(boolean autoselectIfMatch) {
        if (!this.isCompletionEnabled() || this.isLoading) {
            return;
        }
        String t = this.text.getText().trim();
        List<IComboSelectionItem> l = this.getPossibleValues(t);
        if (l.size() != this.model.getSize() && l.size() <= 10) {
            this.hidePopup();
        }
        this.model.removeAllElements();
        this.model.addAll(l);
        if (l.size() > 0) {
            this.showPopup();
        } else {
            this.hidePopup();
        }
        int newId = this.selectedId;
        boolean found = false;
        for (IComboSelectionItem element : l) {
            if (!element.getLabel().equalsIgnoreCase(t) || !autoselectIfMatch) continue;
            newId = element.getId();
            this.hidePopup();
            found = true;
            break;
        }
        if (this.selectAuto && found && newId != this.selectedId) {
            this.selectedId = newId;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ITextWithCompletion.this.fireSelectionId(ITextWithCompletion.this.getSelectedId());
                }
            });
        }
        if (!found) {
            this.selectedId = -1;
            this.fireSelectionId(-1);
        }
    }

    public synchronized void hidePopup() {
        this.popup.setVisible(false);
    }

    private synchronized void showPopup() {
        if (this.model.getSize() > 0 && this.popupInvoker.isShowing()) {
            this.popup.show(this.popupInvoker, 0, this.text.getBounds().height);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateAutoCompletion(false);
        this.supp.firePropertyChange("value", null, this.getText());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateAutoCompletion(false);
        this.supp.firePropertyChange("value", null, this.getText());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateAutoCompletion(false);
        this.supp.firePropertyChange("value", null, this.getText());
    }

    public int getSelectedId() {
        return this.selectedId;
    }

    public void setSelectedId(int selectedId) {
        this.selectedId = selectedId;
    }

    private void clearText() {
        this.setText("");
    }

    public void setEditable(boolean b) {
        this.text.setEditable(b);
    }

    @Override
    public void itemSelected(IComboSelectionItem item) {
        this.selectId(item.getId());
    }

    public synchronized void selectId(int id) {
        if (this.isLoading) {
            this.idToSelect = id;
        } else if (this.selectedId != id) {
            this.setSelectedId(id);
            this.selectItem(this.mainCache.getFromId(id));
            this.fireSelectionId(id);
        }
    }

    public void setFillWithField(String s) {
        this.fillWith = s;
    }

    public SQLField getFillWithField() {
        return this.comboRequest.getPrimaryTable().getField(this.fillWith);
    }

    public void selectItem(IComboSelectionItem item) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Not in Swing!");
        }
        if (item != null) {
            if (this.fillWith != null) {
                SQLRow row = this.comboRequest.getPrimaryTable().getRow(item.getId());
                this.setText(row.getObject(this.fillWith).toString());
            } else {
                this.setText(item.getLabel());
            }
        } else {
            this.clearText();
        }
        this.hidePopup();
    }

    public void setText(String label) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Not in Swing!");
        }
        this.setCompletionEnabled(false);
        this.text.setText(label);
        if (label != null) {
            this.text.setCaretPosition(label.length());
        }
        this.text.repaint();
        this.setCompletionEnabled(true);
    }

    public void addSelectionListener(SelectionListener l) {
        this.listeners.add(l);
    }

    public void removeSelectionListener(SelectionListener l) {
        this.listeners.remove(l);
    }

    private void fireSelectionId(int id) {
        if (!this.isDispatching) {
            this.isDispatching = true;
            for (SelectionListener element : this.listeners) {
                element.idSelected(id, this);
            }
            this.isDispatching = false;
        }
    }

    boolean isCompletionEnabled() {
        return this.completionEnabled;
    }

    void setCompletionEnabled(boolean completionEnabled) {
        this.completionEnabled = completionEnabled;
    }

    public Object getText() {
        return this.text.getText();
    }

    public void setPopupInvoker(Component popupInvoker) {
        this.popupInvoker = popupInvoker;
    }

    public void setModeCompletion(int mode) {
        this.modeCompletion = mode;
    }

    @Override
    public JTextComponent getTextComp() {
        return this.text;
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    public void setSelectionAutoEnabled(boolean b) {
        this.selectAuto = b;
    }

    public void setWhere(Where w) {
        this.comboRequest.setWhere(w);
        this.loadCacheAsynchronous();
    }

    public void setLimitedSize(int nbChar) {
        DocumentFilterList dfl = DocumentFilterList.get((AbstractDocument)this.text.getDocument());
        Iterator<DocumentFilter> iter = dfl.getFilters().iterator();
        while (iter.hasNext()) {
            DocumentFilter df = iter.next();
            if (!(df instanceof LimitedSizeDocumentFilter)) continue;
            iter.remove();
        }
        DocumentFilterList.add((AbstractDocument)this.text.getDocument(), new LimitedSizeDocumentFilter(nbChar), DocumentFilterList.FilterType.SIMPLE_FILTER);
    }

    @Override
    public void resetValue() {
        this.setText("");
    }

    @Override
    public void setValue(String val) {
        this.setText(val);
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(l);
    }

    @Override
    public String getValue() {
        return (String)this.getText();
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
    }
}

