/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.FieldExpander;
import org.openconcerto.sql.ShowAs;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.FilteredFillSQLRequest;

public class ListSQLRequest
extends FilteredFillSQLRequest {
    private final List<SQLField> listFields;
    private final FieldExpander showAs;

    public ListSQLRequest(SQLTable table, List fieldss) {
        this(table, fieldss, null);
    }

    public ListSQLRequest(SQLTable table, List fieldss, Where where) {
        this(table, fieldss, where, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ListSQLRequest(SQLTable table, List fieldss, Where where, SQLTable cutAtAncestor) {
        super(table, where);
        if (!this.getPrimaryTable().isOrdered()) {
            throw new IllegalArgumentException(table + " is not ordered.");
        }
        if (cutAtAncestor == table) {
            throw new IllegalArgumentException("the primaryTable: " + this.getPrimaryTable() + "is the same than cutAtAncestor");
        }
        ArrayList<SQLField> tmpList = new ArrayList<SQLField>();
        for (Object field : fieldss) {
            SQLField f;
            if (field instanceof String) {
                f = this.getPrimaryTable().getField((String)field);
            } else {
                if (!(field instanceof SQLField)) throw new IllegalArgumentException("must be a fieldname or a SQLField but got : " + field);
                SQLField fToCheck = (SQLField)field;
                if (!fToCheck.getTable().equals(this.getPrimaryTable())) throw new IllegalArgumentException("field " + fToCheck + " not part of the primary table : " + this.getPrimaryTable());
                f = fToCheck;
            }
            tmpList.add(f);
        }
        this.listFields = Collections.unmodifiableList(tmpList);
        Configuration conf = Configuration.getInstance();
        if (conf == null) {
            this.showAs = FieldExpander.getEmpty();
            return;
        } else if (cutAtAncestor == null) {
            this.showAs = conf.getShowAs();
            return;
        } else {
            ShowAs tmp = new ShowAs(conf.getShowAs());
            tmp.removeTable(cutAtAncestor);
            tmp.show(cutAtAncestor, Collections.<String>emptyList());
            this.showAs = tmp;
        }
    }

    public ListSQLRequest(ListSQLRequest req) {
        this(req, false);
    }

    protected ListSQLRequest(ListSQLRequest req, boolean freeze) {
        super(req, freeze);
        this.listFields = req.listFields;
        this.showAs = req.showAs;
    }

    @Override
    public ListSQLRequest toUnmodifiable() {
        return this.toUnmodifiableP(ListSQLRequest.class);
    }

    @Override
    protected ListSQLRequest cloneForFreeze() {
        return new ListSQLRequest(this, true);
    }

    @Override
    protected FieldExpander getShowAs() {
        return this.showAs;
    }

    public final List<SQLField> getFields() {
        return this.listFields;
    }

    @Override
    protected void customizeToFetch(SQLRowValues graphToFetch) {
        super.customizeToFetch(graphToFetch);
        this.addField(graphToFetch, this.getPrimaryTable().getCreationDateField());
        this.addField(graphToFetch, this.getPrimaryTable().getCreationUserField());
        this.addField(graphToFetch, this.getPrimaryTable().getModifDateField());
        this.addField(graphToFetch, this.getPrimaryTable().getModifUserField());
        this.addField(graphToFetch, this.getPrimaryTable().getFieldRaw("UI_LOCK"));
        this.addField(graphToFetch, this.getPrimaryTable().getFieldRaw("ID_USER_UI_LOCK"));
    }

    private void addField(SQLRowValues graphToFetch, SQLField f) {
        if (f != null && !graphToFetch.getFields().contains(f.getName())) {
            if (f.isKey()) {
                graphToFetch.putRowValues(f.getName()).putNulls("NOM", "PRENOM");
            } else {
                graphToFetch.put(f.getName(), null);
            }
        }
    }
}

