/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLFilter;
import org.openconcerto.sql.model.SQLFilterListener;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.TableRef;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.BaseFillSQLRequest;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.Tuple2;

public abstract class FilteredFillSQLRequest
extends BaseFillSQLRequest {
    private Tuple2<Set<SQLRow>, Path> filterInfo;
    private final SQLFilter filter;
    private boolean filterEnabled = false;
    private final SQLFilterListener filterListener = new SQLFilterListener(){

        @Override
        public void filterChanged(Collection<SQLTable> tables) {
            if (!FilteredFillSQLRequest.this.isFrozen() && CollectionUtils.containsAny(FilteredFillSQLRequest.this.getTables(), tables)) {
                FilteredFillSQLRequest.this.updateFilterWhere(true);
            }
        }
    };

    protected static final Tuple2<SQLTable, Set<Number>> rows2ids(Collection<SQLRow> rows) {
        HashSet<SQLTable> tables = new HashSet<SQLTable>();
        HashSet<Number> ids = new HashSet<Number>(rows.size());
        for (SQLRow r : rows) {
            tables.add(r.getTable());
            ids.add(r.getIDNumber());
        }
        SQLTable filterTable = (SQLTable)CollectionUtils.getSole(tables);
        if (filterTable == null) {
            throw new IllegalStateException("not 1 table: " + rows);
        }
        return Tuple2.create(filterTable, ids);
    }

    protected static final SQLFilter getDefaultFilter() {
        Configuration conf = Configuration.getInstance();
        return conf == null ? null : conf.getFilter();
    }

    public FilteredFillSQLRequest(SQLTable primaryTable, Where w) {
        super(primaryTable, w);
        this.filter = FilteredFillSQLRequest.getDefaultFilter();
        this.filterInfo = Tuple2.create(null, null);
        this.setFilterEnabled(true);
    }

    public FilteredFillSQLRequest(FilteredFillSQLRequest req) {
        this(req, false);
    }

    protected FilteredFillSQLRequest(FilteredFillSQLRequest req, boolean freeze) {
        super(req);
        assert (Thread.holdsLock(req));
        this.filter = req.filter;
        this.filterInfo = req.filterInfo;
        if (freeze) {
            this.filterEnabled = req.filterEnabled;
        } else {
            this.setFilterEnabled(req.filterEnabled);
        }
    }

    @Override
    protected void wasFrozen() {
        super.wasFrozen();
        this.getFilter().rmListener(this.filterListener);
    }

    protected final SQLFilter getFilter() {
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setFilterEnabled(boolean b) {
        boolean changed;
        SQLFilter filter = this.getFilter();
        b = filter == null ? false : b;
        FilteredFillSQLRequest filteredFillSQLRequest = this;
        synchronized (filteredFillSQLRequest) {
            this.checkFrozen();
            if (this.filterEnabled != b) {
                assert (filter != null);
                this.filterEnabled = b;
                if (this.filterEnabled) {
                    filter.addWeakListener(this.filterListener);
                } else {
                    filter.rmListener(this.filterListener);
                }
                changed = this.updateFilterWhere(false);
            } else {
                changed = false;
            }
        }
        if (changed) {
            this.fireWhereChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateFilterWhere(boolean fire) {
        boolean changed;
        FilteredFillSQLRequest filteredFillSQLRequest = this;
        synchronized (filteredFillSQLRequest) {
            changed = this.filterEnabled ? this.setFilterWhere(this.getFilter().getLeaf(), this.getFilter().getPath(this.getPrimaryTable())) : this.setFilterWhere(null, null);
        }
        if (fire && changed) {
            this.fireWhereChange();
        }
        return changed;
    }

    private synchronized boolean setFilterWhere(Set<SQLRow> w, Path p) {
        boolean changed;
        this.checkFrozen();
        boolean bl = changed = !CompareUtils.equals(this.filterInfo.get0(), w) || !CompareUtils.equals(this.filterInfo.get1(), p);
        if (changed) {
            this.filterInfo = w == null || p == null ? Tuple2.create(null, null) : Tuple2.create(new HashSet<SQLRow>(w), p);
        }
        return changed;
    }

    public final SQLRowValues getValues(int id) {
        List<SQLRowValues> res = this.getValues(new Where((FieldRef)this.getPrimaryTable().getKey(), "=", id));
        return this.getSole(res, id);
    }

    protected final <T> T getSole(List<T> res, int id) {
        if (res.size() > 1) {
            throw new IllegalStateException("there's more than one line which has ID " + id + " for " + this + " : " + res);
        }
        return CollectionUtils.getFirst(res);
    }

    public final List<SQLRowValues> getValues() {
        return this.getValues(null);
    }

    protected List<SQLRowValues> getValues(Where w) {
        return this.getFetcher().fetch(w);
    }

    protected final List<SQLRowValues> fetchValues(SQLRowValuesListFetcher f, Where w) {
        return this.setupFetcher(f).fetch(w);
    }

    @Override
    protected SQLSelect transformSelect(SQLSelect sel) {
        Tuple2<Set<SQLRow>, Path> filterInfo = this.getFilterInfo();
        if (filterInfo.get1() != null) {
            Tuple2<SQLTable, Set<Number>> tableNids = FilteredFillSQLRequest.rows2ids((Collection<SQLRow>)filterInfo.get0());
            SQLTable filterTable = tableNids.get0();
            Path path = filterInfo.get1();
            TableRef lastAlias = sel.assurePath(this.getPrimaryTable().getName(), path);
            if (filterTable != lastAlias.getTable()) {
                throw new IllegalStateException("table mismatch: " + filterTable + " is not from " + lastAlias + ": " + lastAlias.getTable());
            }
            sel.andWhere(new Where(lastAlias.getKey(), (Collection)tableNids.get1()));
        }
        return super.transformSelect(sel);
    }

    public final Set<SQLRow> getFilterRows() {
        return this.getFilterInfo().get0();
    }

    private final synchronized Tuple2<Set<SQLRow>, Path> getFilterInfo() {
        return this.filterInfo;
    }

    public final Where getInstanceWhere() {
        return this.getFetcher().getReq().getWhere();
    }
}

