/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.HierarchyLevel;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSchema;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.IncludeExclude;

public abstract class StructureSource<E extends Exception> {
    private final TablesMap toRefresh;
    private final SQLBase base;
    private boolean preVerify;
    private Map<String, SQLSchema> newStructure;
    private final boolean hasExternalStruct;
    private final Map<String, SQLSchema> externalStruct;
    private final Set<String> externalOutOfDateSchemas;

    public StructureSource(SQLBase b, TablesMap toRefresh) {
        this(b, toRefresh, null, null);
    }

    public StructureSource(SQLBase b, TablesMap toRefresh, Map<String, SQLSchema> externalStruct, Set<String> externalOutOfDateSchemas) {
        this.base = b;
        this.toRefresh = TablesMap.create(toRefresh);
        if (this.toRefresh != null) {
            this.toRefresh.removeAllEmptyCollections();
        }
        this.preVerify = false;
        this.newStructure = null;
        this.hasExternalStruct = externalStruct != null;
        Map<Object, Object> map = this.externalStruct = externalStruct == null ? Collections.emptyMap() : externalStruct;
        if (externalOutOfDateSchemas == null) {
            if (externalStruct != null) {
                throw new NullPointerException("Null out of date");
            }
            externalOutOfDateSchemas = Collections.emptySet();
        }
        this.externalOutOfDateSchemas = externalOutOfDateSchemas;
    }

    final TablesMap getToRefresh() {
        return this.toRefresh;
    }

    final Set<String> getSchemasToRefresh() {
        return this.getToRefresh() == null ? null : this.getToRefresh().keySet();
    }

    final Set<String> getTablesToRefresh(String schema) {
        if (this.getToRefresh() == null) {
            return null;
        }
        assert (this.getToRefresh().containsKey(schema));
        return (Set)this.getToRefresh().get(schema);
    }

    final boolean hasExternalStruct() {
        return this.hasExternalStruct;
    }

    public void init() throws PrechangeException {
        try {
            this.getBase().getDataSource().useConnection(new ConnectionHandlerNoSetup<Object, E>(){

                @Override
                public Object handle(final SQLDataSource ds) throws Exception {
                    try {
                        return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                StructureSource.this.getNames(ds.getConnection());
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        Exception origExn = (Exception)e.getCause();
                        throw origExn;
                    }
                }
            });
            if (this.isPreVerify()) {
                this.newStructure = this.createTables();
                this.fillTablesP();
            }
        }
        catch (Exception e) {
            throw new PrechangeException(e);
        }
    }

    final Map<String, SQLSchema> getNewStructure() {
        return this.newStructure;
    }

    abstract Set<String> getOutOfDateSchemas();

    private final Map<String, SQLSchema> createTables() {
        HashMap<String, SQLSchema> res = new HashMap<String, SQLSchema>();
        Set<String> newSchemas = this.getSchemas();
        for (String schemaName : newSchemas) {
            SQLSchema schema = new SQLSchema(this.getBase(), schemaName);
            res.put(schemaName, schema);
        }
        Set<SQLName> newTableNames = this.getTablesNames();
        for (SQLName tableName : newTableNames) {
            SQLSchema s = (SQLSchema)res.get(tableName.getItemLenient(-2));
            s.addTableWithoutSysRootLock(tableName.getName());
        }
        return res;
    }

    protected abstract void getNames(Connection var1) throws E;

    public final SQLBase getBase() {
        return this.base;
    }

    protected final Set<String> getJDBCSchemas(DatabaseMetaData metaData) throws SQLException {
        HashSet<String> res = new HashSet<String>((List)SQLDataSource.COLUMN_LIST_HANDLER.handle(metaData.getSchemas()));
        if (res.isEmpty() && !this.getBase().getServer().getSQLSystem().getLevels().contains(HierarchyLevel.SQLSCHEMA)) {
            res.add(null);
        }
        return res;
    }

    public final void setPreVerify(boolean preVerify) {
        this.preVerify = preVerify;
    }

    public final boolean isPreVerify() {
        return this.preVerify;
    }

    public final boolean isInTotalScope(String schemaName) {
        return this.getBase().getDBSystemRoot().createNode(this.getBase(), schemaName) && (this.toRefresh == null || this.getSchemasToRefresh().contains(schemaName));
    }

    protected final void filterOutOfScope(Collection<String> schemas) {
        Iterator<String> iter = schemas.iterator();
        while (iter.hasNext()) {
            String schema = iter.next();
            if (this.isInScope(schema)) continue;
            iter.remove();
        }
    }

    protected final boolean isInScope(String schema) {
        return this.isInTotalScope(schema) && (!this.externalStruct.containsKey(schema) || this.externalOutOfDateSchemas.contains(schema));
    }

    final IncludeExclude<String> getTablesInScope(String schema) {
        Set excludes;
        assert (this.isInScope(schema)) : "Schema " + schema + " not in scope and this method doesn't check it";
        Set<String> includes = this.getTablesToRefresh(schema);
        if (this.hasExternalStruct()) {
            SQLSchema externalSchema = this.externalStruct.get(schema);
            assert (externalSchema == null == !this.externalStruct.containsKey(schema)) : "externalStruct has a null value";
            excludes = externalSchema == null ? Collections.emptySet() : externalSchema.getChildrenNames();
        } else {
            excludes = Collections.emptySet();
        }
        return IncludeExclude.getNormalized(includes, excludes);
    }

    public final Set<String> getExistingSchemasToRefresh() {
        return CollectionUtils.inter(this.getBase().getChildrenNames(), this.getSchemasToRefresh());
    }

    public final Set<SQLName> getExistingTablesToRefresh() {
        if (this.toRefresh == null) {
            return this.getBase().getAllTableNames();
        }
        HashSet<SQLName> res = new HashSet<SQLName>();
        for (String schemaName : this.getExistingSchemasToRefresh()) {
            Set tablesToRefresh = (Set)this.getToRefresh().get(schemaName);
            SQLSchema schema = this.getBase().getSchema(schemaName);
            for (SQLTable t : schema.getTables()) {
                if (tablesToRefresh != null && !tablesToRefresh.contains(t.getName())) continue;
                res.add(t.getSQLName(schema));
            }
        }
        return res;
    }

    public abstract Set<String> getSchemas();

    public abstract Set<SQLName> getTablesNames();

    public final TablesMap getTablesMap() {
        return this.getTablesMap(false);
    }

    protected final TablesMap getTablesMap(boolean includeEmptySchemas) {
        TablesMap res = new TablesMap();
        if (includeEmptySchemas) {
            for (String s : this.getSchemas()) {
                res.put(s, Collections.emptySet());
            }
        }
        for (SQLName table : this.getTablesNames()) {
            res.add(table.getItemLenient(-2), table.getName());
        }
        return res;
    }

    public final Set<String> getTotalSchemas() {
        return CollectionUtils.union(this.getSchemas(), this.externalStruct.keySet());
    }

    public final Set<SQLName> getTotalTablesNames() {
        HashSet<SQLName> res = new HashSet<SQLName>(this.getTablesNames());
        for (SQLSchema schema : this.externalStruct.values()) {
            for (SQLTable t : schema.getTables()) {
                res.add(t.getSQLName(schema));
            }
        }
        return res;
    }

    public final void fillTables() throws E {
        assert (Thread.holdsLock(this.getBase().getDBSystemRoot().getTreeMutex()));
        this.mutateTo(this.externalStruct);
        if (!this.isPreVerify()) {
            this.fillTablesP();
        } else {
            this.mutateTo(this.newStructure);
        }
    }

    private final void mutateTo(Map<String, SQLSchema> m) {
        for (String schemaName : m.keySet()) {
            SQLSchema s = this.getBase().getSchema(schemaName);
            SQLSchema newSchema = m.get(s.getName());
            s.mutateTo(newSchema);
        }
    }

    protected final SQLSchema getNewSchema(String name) {
        if (!this.isPreVerify()) {
            return this.getBase().getSchema(name);
        }
        return this.newStructure.get(name);
    }

    protected final SQLTable getNewTable(String schemaName, String name) {
        SQLSchema newSchema = this.getNewSchema(schemaName);
        if (newSchema == null) {
            return null;
        }
        return newSchema.getTable(name);
    }

    protected final void fillTablesP() throws E {
        this.fillTables(this.getTablesMap(true));
    }

    protected abstract void fillTables(TablesMap var1) throws E;

    public abstract void save();

    public static final class PrechangeException
    extends RuntimeException {
        public PrechangeException(Throwable cause) {
            super(cause);
        }

        public PrechangeException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

