/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.List;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLItem;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.TableRef;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.Tuple2;

public class SQLSelectJoin
implements SQLItem {
    private static final Tuple2<FieldRef, TableRef> NULL_TUPLE = new Tuple2<Object, Object>(null, null);
    private final SQLSelect parent;
    private final String joinType;
    private final TableRef t;
    private final Where joinW;
    private final FieldRef f;
    private final TableRef foreignTable;
    private Where where;

    private static Tuple2<FieldRef, TableRef> parse(Where w) {
        FieldRef ff;
        FieldRef pk;
        List<FieldRef> fields = w.getFields();
        if (fields.size() != 2) {
            return NULL_TUPLE;
        }
        if (fields.get(0).getField().isPrimaryKey()) {
            pk = fields.get(0);
            ff = fields.get(1);
        } else if (fields.get(1).getField().isPrimaryKey()) {
            pk = fields.get(1);
            ff = fields.get(0);
        } else {
            return NULL_TUPLE;
        }
        if (!ff.getField().getTable().getForeignKeys().contains(ff.getField())) {
            return NULL_TUPLE;
        }
        return Tuple2.create(ff, pk.getTableRef());
    }

    SQLSelectJoin(SQLSelect parent, String joinType, TableRef t, FieldRef ff, TableRef foreignTable) {
        this(parent, joinType, t, new Where(ff, "=", foreignTable.getKey()), ff, foreignTable);
    }

    SQLSelectJoin(SQLSelect parent, String joinType, TableRef t, Where w) {
        this(parent, joinType, t, w, SQLSelectJoin.parse(w));
    }

    private SQLSelectJoin(SQLSelect parent, String joinType, TableRef t, Where w, Tuple2<FieldRef, TableRef> info) {
        this(parent, joinType, t, w, info.get0(), info.get1());
    }

    private SQLSelectJoin(SQLSelect parent, String joinType, TableRef t, Where w, FieldRef ff, TableRef foreignTable) {
        this.parent = parent;
        this.joinType = joinType;
        this.joinW = w;
        this.f = ff;
        this.t = t;
        this.foreignTable = foreignTable;
        this.where = null;
        assert (ff == null || ff.getField().getDBSystemRoot().getGraph().getForeignTable(ff.getField()) == foreignTable.getTable());
    }

    public final void setWhere(Where w) {
        this.where = w;
    }

    public final Where getWhere() {
        return this.where;
    }

    @Override
    public String getSQL() {
        Where archiveW = this.parent.getArchiveWhere(this.getJoinedTable().getTable(), this.getAlias());
        Where undefW = this.parent.getUndefWhere(this.getJoinedTable().getTable(), this.getAlias());
        return " " + this.joinType + " JOIN " + this.t.getSQL() + " on " + this.joinW.and(archiveW).and(undefW).and(this.getWhere());
    }

    public final String getJoinType() {
        return this.joinType;
    }

    public final FieldRef getForeignField() {
        return this.f;
    }

    public final boolean hasForeignField() {
        return this.f != null;
    }

    public final String getAlias() {
        return this.getJoinedTable().getAlias();
    }

    public final TableRef getJoinedTable() {
        return this.t;
    }

    public final TableRef getForeignTable() {
        return this.foreignTable;
    }

    public String toString() {
        return this.getSQL();
    }
}

