/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.model.AliasedField;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.Step;
import org.openconcerto.utils.CollectionMap2Itf;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.CopyUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.RecursionType;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;

public class SQLRowValuesListFetcher {
    private final SQLRowValues graph;
    private final Path descendantPath;
    private ITransformer<SQLSelect, SQLSelect> selTransf;
    private Integer selID;
    private Set<Path> ordered;
    private boolean descendantsOrdered;
    private SQLRowValues minGraph;
    private boolean includeForeignUndef;
    private SQLSelect frozen;
    private boolean freezeRows;
    private Map<Path, Map<Path, SQLRowValuesListFetcher>> grafts;
    private static final ExecutorService exec = new ThreadPoolExecutor(0, 2, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    public static SQLRowValuesListFetcher create(SQLRowValues graph) {
        return SQLRowValuesListFetcher.create(graph, true);
    }

    public static SQLRowValuesListFetcher create(final SQLRowValues graph, final boolean ordered) {
        SQLRowValuesListFetcher f;
        Map<Path, SQLRowValuesListFetcher> graftedFetchers;
        SQLRowValuesListFetcher res;
        final HashMap<Path, Path> handledPaths = new HashMap<Path, Path>();
        Path emptyPath = Path.get(graph.getTable());
        handledPaths.put(emptyPath, emptyPath);
        graph.getGraph().walk(graph, null, new ITransformer<SQLRowValuesCluster.State<Object>, Object>(){

            @Override
            public Path transformChecked(SQLRowValuesCluster.State<Object> input) {
                Path p = input.getPath();
                int i = p.length();
                while (i > 0) {
                    Path subPath = p.subPath(0, i);
                    if (handledPaths.containsKey(subPath)) break;
                    handledPaths.put(subPath, p);
                    --i;
                }
                return null;
            }
        }, RecursionType.DEPTH_FIRST, Link.Direction.REFERENT);
        final ListMap grafts = new ListMap();
        graph.getGraph().walk(graph, null, new ITransformer<SQLRowValuesCluster.State<Object>, Object>(){

            @Override
            public Path transformChecked(SQLRowValuesCluster.State<Object> input) {
                Path p = input.getPath();
                if (!handledPaths.containsKey(p)) {
                    Path pMinusLast = p.minusLast();
                    if (!input.isBackwards()) {
                        Path existingRefPath = (Path)handledPaths.get(pMinusLast);
                        if (!$assertionsDisabled && existingRefPath == null) {
                            throw new AssertionError();
                        }
                        handledPaths.put(p, existingRefPath);
                    } else {
                        if (!grafts.containsKey(pMinusLast)) {
                            SQLRowValues copy = graph.deepCopy();
                            SQLRowValues graftNode = copy.followPath(pMinusLast);
                            graftNode.clear();
                            SQLRowValues previous = copy.followPath(pMinusLast.minusLast());
                            if (!$assertionsDisabled && !p.getStep(-2).isForeign().booleanValue()) {
                                throw new AssertionError();
                            }
                            previous.remove(p.getStep(-2).getSingleField().getName());
                            if (previous.getGraph() == graftNode.getGraph()) {
                                throw new IllegalArgumentException("Graph is not a tree");
                            }
                            SQLRowValuesListFetcher rec = SQLRowValuesListFetcher.create(graftNode, ordered);
                            Collection<SQLRowValuesListFetcher> ungrafted = rec.ungraft();
                            if (ungrafted == null || ungrafted.size() == 0) {
                                if (!$assertionsDisabled && rec.descendantPath.length() <= 0) {
                                    throw new AssertionError();
                                }
                                grafts.add(pMinusLast, rec);
                            } else {
                                grafts.addAll(pMinusLast, ungrafted);
                            }
                        }
                        throw new SQLRowValuesCluster.StopRecurseException().setCompletely(false);
                    }
                }
                return null;
            }
        }, new SQLRowValuesCluster.WalkOptions(Link.Direction.ANY).setRecursionType(RecursionType.BREADTH_FIRST).setStartIncluded(false));
        HashSet refPaths = new HashSet(handledPaths.values());
        refPaths.remove(emptyPath);
        if (refPaths.size() == 1) {
            res = new SQLRowValuesListFetcher(graph, (Path)refPaths.iterator().next());
            graftedFetchers = Collections.emptyMap();
        } else {
            res = new SQLRowValuesListFetcher(graph, false);
            graftedFetchers = new HashMap();
            if (refPaths.size() > 0) {
                Path graftPath = new Path(graph.getTable());
                SQLRowValues copy = graph.deepCopy();
                copy.clear();
                for (Path refPath : refPaths) {
                    f = new SQLRowValuesListFetcher(copy, refPath, true).setOrdered(ordered);
                    res.graft(f, graftPath);
                    graftedFetchers.put(refPath, f);
                }
            }
        }
        res.setOrdered(ordered);
        for (Map.Entry e : grafts.entrySet()) {
            Path graftPath = (Path)e.getKey();
            Path refPath = (Path)handledPaths.get(graftPath);
            f = graftedFetchers.containsKey(refPath) ? (SQLRowValuesListFetcher)graftedFetchers.get(refPath) : res;
            for (SQLRowValuesListFetcher recFetcher : (Collection)e.getValue()) {
                f.graft(recFetcher, graftPath);
            }
        }
        return res;
    }

    private static Path computePath(SQLRowValues graph) {
        final AtomicReference<Object> res = new AtomicReference<Object>(null);
        graph.getGraph().walk(graph, null, new ITransformer<SQLRowValuesCluster.State<Path>, Path>(){

            @Override
            public Path transformChecked(SQLRowValuesCluster.State<Path> input) {
                Collection<SQLRowValues> referentRows = input.getCurrent().getReferentRows();
                int size = referentRows.size();
                if (size > 1) {
                    List<SQLRowValues> toPrint = SQLRowValues.trim(referentRows);
                    throw new IllegalArgumentException(input.getCurrent() + " is referenced by " + toPrint + "\nat " + input.getPath());
                }
                if (size == 0) {
                    if (res.get() == null) {
                        res.set(input.getPath());
                    } else {
                        throw new IllegalStateException();
                    }
                }
                return input.getAcc();
            }
        }, RecursionType.BREADTH_FIRST, Link.Direction.REFERENT);
        assert (res.get() != null);
        return res.get();
    }

    private static final ListMap<Tuple2<Path, Number>, SQLRowValues> createCollectionMap() {
        return new ListMap<Tuple2<Path, Number>, SQLRowValues>(){

            @Override
            public List<SQLRowValues> createCollection(Collection<? extends SQLRowValues> v) {
                ArrayList<SQLRowValues> res = new ArrayList<SQLRowValues>(8);
                res.addAll(v);
                return res;
            }
        };
    }

    public SQLRowValuesListFetcher(SQLRowValues graph) {
        this(graph, false);
    }

    public SQLRowValuesListFetcher(SQLRowValues graph, boolean referents) {
        this(graph, referents ? SQLRowValuesListFetcher.computePath(graph) : null);
    }

    public SQLRowValuesListFetcher(SQLRowValues graph, Path referentPath) {
        this(graph, referentPath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SQLRowValuesListFetcher(SQLRowValues graph, Path referentPath, boolean prune) {
        this.graph = graph.deepCopy();
        Path path = this.descendantPath = referentPath == null ? Path.get(graph.getTable()) : referentPath;
        if (!this.descendantPath.isDirection(Link.Direction.REFERENT)) {
            throw new IllegalArgumentException("path is not (exclusively) referent : " + this.descendantPath);
        }
        SQLRowValues descRow = this.graph.followPath(this.descendantPath);
        if (descRow == null) {
            throw new IllegalArgumentException("path is not contained in the passed rowValues : " + referentPath + "\n" + this.graph.printTree());
        }
        assert (this.descendantPath.getFirst() == this.graph.getTable() && this.descendantPath.isSingleLink());
        if (prune) {
            this.graph.getGraph().walk(descRow, null, new ITransformer<SQLRowValuesCluster.State<Object>, Object>(){

                @Override
                public Object transformChecked(SQLRowValuesCluster.State<Object> input) {
                    if (input.getFrom() == null) {
                        input.getCurrent().clearReferents();
                    } else {
                        input.getCurrent().retainReferent(input.getPrevious());
                    }
                    return null;
                }
            }, RecursionType.BREADTH_FIRST, Link.Direction.FOREIGN);
        }
        for (SQLRowValues curr : this.graph.getGraph().getItems()) {
            if (curr.hasID()) continue;
            curr.setID(null);
        }
        this.graph.getGraph().freeze();
        SQLRowValuesListFetcher sQLRowValuesListFetcher = this;
        synchronized (sQLRowValuesListFetcher) {
            this.selTransf = null;
            this.selID = null;
            this.ordered = Collections.emptySet();
            this.descendantsOrdered = false;
            this.minGraph = null;
            this.includeForeignUndef = false;
            this.frozen = null;
            this.freezeRows = false;
            this.grafts = Collections.emptyMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLRowValuesListFetcher(SQLRowValuesListFetcher f, boolean copyTransf) {
        SQLRowValuesListFetcher sQLRowValuesListFetcher = f;
        synchronized (sQLRowValuesListFetcher) {
            this.graph = f.getGraph().toImmutable();
            this.descendantPath = f.getReferentPath();
            SQLRowValuesListFetcher sQLRowValuesListFetcher2 = this;
            synchronized (sQLRowValuesListFetcher2) {
                this.selTransf = copyTransf ? CopyUtils.copy(f.selTransf) : f.selTransf;
                this.selID = f.getSelID();
                this.ordered = f.getOrder();
                this.descendantsOrdered = f.areReferentsOrdered();
                this.minGraph = f.minGraph == null ? null : f.minGraph.toImmutable();
                this.includeForeignUndef = f.includeForeignUndef;
                this.frozen = null;
                this.freezeRows = f.freezeRows;
                HashMap<Path, Map<Path, SQLRowValuesListFetcher>> outerMutable = new HashMap<Path, Map<Path, SQLRowValuesListFetcher>>(f.grafts);
                for (Map.Entry entry : outerMutable.entrySet()) {
                    HashMap innerMutable = new HashMap((Map)entry.getValue());
                    for (Map.Entry entry2 : innerMutable.entrySet()) {
                        entry2.setValue(new SQLRowValuesListFetcher((SQLRowValuesListFetcher)entry2.getValue(), copyTransf));
                    }
                    entry.setValue(Collections.unmodifiableMap(innerMutable));
                }
                this.grafts = Collections.unmodifiableMap(outerMutable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SQLRowValuesListFetcher toUnmodifiable() {
        SQLRowValuesListFetcher sQLRowValuesListFetcher = this;
        synchronized (sQLRowValuesListFetcher) {
            if (this.isFrozen()) {
                return this;
            }
            return new SQLRowValuesListFetcher(this, false).freeze();
        }
    }

    public final synchronized SQLRowValuesListFetcher freeze() {
        if (!this.isFrozen()) {
            this.frozen = new SQLSelect(this.getReq());
            for (Map<Path, SQLRowValuesListFetcher> m : this.grafts.values()) {
                for (SQLRowValuesListFetcher f : m.values()) {
                    f.freeze();
                }
            }
        }
        return this;
    }

    public final synchronized boolean isFrozen() {
        return this.frozen != null;
    }

    private final void checkFrozen() {
        if (this.isFrozen()) {
            throw new IllegalStateException("this has been frozen: " + this);
        }
    }

    public final synchronized void setReturnedRowsUnmodifiable(boolean b) {
        this.checkFrozen();
        this.freezeRows = b;
    }

    public synchronized boolean areReturnedRowsUnmodifiable() {
        return this.freezeRows;
    }

    public SQLRowValues getGraph() {
        return this.graph;
    }

    public final Path getReferentPath() {
        return this.descendantPath;
    }

    public final synchronized void setIncludeForeignUndef(boolean includeForeignUndef) {
        this.checkFrozen();
        this.includeForeignUndef = includeForeignUndef;
    }

    public final synchronized void setFullOnly(boolean b) {
        this.checkFrozen();
        this.minGraph = b ? this.getGraph().deepCopy() : null;
    }

    public final synchronized void requirePath(Path p) {
        this.checkFrozen();
        if (this.getGraph().followPath(p) == null) {
            throw new IllegalArgumentException("Path not included in this graph : " + p + "\n" + this.getGraph().printGraph());
        }
        if (this.minGraph == null) {
            this.minGraph = new SQLRowValues(this.getGraph().getTable());
        }
        this.minGraph.assurePath(p);
    }

    private final synchronized boolean isPathRequired(Path p) {
        return this.minGraph != null && this.minGraph.followPath(p) != null;
    }

    private boolean fetchReferents() {
        return this.descendantPath.length() > 0;
    }

    public synchronized void setSelTransf(ITransformer<SQLSelect, SQLSelect> selTransf) {
        this.checkFrozen();
        this.selTransf = selTransf;
    }

    public final synchronized ITransformer<SQLSelect, SQLSelect> getSelTransf() {
        return this.selTransf;
    }

    public synchronized void setSelID(Integer selID) {
        this.checkFrozen();
        this.selID = selID;
    }

    public final synchronized Integer getSelID() {
        return this.selID;
    }

    public final synchronized SQLRowValuesListFetcher setOrdered(boolean b) {
        this.setOrder(b ? Collections.singleton(Path.get(this.getGraph().getTable())) : Collections.emptySet(), true);
        this.setReferentsOrdered(b, false);
        return this;
    }

    public final SQLRowValuesListFetcher setOrder(List<Path> order) {
        return this.setOrder(order, false);
    }

    private final synchronized SQLRowValuesListFetcher setOrder(Collection<Path> order, boolean safeVal) {
        this.checkFrozen();
        for (Path p : order) {
            if (this.getGraph().followPath(p) != null) continue;
            throw new IllegalArgumentException("Path not in this " + p);
        }
        this.ordered = safeVal ? (Set<Path>)order : Collections.unmodifiableSet(new LinkedHashSet<Path>(order));
        return this;
    }

    public final synchronized Set<Path> getOrder() {
        return this.ordered;
    }

    public final synchronized SQLRowValuesListFetcher setReferentsOrdered(boolean b, boolean rec) {
        this.descendantsOrdered = b;
        if (rec) {
            for (Map<Path, SQLRowValuesListFetcher> m : this.grafts.values()) {
                for (SQLRowValuesListFetcher f : m.values()) {
                    f.setReferentsOrdered(b, rec);
                }
            }
        }
        return this;
    }

    public final synchronized boolean areReferentsOrdered() {
        return this.descendantsOrdered;
    }

    public final SQLRowValuesListFetcher graft(SQLRowValuesListFetcher other) {
        return this.graft(other, Path.get(this.getGraph().getTable()));
    }

    public final SQLRowValuesListFetcher graft(SQLRowValues other, Path graftPath) {
        return this.graft(new SQLRowValuesListFetcher(other, true), graftPath);
    }

    public final synchronized SQLRowValuesListFetcher graft(SQLRowValuesListFetcher other, Path graftPath) {
        LinkedHashMap<Path, SQLRowValuesListFetcher> innerMutable;
        this.checkFrozen();
        if (this == other) {
            throw new IllegalArgumentException("trying to graft onto itself");
        }
        if (other.getGraph().getTable() != graftPath.getLast()) {
            throw new IllegalArgumentException("trying to graft " + other.getGraph().getTable() + " at " + graftPath);
        }
        SQLRowValues graftPlace = this.getGraph().followPath(graftPath);
        if (graftPlace == null) {
            throw new IllegalArgumentException("path doesn't exist: " + graftPath);
        }
        assert (graftPath.getLast() == graftPlace.getTable());
        if (other.getGraph().hasForeigns()) {
            throw new IllegalArgumentException("shouldn't have foreign rows");
        }
        Path descendantPath = SQLRowValuesListFetcher.computePath(other.getGraph());
        int descendantPathLength = descendantPath.length();
        if (descendantPathLength == 0) {
            throw new IllegalArgumentException("empty path");
        }
        assert (descendantPath.isSingleLink());
        HashMap<Path, Map<Path, SQLRowValuesListFetcher>> outerMutable = new HashMap<Path, Map<Path, SQLRowValuesListFetcher>>(this.grafts);
        if (!this.grafts.containsKey(graftPath)) {
            innerMutable = new LinkedHashMap<Path, SQLRowValuesListFetcher>(4);
        } else {
            Map<Path, SQLRowValuesListFetcher> map = this.grafts.get(graftPath);
            innerMutable = new LinkedHashMap<Path, SQLRowValuesListFetcher>(map);
            block0: for (Map.Entry<Path, SQLRowValuesListFetcher> e : map.entrySet()) {
                Path fetcherPath = e.getKey();
                SQLRowValuesListFetcher fetcher = e.getValue();
                int i = 1;
                while (i <= descendantPathLength) {
                    Path subPath = descendantPath.subPath(0, i);
                    if (!fetcherPath.startsWith(subPath)) continue block0;
                    if (!fetcher.getGraph().followPath(subPath).getFields().equals(other.getGraph().followPath(subPath).getFields())) {
                        throw new IllegalArgumentException("The same node have different fields in different fetcher\n" + graftPath + "\n" + subPath);
                    }
                    ++i;
                }
            }
        }
        SQLRowValuesListFetcher res = innerMutable.put(descendantPath, other);
        outerMutable.put(graftPath, Collections.unmodifiableMap(innerMutable));
        this.grafts = Collections.unmodifiableMap(outerMutable);
        return res;
    }

    public final Collection<SQLRowValuesListFetcher> ungraft() {
        return this.ungraft(Path.get(this.getGraph().getTable()));
    }

    public final synchronized Collection<SQLRowValuesListFetcher> ungraft(Path graftPath) {
        this.checkFrozen();
        if (!this.grafts.containsKey(graftPath)) {
            return null;
        }
        HashMap<Path, Map<Path, SQLRowValuesListFetcher>> outerMutable = new HashMap<Path, Map<Path, SQLRowValuesListFetcher>>(this.grafts);
        Map res = (Map)outerMutable.remove(graftPath);
        this.grafts = Collections.unmodifiableMap(outerMutable);
        return res == null ? null : res.values();
    }

    private final synchronized Map<Path, Map<Path, SQLRowValuesListFetcher>> getGrafts() {
        return this.grafts;
    }

    public final Map<Path, SQLRowValuesListFetcher> getGrafts(Path graftPath) {
        return this.getGrafts().get(graftPath);
    }

    public final CollectionMap2Itf.ListMapItf<Path, SQLRowValuesListFetcher> getFetchers(boolean includeSelf) {
        ListMap<Path, SQLRowValuesListFetcher> res = new ListMap<Path, SQLRowValuesListFetcher>();
        for (Map.Entry<Path, Map<Path, SQLRowValuesListFetcher>> e : this.getGrafts().entrySet()) {
            assert (e.getKey() != null);
            res.putCollection(e.getKey(), e.getValue().values());
        }
        if (includeSelf) {
            res.add(null, this);
        }
        return ListMap.unmodifiableMap(res);
    }

    public final ListMap<Path, SQLRowValuesListFetcher> getFetchers(Path fetchedPath) {
        ListMap<Path, SQLRowValuesListFetcher> res = new ListMap<Path, SQLRowValuesListFetcher>();
        if (this.getGraph().followPath(fetchedPath) != null) {
            res.add(Path.get(this.getGraph().getTable()), this);
        }
        for (Map.Entry<Path, Map<Path, SQLRowValuesListFetcher>> e : this.getGrafts().entrySet()) {
            Path graftPlace = e.getKey();
            if (!fetchedPath.startsWith(graftPlace) || fetchedPath.length() <= graftPlace.length()) continue;
            Path rest = fetchedPath.subPath(graftPlace.length());
            assert (rest.length() > 0);
            for (Map.Entry<Path, SQLRowValuesListFetcher> e2 : e.getValue().entrySet()) {
                Path refPath = e2.getKey();
                SQLRowValuesListFetcher graft = e2.getValue();
                if (refPath.startsWith(rest)) {
                    res.add(graftPlace, graft);
                    continue;
                }
                if (!rest.startsWith(refPath)) continue;
                assert (rest.length() > refPath.length());
                for (Map.Entry e3 : graft.getFetchers(rest).entrySet()) {
                    res.addAll((Path)graftPlace.append((Path)e3.getKey()), (Collection)e3.getValue());
                }
            }
        }
        return res;
    }

    private final void addFields(SQLSelect sel, SQLRowValues vals, String alias) {
        SQLField key = vals.getTable().getKey();
        sel.addSelect(new AliasedField(key, alias));
        for (String fieldName : vals.getFields()) {
            if (fieldName.equals(key.getName())) continue;
            sel.addSelect(new AliasedField(vals.getTable().getField(fieldName), alias));
        }
    }

    public final SQLSelect getReq() {
        return this.getReq(null);
    }

    private final synchronized SQLSelect getReq(Where w) {
        if (this.isFrozen()) {
            if (w == null) {
                return this.frozen;
            }
            SQLSelect res = new SQLSelect(this.frozen);
            res.andWhere(w);
            return res;
        }
        final SQLTable t = this.getGraph().getTable();
        SQLSelect sel = new SQLSelect();
        if (this.includeForeignUndef) {
            sel.setExcludeUndefined(false);
            sel.setExcludeUndefined(true, t);
        }
        this.walk(sel, new ITransformer<SQLRowValuesCluster.State<SQLSelect>, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLRowValuesCluster.State<SQLSelect> input) {
                String alias;
                if (input.getFrom() != null) {
                    String joinType;
                    alias = SQLRowValuesListFetcher.getAlias(input.getAcc(), input.getPath());
                    String aliasPrev = input.getPath().length() == 1 ? null : input.getAcc().followPath(t.getName(), input.getPath().subPath(0, -1)).getAlias();
                    String string = joinType = SQLRowValuesListFetcher.this.isPathRequired(input.getPath()) ? "INNER" : "LEFT";
                    if (input.isBackwards()) {
                        input.getAcc().addBackwardJoin(joinType, alias, input.getFrom(), aliasPrev);
                    } else {
                        input.getAcc().addJoin(joinType, new AliasedField(input.getFrom(), aliasPrev), alias);
                    }
                } else {
                    alias = null;
                }
                SQLRowValuesListFetcher.this.addFields(input.getAcc(), input.getCurrent(), alias);
                return input.getAcc();
            }
        });
        for (Path p : this.getOrder()) {
            sel.addOrder(sel.followPath(t.getName(), p), false);
        }
        if (this.areReferentsOrdered()) {
            int descSize = this.descendantPath.length();
            int i = 1;
            while (i <= descSize) {
                sel.addOrder(sel.followPath(t.getName(), this.descendantPath.subPath(0, i)), false);
                ++i;
            }
        }
        if (this.getSelID() != null) {
            sel.andWhere(new Where((FieldRef)t.getKey(), "=", (Object)this.getSelID()));
        }
        return (this.getSelTransf() == null ? sel : this.getSelTransf().transformChecked(sel)).andWhere(w);
    }

    static String getAlias(SQLSelect sel, Path path) {
        String res = "tAlias";
        int stop = path.length();
        int i = 0;
        while (i < stop) {
            res = String.valueOf(res) + "__" + path.getSingleStep(i).getName();
            ++i;
        }
        res = String.valueOf(res) + "__" + path.getTable(stop).getName();
        return sel.getUniqueAlias(res);
    }

    private <S> void walk(S sel, final ITransformer<SQLRowValuesCluster.State<S>, S> transf) {
        this.getGraph().getGraph().walk(this.getGraph(), sel, transf, RecursionType.BREADTH_FIRST, Link.Direction.FOREIGN);
        this.getGraph().getGraph().walk(this.getGraph(), sel, new ITransformer<SQLRowValuesCluster.State<S>, S>(){

            @Override
            public S transformChecked(SQLRowValuesCluster.State<S> input) {
                Path p = input.getPath();
                if (p.getStep(0).isForeign().booleanValue()) {
                    throw new SQLRowValuesCluster.StopRecurseException().setCompletely(false);
                }
                Step lastStep = p.getStep(p.length() - 1);
                if (!lastStep.isForeign().booleanValue() && p.getDirection() != Link.Direction.REFERENT) {
                    throw new SQLRowValuesCluster.StopRecurseException().setCompletely(false);
                }
                return transf.transformChecked(input);
            }
        }, new SQLRowValuesCluster.WalkOptions(Link.Direction.ANY).setRecursionType(RecursionType.BREADTH_FIRST).setStartIncluded(false));
    }

    public final List<SQLRowValues> fetch() {
        return this.fetch(null);
    }

    private void checkTable(Where w) throws IllegalArgumentException {
        if (w == null) {
            return;
        }
        SQLTable t = this.getGraph().getTable();
        for (FieldRef f : w.getFields()) {
            if (f.getTableRef().equals(t)) continue;
            throw new IllegalArgumentException("Not all from the primary table " + t + " : " + w);
        }
    }

    public final List<SQLRowValues> fetch(Where w) throws IllegalArgumentException {
        return this.fetch(w, null);
    }

    public final List<SQLRowValues> fetch(Where w, Boolean unmodifiableRows) throws IllegalArgumentException {
        return this.fetch(true, w, unmodifiableRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<SQLRowValues> fetch(boolean merge, Where w, Boolean unmodifiableRows) throws IllegalArgumentException {
        List<SQLRowValues> merged;
        boolean freezeRows;
        Map<Path, Map<Path, SQLRowValuesListFetcher>> grafts;
        SQLSelect req;
        this.checkTable(w);
        SQLRowValuesListFetcher sQLRowValuesListFetcher = this;
        synchronized (sQLRowValuesListFetcher) {
            req = this.getReq(w);
            grafts = this.getGrafts();
            freezeRows = unmodifiableRows == null ? this.areReturnedRowsUnmodifiable() : unmodifiableRows.booleanValue();
        }
        final List<FieldRef> selectFields = req.getSelectFields();
        final int selectFieldsSize = selectFields.size();
        ArrayList<String> selectFieldsNames = new ArrayList<String>(selectFieldsSize);
        for (FieldRef f : selectFields) {
            selectFieldsNames.add(f.getField().getName());
        }
        SQLTable table = this.getGraph().getTable();
        int graphSize = this.getGraph().getGraph().size();
        final ArrayList l = new ArrayList(graphSize);
        final AtomicInteger fieldIndex = new AtomicInteger(0);
        this.walk(0, new ITransformer<SQLRowValuesCluster.State<Integer>, Integer>(){

            @Override
            public Integer transformChecked(SQLRowValuesCluster.State<Integer> input) {
                int index = l.size();
                GraphNode node = new GraphNode(input);
                int stop = fieldIndex.get() + node.getFieldCount();
                int i = fieldIndex.get();
                while (i < stop) {
                    if (i >= selectFieldsSize) {
                        throw new IllegalStateException("Fields were removed from the select");
                    }
                    FieldRef field = (FieldRef)selectFields.get(i);
                    if (!node.getTable().equals(field.getTableRef().getTable())) {
                        throw new IllegalStateException("Select field not in " + node + " : " + field);
                    }
                    ++i;
                }
                fieldIndex.set(stop);
                l.add(node);
                return index;
            }
        });
        assert (fieldIndex.get() <= selectFieldsSize);
        if (fieldIndex.get() != selectFieldsSize) {
            throw new IllegalStateException("Fields have been added to the select (which is useless, since only fields specified by rows are returned) : " + selectFields.subList(fieldIndex.get(), selectFieldsSize));
        }
        assert (l.size() == graphSize) : "All nodes weren't explored once : " + l.size() + " != " + graphSize + "\n" + this.getGraph().printGraph();
        boolean mergeReferents = merge && this.fetchReferents();
        boolean mergeGrafts = grafts.size() > 0;
        boolean handlerCanFreeze = !mergeReferents && !mergeGrafts;
        IResultSetHandler rsh = new IResultSetHandler(new RSH(selectFieldsNames, l, freezeRows && handlerCanFreeze), false);
        List<SQLRowValues> res = (List<SQLRowValues>)table.getBase().getDataSource().execute(req.asString(), (ResultSetHandler)rsh, false);
        List<SQLRowValues> list = merged = mergeReferents ? this.merge(res) : res;
        if (mergeGrafts) {
            for (Map.Entry entry : grafts.entrySet()) {
                Path graftPlace = (Path)entry.getKey();
                Path mapPath = Path.get(graftPlace.getLast());
                HashSet<Number> ids = new HashSet<Number>();
                ListMap<Tuple2<Path, Number>, SQLRowValues> byRows = SQLRowValuesListFetcher.createCollectionMap();
                for (SQLRowValues sQLRowValues : merged) {
                    for (SQLRowValues graftPlaceVals : sQLRowValues.followPath(graftPlace, SQLRowValues.CreateMode.CREATE_NONE, false)) {
                        ids.add(graftPlaceVals.getIDNumber());
                        byRows.add(Tuple2.create(mapPath, graftPlaceVals.getIDNumber()), graftPlaceVals);
                    }
                }
                assert (ids.size() == byRows.size());
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    Path descendantPath = (Path)entry2.getKey();
                    assert (descendantPath.getFirst() == graftPlace.getLast()) : descendantPath + " != " + graftPlace;
                    SQLRowValuesListFetcher graft = (SQLRowValuesListFetcher)entry2.getValue();
                    List<SQLRowValues> referentVals = graft.fetch(false, new Where(graft.getGraph().getTable().getKey(), ids), false);
                    SQLRowValuesListFetcher.merge(merged, referentVals, byRows, descendantPath);
                }
            }
        }
        if (freezeRows && !handlerCanFreeze) {
            for (SQLRowValues sQLRowValues : merged) {
                sQLRowValues.getGraph().freeze();
            }
        }
        return merged;
    }

    private static void link(List<GraphNode> l, List<List<SQLRowValues>> rows, int start, int stop, boolean freezeRows) {
        int graphSize = l.size();
        int nodeIndex = 1;
        while (nodeIndex < graphSize) {
            GraphNode node = l.get(nodeIndex);
            String fromName = node.getFromName();
            int linkIndex = node.getLinkIndex();
            boolean backwards = node.isBackwards();
            boolean freeze = freezeRows && nodeIndex == graphSize - 1;
            int i = start;
            while (i < stop) {
                List<SQLRowValues> row = rows.get(i);
                SQLRowValues creatingVals = row.get(nodeIndex);
                if (creatingVals != null) {
                    SQLRowValues valsToPut;
                    SQLRowValues valsToFill;
                    if (backwards) {
                        valsToFill = creatingVals;
                        valsToPut = row.get(linkIndex);
                    } else {
                        valsToFill = row.get(linkIndex);
                        valsToPut = creatingVals;
                    }
                    valsToFill.put(fromName, valsToPut, false);
                }
                if (freeze) {
                    row.get(0).getGraph().freeze();
                }
                ++i;
            }
            ++nodeIndex;
        }
        if (freezeRows && graphSize == 1) {
            int i = start;
            while (i < stop) {
                List<SQLRowValues> row = rows.get(i);
                boolean justFrozen = row.get(0).getGraph().freeze();
                assert (justFrozen) : "Already frozen";
                ++i;
            }
        }
    }

    private final List<SQLRowValues> merge(List<SQLRowValues> l) {
        return SQLRowValuesListFetcher.merge(l, l, null, this.descendantPath);
    }

    private static final List<SQLRowValues> merge(List<SQLRowValues> tree, List<SQLRowValues> graft, ListMap<Tuple2<Path, Number>, SQLRowValues> graftPlaceRows, Path descendantPath) {
        boolean isGraft;
        boolean bl = isGraft = graftPlaceRows != null;
        assert (tree != graft == isGraft) : "Trying to graft onto itself";
        ArrayList<SQLRowValues> res = isGraft ? tree : new ArrayList<SQLRowValues>();
        ListMap<Tuple2<Path, Number>, SQLRowValues> map = isGraft ? graftPlaceRows : SQLRowValuesListFetcher.createCollectionMap();
        int stop = descendantPath.length();
        for (SQLRowValues v : graft) {
            boolean doAdd = true;
            SQLRowValues previous = null;
            int i = stop;
            while (i >= 0 && doAdd) {
                Path subPath = descendantPath.subPath(0, i);
                SQLRowValues desc = v.followPath(subPath);
                if (desc != null) {
                    Tuple2<Path, Number> row = Tuple2.create(subPath, desc.getIDNumber());
                    if (map.containsKey(row)) {
                        doAdd = false;
                        assert (((SQLRowValues)((List)map.get(row)).get(0)).getFields().containsAll(desc.getFields())) : "Discarding an SQLRowValues with more fields : " + desc;
                        if (previous != null) {
                            List destinationRows = (List)map.get(row);
                            int destinationSize = destinationRows.size();
                            assert (destinationSize > 0) : "Map contains row but have no corresponding value: " + row;
                            String ffName = descendantPath.getSingleStep(i).getName();
                            int j = 1;
                            while (j < destinationSize) {
                                SQLRowValues previousCopy = previous.deepCopy().put(ffName, destinationRows.get(j));
                                int k = stop;
                                while (k >= i + 1) {
                                    SQLRowValues descCopy = previousCopy.followPath(descendantPath.subPath(i + 1, k));
                                    if (descCopy != null) {
                                        Tuple2<Path, Number> rowCopy = Tuple2.create(descendantPath.subPath(0, k), descCopy.getIDNumber());
                                        assert (map.containsKey(rowCopy)) : "Since we already iterated with i";
                                        map.add(rowCopy, descCopy);
                                    }
                                    --k;
                                }
                                ++j;
                            }
                            previous.put(ffName, destinationRows.get(0));
                        }
                    } else {
                        map.add(row, desc);
                    }
                    previous = desc;
                }
                --i;
            }
            if (!doAdd) continue;
            assert (!isGraft) : "Adding graft values as tree values";
            res.add(v);
        }
        return res;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " for " + this.getGraph() + " with " + this.getSelID() + " and " + this.getSelTransf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        if (obj instanceof SQLRowValuesListFetcher) {
            Map<Path, Map<Path, SQLRowValuesListFetcher>> oGrafts;
            SQLSelect oReq;
            Map<Path, Map<Path, SQLRowValuesListFetcher>> thisGrafts;
            SQLSelect thisReq;
            SQLRowValuesListFetcher o = (SQLRowValuesListFetcher)obj;
            SQLRowValuesListFetcher sQLRowValuesListFetcher = this;
            synchronized (sQLRowValuesListFetcher) {
                thisReq = this.getReq();
                thisGrafts = this.getGrafts();
            }
            sQLRowValuesListFetcher = o;
            synchronized (sQLRowValuesListFetcher) {
                oReq = o.getReq();
                oGrafts = o.getGrafts();
            }
            return thisReq.equals(oReq) && CompareUtils.equals(this.descendantPath, o.descendantPath) && thisGrafts.equals(oGrafts);
        }
        return false;
    }

    public int hashCode() {
        return this.getReq().hashCode();
    }

    private static final class GraphNode {
        private final SQLTable t;
        private final int fieldCount;
        private final int foreignCount;
        private final int linkIndex;
        private final Step from;

        private GraphNode(SQLRowValuesCluster.State<Integer> input) {
            this.t = input.getCurrent().getTable();
            this.fieldCount = input.getCurrent().size();
            this.foreignCount = input.getCurrent().getForeigns().size();
            this.linkIndex = input.getAcc();
            int length = input.getPath().length();
            this.from = length == 0 ? null : input.getPath().getStep(length - 1);
        }

        public final SQLTable getTable() {
            return this.t;
        }

        public final int getFieldCount() {
            return this.fieldCount;
        }

        public final int getForeignCount() {
            return this.foreignCount;
        }

        public final int getLinkIndex() {
            return this.linkIndex;
        }

        public final String getFromName() {
            return this.from.getSingleField().getName();
        }

        public final boolean isBackwards() {
            return this.from.isForeign() == false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.fieldCount;
            result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
            result = 31 * result + this.linkIndex;
            result = 31 * result + this.t.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GraphNode other = (GraphNode)obj;
            return this.fieldCount == other.fieldCount && this.linkIndex == other.linkIndex && this.t.equals(other.t) && CompareUtils.equals(this.from, other.from);
        }

        public String toString() {
            String link = this.from == null ? "" : " linked to " + this.getLinkIndex() + " by " + this.getFromName() + (this.isBackwards() ? " backwards" : " forewards");
            return String.valueOf(this.getFieldCount()) + " fields of " + this.getTable() + link;
        }
    }

    private static final class Linker
    implements Callable<Object> {
        private final List<GraphNode> l;
        private final List<List<SQLRowValues>> rows;
        private final int fromIndex;
        private final int toIndex;
        private final boolean freezeRows;

        public Linker(List<GraphNode> l, List<List<SQLRowValues>> rows, int first, int last, boolean freezeRows) {
            this.l = l;
            this.rows = rows;
            this.fromIndex = first;
            this.toIndex = last;
            this.freezeRows = freezeRows;
        }

        @Override
        public Object call() throws Exception {
            SQLRowValuesListFetcher.link(this.l, this.rows, this.fromIndex, this.toIndex, this.freezeRows);
            return null;
        }
    }

    private static final class RSH
    implements ResultSetHandler {
        private final List<String> selectFields;
        private final List<GraphNode> graphNodes;
        private final boolean freezeRows;

        private RSH(List<String> selectFields, List<GraphNode> l, boolean freezeRows) {
            this.selectFields = selectFields;
            this.graphNodes = l;
            this.freezeRows = freezeRows;
        }

        @Override
        public Object handle(ResultSet rs) throws SQLException {
            List<GraphNode> l = this.graphNodes;
            int graphSize = l.size();
            int nextToLink = 0;
            ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
            ArrayList<SQLRowValues> res = new ArrayList<SQLRowValues>(64);
            List<List<SQLRowValues>> rows = Collections.synchronizedList(new ArrayList(64));
            while (rs.next()) {
                int rsIndex = 1;
                if (Thread.currentThread().isInterrupted()) {
                    throw new RTInterruptedException("interrupted while fetching");
                }
                ArrayList<SQLRowValues> arrayList = new ArrayList<SQLRowValues>(graphSize);
                int i = 0;
                while (i < graphSize) {
                    SQLRowValues creatingVals;
                    GraphNode node = l.get(i);
                    int stop = rsIndex + node.getFieldCount();
                    Object first = rs.getObject(rsIndex);
                    if (first == null) {
                        creatingVals = null;
                        rsIndex = stop;
                    } else {
                        creatingVals = new SQLRowValues(node.getTable(), node.getFieldCount(), node.getForeignCount(), -1);
                        this.put(creatingVals, rsIndex, first);
                        ++rsIndex;
                    }
                    if (i == 0) {
                        if (creatingVals == null) {
                            throw new IllegalStateException("Null primary row");
                        }
                        res.add(creatingVals);
                    }
                    while (rsIndex < stop) {
                        try {
                            this.put(creatingVals, rsIndex, rs.getObject(rsIndex));
                        }
                        catch (SQLException e) {
                            throw new IllegalStateException("unable to fill " + creatingVals, e);
                        }
                        ++rsIndex;
                    }
                    arrayList.add(creatingVals);
                    ++i;
                }
                rows.add(arrayList);
                int currentCount = rows.size();
                if (currentCount % 1000 != 0) continue;
                futures.add(exec.submit(new Linker(l, rows, nextToLink, currentCount, this.freezeRows)));
                nextToLink = currentCount;
            }
            int rowSize = rows.size();
            assert (nextToLink > 0 == futures.size() > 0);
            if (nextToLink > 0) {
                futures.add(exec.submit(new Linker(l, rows, nextToLink, rowSize, this.freezeRows)));
            }
            if (nextToLink == 0) {
                SQLRowValuesListFetcher.link(l, rows, 0, rowSize, this.freezeRows);
            } else {
                try {
                    for (Future future : futures) {
                        future.get();
                    }
                }
                catch (Exception exception) {
                    throw new IllegalStateException("couldn't link", exception);
                }
            }
            return res;
        }

        protected void put(SQLRowValues creatingVals, int rsIndex, Object obj) {
            creatingVals.put(this.selectFields.get(rsIndex - 1), obj, false);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.graphNodes.hashCode();
            result = 31 * result + this.selectFields.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RSH other = (RSH)obj;
            return this.graphNodes.equals(other.graphNodes) && this.selectFields.equals(other.selectFields);
        }
    }
}

