/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBFileCache;
import org.openconcerto.sql.model.DBItemFileCache;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBStructureItemJDBC;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.HierarchyLevel;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.JDBCStructureSource;
import org.openconcerto.sql.model.LoadingListener;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLIdentifier;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSchema;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLType;
import org.openconcerto.sql.model.StructureSource;
import org.openconcerto.sql.model.XMLStructureSource;
import org.openconcerto.sql.model.graph.DatabaseGraph;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.Tuple3;
import org.openconcerto.utils.cc.CopyOnWriteMap;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.change.CollectionChangeEventCreator;

public class SQLBase
extends SQLIdentifier {
    public static final String STRUCTURE_USE_XML = "org.openconcerto.sql.structure.useXML";
    public static final String STRUCTURE_KEEP_INVALID_XML = "org.openconcerto.sql.structure.keepInvalidXML";
    public static final String ALLOW_OBJECT_REMOVAL = "org.openconcerto.sql.identifier.allowRemoval";
    private final CopyOnWriteMap<String, SQLSchema> schemas;
    private int[] dbVersion;
    static final String FILENAME = "structure.xml";
    private static final Pattern percent = Pattern.compile("%.");
    private static final Pattern singleQuote = Pattern.compile("'", 16);
    private static final Pattern quotedPatrn = Pattern.compile("^'(('')|[^'])*'$");
    private static final Pattern twoSingleQuote = Pattern.compile("''", 16);
    private static final Pattern doubleQuote = Pattern.compile("\"");

    public static final void logCacheError(DBItemFileCache dir, Exception e) {
        Logger logger = Log.get();
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "invalid files in " + dir, e);
        } else {
            logger.info("invalid files in " + dir + "\n" + e.getMessage());
        }
    }

    SQLBase(SQLServer server, String name, String login, String pass) {
        this(server, name, null, login, pass, null);
    }

    SQLBase(SQLServer server, String name, IClosure<? super DBSystemRoot> systemRootInit, String login, String pass, IClosure<? super SQLDataSource> dsInit) {
        super(server, name);
        if (name == null) {
            throw new NullPointerException("null base");
        }
        this.schemas = new CopyOnWriteMap();
        this.dbVersion = null;
        DBSystemRoot sysRoot = this.getDBSystemRoot();
        if (sysRoot.getJDBC() == this) {
            sysRoot.setDS(systemRootInit, login, pass, dsInit);
        }
    }

    final TablesMap init(boolean readCache) {
        try {
            return this.refresh(null, readCache, true);
        }
        catch (SQLException e) {
            throw new IllegalStateException("could not init " + this, e);
        }
    }

    @Override
    protected synchronized void onDrop() {
        this.schemas.clear();
        SQLType.remove(this);
        super.onDrop();
    }

    TablesMap refresh(TablesMap namesToRefresh, boolean readCache) throws SQLException {
        return this.refresh(namesToRefresh, readCache, false);
    }

    private TablesMap refresh(TablesMap namesToRefresh, boolean readCache, boolean inCtor) throws SQLException {
        if (readCache) {
            return this.loadTables(namesToRefresh, inCtor);
        }
        return this.fetchTables(namesToRefresh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TablesMap loadTables(TablesMap childrenNames, boolean inCtor) throws SQLException {
        this.checkDropped();
        if (childrenNames != null && childrenNames.size() == 0) {
            return childrenNames;
        }
        childrenNames = this.assureAllTables(childrenNames);
        DBItemFileCache dir = this.getFileCache();
        Object object = this.getTreeMutex();
        synchronized (object) {
            long t1;
            XMLStructureSource xmlStructSrc = null;
            if (dir != null) {
                try {
                    Log.get().config("for mapping " + this + " trying xmls in " + dir);
                    t1 = System.currentTimeMillis();
                    xmlStructSrc = new XMLStructureSource(this, childrenNames, dir);
                    assert (xmlStructSrc.isPreVerify());
                    xmlStructSrc.init();
                    long t2 = System.currentTimeMillis();
                    Log.get().config("XML took " + (t2 - t1) + "ms for mapping " + this.getName() + "." + xmlStructSrc.getSchemas());
                }
                catch (Exception e) {
                    SQLBase.logCacheError(dir, e);
                    xmlStructSrc = null;
                }
            }
            t1 = System.currentTimeMillis();
            JDBCStructureSource jdbcStructSrc = this.fetchTablesP(childrenNames, xmlStructSrc);
            long t2 = System.currentTimeMillis();
            Log.get().config("JDBC took " + (t2 - t1) + "ms for mapping " + this.getName() + "." + jdbcStructSrc.getSchemas());
            return jdbcStructSrc.getTablesMap();
        }
    }

    private final TablesMap assureAllTables(TablesMap childrenNames) {
        TablesMap res;
        if (childrenNames == null) {
            res = childrenNames;
        } else {
            res = TablesMap.create(childrenNames);
            for (Map.Entry e : childrenNames.entrySet()) {
                String schemaName = (String)e.getKey();
                if (e.getValue() == null || this.contains(schemaName)) continue;
                res.put(schemaName, null);
            }
        }
        return res;
    }

    TablesMap fetchTables(TablesMap childrenNames) throws SQLException {
        if (childrenNames != null && childrenNames.size() == 0) {
            return childrenNames;
        }
        return this.fetchTablesP(this.assureAllTables(childrenNames), null).getTablesMap();
    }

    private JDBCStructureSource fetchTablesP(TablesMap childrenNames, StructureSource<?> external) throws SQLException {
        LoadingListener.StructureLoadingEvent evt = new LoadingListener.StructureLoadingEvent(this, childrenNames == null ? null : childrenNames.keySet());
        DBSystemRoot sysRoot = this.getDBSystemRoot();
        try {
            sysRoot.fireLoading(evt);
            JDBCStructureSource jDBCStructureSource = this.refreshTables(new JDBCStructureSource(this, childrenNames, external == null ? null : external.getNewStructure(), external == null ? null : external.getOutOfDateSchemas()));
            return jDBCStructureSource;
        }
        finally {
            sysRoot.fireLoading(((LoadingListener.LoadingEvent)evt).createFinishingEvent());
        }
    }

    final TablesMap loadTables() throws SQLException {
        return this.loadTables(null);
    }

    final TablesMap loadTables(TablesMap childrenNames) throws SQLException {
        return this.loadTables(childrenNames, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T extends Exception, S extends StructureSource<T>> S refreshTables(final S src) throws T {
        this.checkDropped();
        Object object = this.getTreeMutex();
        synchronized (object) {
            DBRoot root;
            SQLSchema s;
            src.init();
            final Set<String> newSchemas = src.getTotalSchemas();
            Set<String> currentSchemas = src.getExistingSchemasToRefresh();
            SQLBase.mustContain(this, newSchemas, currentSchemas, "schemas");
            CollectionChangeEventCreator c = this.createChildrenCreator();
            for (String schema : CollectionUtils.substract(currentSchemas, newSchemas)) {
                this.schemas.remove(schema).dropped();
            }
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    for (DBItemFileCache savedSchema : SQLBase.this.getSavedCaches(false)) {
                        if (!src.isInTotalScope(savedSchema.getName()) || newSchemas.contains(savedSchema.getName())) continue;
                        savedSchema.delete();
                    }
                    return null;
                }
            });
            for (String schema : CollectionUtils.inter(currentSchemas, newSchemas)) {
                this.getSchema(schema).clearNonPersistent();
            }
            for (String schema : newSchemas) {
                this.createAndGetSchema(schema);
            }
            Set<SQLName> newTableNames = src.getTotalTablesNames();
            Set<SQLName> currentTables = src.getExistingTablesToRefresh();
            SQLBase.mustContain(this, newTableNames, currentTables, "tables");
            for (SQLName tableName : CollectionUtils.substract(currentTables, newTableNames)) {
                s = this.getSchema(tableName.getItemLenient(-2));
                s.rmTable(tableName.getName());
            }
            for (SQLName tableName : CollectionUtils.inter(newTableNames, currentTables)) {
                s = this.getSchema(tableName.getItemLenient(-2));
                s.getTable(tableName.getName()).clearNonPersistent();
            }
            for (SQLName tableName : CollectionUtils.substract(newTableNames, currentTables)) {
                s = this.getSchema(tableName.getItemLenient(-2));
                s.addTable(tableName.getName());
            }
            src.fillTables();
            this.fireChildrenChanged(c);
            assert (this.getServer().getBase(this.getName()) == this);
            TablesMap toRefresh = src.getToRefresh();
            TablesMap byRoot = toRefresh == null ? TablesMap.createByRootFromChildren(this, null) : ((root = this.getDBRoot()) != null ? TablesMap.createFromTables(root.getName(), (Collection)toRefresh.get(null)) : toRefresh);
            this.getDBSystemRoot().descendantsChanged(byRoot, src.hasExternalStruct());
        }
        src.save();
        return src;
    }

    static <T> void mustContain(DBStructureItemJDBC c, Set<T> newC, Set<T> oldC, String name) {
        if (Boolean.getBoolean(ALLOW_OBJECT_REMOVAL)) {
            return;
        }
        Set<T> diff = CollectionUtils.contains(newC, oldC);
        if (diff != null) {
            throw new IllegalStateException("some " + name + " were removed in " + c + ": " + diff);
        }
    }

    public final String getURL() {
        return this.getServer().getURL(this.getName());
    }

    public SQLField getField(String fieldName) {
        String[] parts = fieldName.split("\\.");
        if (parts.length != 2) {
            throw new IllegalArgumentException(String.valueOf(fieldName) + " is not a fully qualified name (like TABLE.FIELD_NAME).");
        }
        String table = parts[0];
        String field = parts[1];
        if (!this.containsTable(table)) {
            return null;
        }
        return this.getTable(table).getField(field);
    }

    public SQLTable getTable(String tablename) {
        return this.getTable(SQLName.parse(tablename));
    }

    public SQLTable getTable(SQLName n) {
        if (n.getItemCount() == 0 || n.getItemCount() > 2) {
            throw new IllegalArgumentException("'" + n + "' is not a dotted tablename");
        }
        if (n.getItemCount() == 1) {
            return this.findTable(n.getName());
        }
        SQLSchema s = this.getSchema(n.getFirst());
        if (s == null) {
            return null;
        }
        return s.getTable(n.getName());
    }

    private SQLTable findTable(String name) {
        DBRoot guessed = this.guessDBRoot();
        return guessed == null ? this.getDBSystemRoot().findTable(name) : guessed.findTable(name);
    }

    public boolean containsTable(String tableName) {
        return this.contains(SQLName.parse(tableName));
    }

    private boolean contains(SQLName n) {
        return this.getTable(n) != null;
    }

    public Set<String> getTableNames() {
        return this.getDefaultSchema().getTableNames();
    }

    public Set<SQLTable> getTables() {
        return this.getDefaultSchema().getTables();
    }

    public Set<SQLName> getAllTableNames() {
        HashSet<SQLName> res = new HashSet<SQLName>();
        for (SQLTable t : this.getAllTables()) {
            res.add(t.getSQLName(this, false));
        }
        return res;
    }

    public Set<SQLTable> getAllTables() {
        HashSet<SQLTable> res = new HashSet<SQLTable>();
        for (SQLSchema s : this.getSchemas()) {
            res.addAll(s.getTables());
        }
        return res;
    }

    @Override
    public Map<String, SQLSchema> getChildrenMap() {
        return this.schemas.getImmutable();
    }

    public final Set<SQLSchema> getSchemas() {
        return new HashSet<SQLSchema>(this.schemas.values());
    }

    public final SQLSchema getSchema(String name) {
        return this.schemas.get(name);
    }

    final SQLSchema getDefaultSchema() {
        List<String> path;
        Map<String, SQLSchema> children = this.getChildrenMap();
        if (children.size() == 0) {
            return null;
        }
        if (children.size() == 1) {
            return children.values().iterator().next();
        }
        if (this.getServer().getSQLSystem().getLevel(DBRoot.class) == HierarchyLevel.SQLSCHEMA && (path = this.getDBSystemRoot().getRootPath()).size() > 0) {
            return children.get(path.get(0));
        }
        throw new IllegalStateException();
    }

    private SQLSchema createAndGetSchema(String name) {
        SQLSchema res = this.getSchema(name);
        if (res == null) {
            res = new SQLSchema(this, name);
            this.schemas.put(name, res);
        }
        return res;
    }

    public final DBRoot guessDBRoot() {
        if (this.getDBRoot() != null) {
            return this.getDBRoot();
        }
        return this.getDBSystemRoot().getDefaultRoot();
    }

    public DatabaseGraph getGraph() {
        if (this.getDBRoot() == null) {
            return this.getDBSystemRoot().getGraph();
        }
        return this.getDBRoot().getGraph();
    }

    public Map<SQLTable, List<Tuple3<SQLRow, SQLField, SQLRow>>> checkIntegrity() {
        HashMap<SQLTable, List<Tuple3<SQLRow, SQLField, SQLRow>>> inconsistencies = new HashMap<SQLTable, List<Tuple3<SQLRow, SQLField, SQLRow>>>();
        for (SQLTable table : this.getAllTables()) {
            List<Tuple3<SQLRow, SQLField, SQLRow>> tableInc = table.checkIntegrity();
            if (tableInc.size() <= 0) continue;
            inconsistencies.put(table, tableInc);
        }
        return inconsistencies;
    }

    public ResultSet execute(String query) {
        return this.getDataSource().executeRaw(query);
    }

    public SQLDataSource getDataSource() {
        return this.getDBSystemRoot().getDataSource();
    }

    public String toString() {
        return this.getName();
    }

    String getFwkMetadata(String schema, String name) {
        return this.getFwkMetadata(Collections.singletonList(schema), name).get(schema);
    }

    private final String getSel(String schema, String name, boolean selSchema) {
        SQLName tableName = new SQLName(this.getName(), schema, "FWK_SCHEMA_METADATA");
        return "SELECT " + (selSchema ? String.valueOf(this.quoteString(schema)) + ", " : "") + "\"VALUE\" FROM " + tableName.quote() + " WHERE \"NAME\"= " + this.quoteString(name);
    }

    private final void exec(Collection<String> schemas, final String name, ResultSetHandler rsh) {
        this.getDataSource().execute(CollectionUtils.join(schemas, "\nUNION ALL ", new ITransformer<String, String>(){

            @Override
            public String transformChecked(String schema) {
                return SQLBase.this.getSel(schema, name, true);
            }
        }), new IResultSetHandler(rsh, false));
    }

    /*
     * Unable to fully structure code
     */
    Map<String, String> getFwkMetadata(final Collection<String> schemas, final String name) {
        block7: {
            if (schemas.isEmpty()) {
                return Collections.emptyMap();
            }
            res = new LinkedHashMap<String, String>();
            CollectionUtils.fillMap(res, schemas);
            rsh = new ResultSetHandler(){

                @Override
                public Object handle(ResultSet rs) throws SQLException {
                    while (rs.next()) {
                        res.put(rs.getString(1), rs.getString(2));
                    }
                    return null;
                }
            };
            try {
                if (this.getDataSource().getTransactionPoint() == null) {
                    this.exec(schemas, name, rsh);
                } else {
                    SQLUtils.executeAtomic(this.getDataSource(), new ConnectionHandlerNoSetup<Object, SQLException>(){

                        @Override
                        public Object handle(SQLDataSource ds) throws SQLException {
                            SQLBase.this.exec(schemas, name, rsh);
                            return null;
                        }
                    }, false);
                }
                break block7;
            }
            catch (Exception exn) {
                sqlExn = SQLUtils.findWithSQLState(exn);
                v0 = tableNotFound = sqlExn != null && (sqlExn.getSQLState().equals("42S02") != false || sqlExn.getSQLState().equals("42P01") != false);
                if (!tableNotFound) {
                    throw new IllegalStateException("Not a missing table exception", sqlExn);
                }
                if (schemas.size() <= 1) break block7;
                ** for (schema : schemas)
            }
lbl-1000:
            // 1 sources

            {
                res.put(schema, this.getFwkMetadata(schema, name));
                continue;
            }
        }
        return res;
    }

    public final String getMDName() {
        return this.getServer().getSQLSystem().getMDName(this.getName());
    }

    public synchronized int[] getVersion() throws SQLException {
        if (this.dbVersion == null) {
            this.dbVersion = this.getDataSource().useConnection(new ConnectionHandlerNoSetup<int[], SQLException>(){

                @Override
                public int[] handle(SQLDataSource ds) throws SQLException, SQLException {
                    DatabaseMetaData md = ds.getConnection().getMetaData();
                    return new int[]{md.getDatabaseMajorVersion(), md.getDatabaseMinorVersion()};
                }
            });
        }
        return this.dbVersion;
    }

    static final boolean isSaved(SQLServer s, String base, String schema) {
        return s.getFileCache().getChild(base, schema).getFile(FILENAME).exists();
    }

    private final DBItemFileCache getFileCache() {
        boolean useXML = this.getDBSystemRoot().useCache();
        DBFileCache fileCache = this.getServer().getFileCache();
        if (!useXML || fileCache == null) {
            return null;
        }
        return fileCache.getChild(this.getName());
    }

    private final DBItemFileCache getSchemaFileCache(String schema) {
        DBItemFileCache item = this.getFileCache();
        if (item == null) {
            return null;
        }
        return item.getChild(schema);
    }

    final List<DBItemFileCache> getSavedShemaCaches() {
        return this.getSavedCaches(true);
    }

    private final List<DBItemFileCache> getSavedCaches(boolean withStruct) {
        DBItemFileCache item = this.getFileCache();
        if (item == null) {
            return Collections.emptyList();
        }
        return item.getSavedDesc(SQLSchema.class, withStruct ? FILENAME : null);
    }

    final boolean isSaved(String schema) {
        return SQLBase.isSaved(this.getServer(), this.getName(), schema);
    }

    public void deleteStructureFiles() {
        for (DBItemFileCache f : this.getSavedCaches(true)) {
            f.getFile(FILENAME).delete();
        }
    }

    boolean save(final String schemaName) {
        DBItemFileCache schemaFileCache = this.getSchemaFileCache(schemaName);
        if (schemaFileCache == null) {
            return false;
        }
        final File schemaFile = schemaFileCache.getFile(FILENAME);
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean run() {
                Writer pWriter = null;
                try {
                    String schema = SQLBase.this.getSchema(schemaName).toXML();
                    if (schema == null) {
                        Boolean bl = false;
                        return bl;
                    }
                    FileUtils.mkdir_p(schemaFile.getParentFile());
                    6 var3_11 = this;
                    synchronized (var3_11) {
                        pWriter = FileUtils.createXMLWriter(schemaFile);
                        pWriter.write("<root codecVersion=\"20141001-1155\" >\n" + schema + "\n</root>\n");
                    }
                    Boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    Log.get().log(Level.WARNING, "unable to save files in " + schemaFile, e);
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    if (pWriter != null) {
                        try {
                            pWriter.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    public final String quote(String pattern, Object ... params) {
        return SQLBase.quote(this, pattern, params);
    }

    @Deprecated
    public static final String quoteStd(String pattern, Object ... params) {
        return SQLBase.quote(null, pattern, params);
    }

    private static final String quote(SQLBase b, String pattern, Object ... params) {
        Matcher m = percent.matcher(pattern);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int lastAppendPosition = 0;
        while (m.find()) {
            String replacement;
            char modifier = m.group().charAt(m.group().length() - 1);
            if (modifier == '%') {
                replacement = "%";
            } else {
                Object param = params[i++];
                if (modifier == 's') {
                    replacement = SQLBase.quoteString(b, param.toString());
                } else if (modifier == 'i') {
                    replacement = param instanceof SQLName ? ((SQLName)param).quote() : SQLBase.quoteIdentifier(param.toString());
                } else {
                    SQLIdentifier ident = (SQLIdentifier)((DBStructureItem)param).getJDBC();
                    if (modifier == 'f') {
                        replacement = ident.getSQLName().quote();
                    } else if (modifier == 'n') {
                        replacement = SQLBase.quoteIdentifier(ident.getName());
                    } else {
                        throw new IllegalArgumentException("unknown modifier: " + modifier);
                    }
                }
            }
            sb.append(pattern.subSequence(lastAppendPosition, m.start()));
            sb.append(replacement);
            lastAppendPosition = m.end();
        }
        sb.append(pattern.substring(lastAppendPosition));
        return sb.toString();
    }

    public String quoteString(String s) {
        return SQLBase.quoteStringStd(s);
    }

    public static final String quoteStringStd(String s) {
        return s == null ? "NULL" : "'" + singleQuote.matcher(s).replaceAll("''") + "'";
    }

    public static final String unquoteStringStd(String s) {
        if (!quotedPatrn.matcher(s).find()) {
            throw new IllegalArgumentException("Invalid quoted string " + s);
        }
        return twoSingleQuote.matcher(s.substring(1, s.length() - 1)).replaceAll("'");
    }

    public static final String quoteString(SQLBase b, String s) {
        return b == null ? SQLBase.quoteStringStd(s) : b.quoteString(s);
    }

    public static final String quoteIdentifier(String identifier) {
        return String.valueOf('\"') + doubleQuote.matcher(identifier).replaceAll("\"\"") + '\"';
    }
}

