/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FieldMapper {
    private final List<Class<?>> classes = new ArrayList();
    private Map<String, String> itemMapping = new HashMap<String, String>();
    private Map<String, String> tableMapping = new HashMap<String, String>();
    private DBRoot root;

    public FieldMapper(DBRoot root) {
        this.root = root;
    }

    public synchronized void addMapperStreamFromClass(Class<?> c) {
        this.classes.add(c);
        this.loadMapping(c);
    }

    public void setTableMapping(String tableId, String tableName) {
        this.tableMapping.put(tableId, tableName);
    }

    public SQLField getSQLFieldForItem(String id) {
        String fieldName = this.itemMapping.get(id);
        if (fieldName == null) {
            return null;
        }
        try {
            SQLField field = this.root.getField(fieldName);
            return field;
        }
        catch (Exception e) {
            Log.get().warning("No field found " + fieldName + " (" + e.getMessage() + ")");
            return null;
        }
    }

    public SQLTable getSQLTableForItem(String id) {
        String tableName = this.tableMapping.get(id);
        if (tableName == null) {
            return null;
        }
        SQLTable table = this.root.getTable(tableName);
        return table;
    }

    public void setTranslationForItem(String id, String tableName, String fieldName) {
        if (id == null) {
            throw new NullPointerException("null id");
        }
        if (tableName == null) {
            throw new NullPointerException("null tableName");
        }
        if (fieldName == null) {
            throw new NullPointerException("null fieldName");
        }
        this.itemMapping.put(id, String.valueOf(tableName) + "." + fieldName);
    }

    public void loadAllMapping() {
        this.itemMapping.clear();
        if (this.classes.size() == 0) {
            Log.get().warning("FieldMapper has no resources to load for root " + this.root.getName());
        }
        for (Class<?> c : this.classes) {
            this.loadMapping(c);
        }
    }

    private InputStream findStream(Class<?> c) {
        String baseName = c.getPackage().getName();
        String resourcePath = String.valueOf(baseName.replace('.', '/')) + "/fieldmapping.xml";
        InputStream ins = c.getClassLoader().getResourceAsStream(resourcePath);
        if (ins == null) {
            Log.get().warning("No ressource " + resourcePath + " found");
        } else {
            Log.get().info("Using ressource " + resourcePath);
        }
        return ins;
    }

    private void loadMapping(Class<?> c) {
        InputStream stream = this.findStream(c);
        this.loadMapping(stream);
    }

    private void loadMapping(InputStream input) {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            try {
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(input);
                NodeList tableChildren = doc.getElementsByTagName("table");
                int size = tableChildren.getLength();
                int i = 0;
                while (i < size) {
                    Element elementTable = (Element)tableChildren.item(i);
                    String tableId = elementTable.getAttributeNode("id").getValue();
                    String tableName = elementTable.getAttributeNode("name").getValue();
                    this.tableMapping.put(tableId, tableName);
                    NodeList fieldChildren = elementTable.getElementsByTagName("field");
                    int size2 = fieldChildren.getLength();
                    int j = 0;
                    while (j < size2) {
                        Element elementField = (Element)fieldChildren.item(j);
                        String fieldId = elementField.getAttributeNode("id").getValue();
                        String fieldName = elementField.getAttributeNode("name").getValue();
                        if (this.itemMapping.containsKey(fieldId)) {
                            throw new IllegalStateException("Duplicate mm translation entry for " + fieldId + " (" + fieldName + " - " + this.itemMapping.get(fieldId) + ")");
                        }
                        String field = String.valueOf(tableName) + "." + fieldName;
                        this.itemMapping.put(fieldId, field);
                        this.itemMapping.put(field, field);
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getItemMapping() {
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(this.itemMapping.keySet());
        Collections.sort(l);
        StringBuilder b = new StringBuilder(l.size() * 50);
        for (String string : l) {
            b.append(string);
            b.append(" : ");
            b.append(this.itemMapping.get(string));
            b.append('\n');
        }
        return b.toString();
    }
}

