/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.model.AliasedTable;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.TableRef;
import org.openconcerto.utils.CollectionUtils;

class AliasedTables {
    private final Map<String, TableRef> tables;
    private DBSystemRoot sysRoot;

    private AliasedTables(Map<String, TableRef> m, DBSystemRoot sysRoot) {
        this.tables = new LinkedHashMap<String, TableRef>(m);
        this.sysRoot = sysRoot;
    }

    public AliasedTables() {
        this((DBSystemRoot)null);
    }

    public AliasedTables(DBSystemRoot sysRoot) {
        this(Collections.emptyMap(), sysRoot);
    }

    AliasedTables(AliasedTables at) {
        this(at.tables, at.sysRoot);
    }

    public TableRef add(String alias, SQLTable t) {
        return this.add(new AliasedTable(t, alias));
    }

    public TableRef add(TableRef table) {
        TableRef res;
        boolean nullSysRoot;
        boolean bl = nullSysRoot = this.sysRoot == null;
        if (!nullSysRoot && this.sysRoot != table.getTable().getDBSystemRoot()) {
            throw new IllegalArgumentException(table + " not in " + this.sysRoot);
        }
        String alias = table.getAlias();
        if (!this.contains(alias)) {
            res = table;
            this.tables.put(alias, res);
            if (nullSysRoot) {
                this.sysRoot = table.getTable().getDBSystemRoot();
            }
        } else {
            if (this.getTable(alias) != table.getTable()) {
                throw new IllegalArgumentException(table.getTable().getSQLName() + " can't be aliased to " + alias + " : " + this.getTable(alias).getSQLName() + " already is");
            }
            res = this.getAliasedTable(alias);
        }
        return res;
    }

    public TableRef add(FieldRef f) {
        return this.add(f.getTableRef());
    }

    public final DBSystemRoot getSysRoot() {
        return this.sysRoot;
    }

    final Map<String, TableRef> getMap() {
        return Collections.unmodifiableMap(this.tables);
    }

    public SQLTable getTable(String alias) {
        return this.getAliasedTable(alias).getTable();
    }

    public TableRef getAlias(SQLTable t) {
        return CollectionUtils.getSole(this.getAliases(t));
    }

    public List<TableRef> getAliases(SQLTable t) {
        ArrayList<TableRef> res = new ArrayList<TableRef>();
        for (TableRef at : this.tables.values()) {
            if (!at.getTable().equals(t)) continue;
            res.add(at);
        }
        return res;
    }

    public TableRef getAliasedTable(String alias) {
        return this.tables.get(alias);
    }

    public String getDeclaration(String alias) {
        return this.getAliasedTable(alias).getSQL();
    }

    public boolean contains(String alias) {
        return this.tables.containsKey(alias);
    }

    public LinkedHashSet<String> getAliases() {
        return new LinkedHashSet<String>(this.tables.keySet());
    }
}

