/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import org.openconcerto.sql.model.AliasedField;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLItem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.TableRef;

public class AliasedTable
implements SQLItem,
TableRef {
    private final SQLTable t;
    private final String alias;

    public AliasedTable(SQLTable t) {
        this(t, null);
    }

    public AliasedTable(SQLTable t, String alias) {
        if (t == null) {
            throw new NullPointerException("f is null");
        }
        this.t = t;
        this.alias = alias == null ? t.getName() : alias;
    }

    @Override
    public final SQLTable getTable() {
        return this.t;
    }

    @Override
    public final String getAlias() {
        return this.alias;
    }

    @Override
    public final AliasedField getField(String fieldName) {
        return new AliasedField(this, fieldName);
    }

    @Override
    public AliasedField getKey() {
        return this.getField(this.getTable().getKey().getName());
    }

    @Override
    public String getSQL() {
        String tableName = this.getTable().getSQLName().quote();
        String qAlias = SQLBase.quoteIdentifier(this.getAlias());
        return String.valueOf(tableName) + (qAlias.equals(tableName) ? "" : " " + qAlias);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " <" + this.getSQL() + ">";
    }

    public boolean equals(Object obj) {
        if (obj instanceof AliasedTable) {
            AliasedTable o = (AliasedTable)obj;
            return this.getAlias().equals(o.getAlias()) && this.getTable().equals(o.getTable());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getAlias().hashCode() + this.getTable().hashCode();
    }
}

