/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.element.BaseSQLElementRow;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementRow;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ListMap;

class SQLElementRowR
extends BaseSQLElementRow {
    public SQLElementRowR(SQLRow row) {
        super(row);
    }

    public SQLElementRowR(SQLElement element, SQLRow row) {
        super(element, row);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SQLElementRowR) {
            SQLElementRowR o = (SQLElementRowR)obj;
            HashMap<SQLRow, SQLRow> copies = new HashMap<SQLRow, SQLRow>();
            if (!this.equalsRec(o, copies)) {
                return false;
            }
            for (SQLRow thisRow : copies.keySet()) {
                Set<String> ffs = this.getElement(thisRow).getNormalForeignFields();
                for (String ff : ffs) {
                    SQLRow copy;
                    SQLRow foreignRow = thisRow.getForeignRow(ff);
                    if (!copies.containsKey(foreignRow) || SQLElementRow.equals((copy = (SQLRow)copies.get(thisRow)).getForeignRow(ff), foreignRow)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean equalsRec(SQLElementRowR o, Map<SQLRow, SQLRow> copies) {
        if (!SQLElementRow.equals(this.getRow(), o.getRow())) {
            return false;
        }
        ListMap<SQLTable, SQLRow> children1 = this.getElem().getChildrenRows(this.getRow());
        ListMap<SQLTable, SQLRow> children2 = this.getElem().getChildrenRows(o.getRow());
        if (!children1.keySet().equals(children2.keySet())) {
            return false;
        }
        for (SQLTable childT : children1.keySet()) {
            List l1 = (List)children1.get(childT);
            List l2 = (List)children2.get(childT);
            if (l1.size() != l2.size()) {
                return false;
            }
            Iterator lIter1 = l1.iterator();
            Iterator lIter2 = l2.iterator();
            while (lIter1.hasNext()) {
                SQLRow r2;
                SQLElementRowR o2;
                SQLRow r1 = (SQLRow)lIter1.next();
                SQLElementRowR o1 = new SQLElementRowR(r1);
                if (!o1.equalsRec(o2 = new SQLElementRowR(r2 = (SQLRow)lIter2.next()), copies)) {
                    return false;
                }
                copies.put(r1, r2);
            }
        }
        return true;
    }
}

