/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidObject;
import org.openconcerto.utils.checks.ValidState;

public class DefaultElementSQLObject
extends ElementSQLObject {
    private JButton expandBtn;
    private boolean expanded;
    private JButton createBtn;
    private JButton supprBtn;
    private JSeparator separator;
    private boolean isSeparatorVisible = true;
    private JPanel editP;
    private JPanel createP;

    public DefaultElementSQLObject(SQLComponent parent, SQLComponent comp) {
        super(parent, comp);
        this.addValidListener(new ValidListener(){

            @Override
            public void validChange(ValidObject src, ValidState newValue) {
                DefaultElementSQLObject.this.compChanged();
            }
        });
    }

    public void showSeparator(boolean visible) {
        this.isSeparatorVisible = visible;
        if (this.separator != null) {
            this.separator.setVisible(visible);
        }
    }

    public void setDecorated(boolean decorated) {
        if (this.expandBtn != null) {
            this.expandBtn.setVisible(decorated);
        }
    }

    @Override
    protected void uiChanged() {
        super.uiChanged();
        this.updateBtns();
    }

    protected void updateBtns() {
        this.createBtn.setVisible(this.isCreatedUIVisible());
        this.supprBtn.setVisible(this.isCreatedUIVisible() && this.deleteAllowed() && !Boolean.FALSE.equals(this.isExpanded()));
    }

    @Override
    protected void uiInit() {
        boolean isPlastic = UIManager.getLookAndFeel().getClass().getName().startsWith("com.jgoodies.plaf.plastic");
        this.expandBtn = new JButton("+/-");
        this.expandBtn.setEnabled(false);
        this.expandBtn.setOpaque(false);
        this.expandBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultElementSQLObject.this.toggleExpand();
            }
        });
        this.supprBtn = new JButton(new ImageIcon(DefaultElementSQLObject.class.getResource("delete.png")));
        this.supprBtn.setToolTipText(TM.getTM().translate("remove", new Object[0]));
        this.supprBtn.setOpaque(false);
        if (isPlastic) {
            this.supprBtn.setBorder(BorderFactory.createEmptyBorder());
        }
        this.supprBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ((e.getModifiers() & 1) != 0 || this.confirm()) {
                    DefaultElementSQLObject.this.setCreated(false);
                }
            }

            private boolean confirm() {
                return JOptionPane.showConfirmDialog(DefaultElementSQLObject.this, TM.getTM().trM("elementSQLObject.delete", "element", DefaultElementSQLObject.this.getSQLChild().getElement().getName()), TM.getTM().trA("sqlElement.confirmDelete", new Object[0]), 0) == 0;
            }
        });
        this.createBtn = new JButton(EditFrame.getCreateMessage(this.getSQLChild().getElement()));
        this.createBtn.setOpaque(isPlastic);
        this.createBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultElementSQLObject.this.setCreated(true);
            }
        });
        this.setLayout(new BoxLayout(this, 3));
    }

    @Override
    protected final void setCreatePanel() {
        if (this.editP != null) {
            this.editP.setVisible(false);
        }
        this.getCreatePanel().setVisible(true);
        this.createBtn.requestFocusInWindow();
        this.revalidate();
        this.repaint();
    }

    private final JPanel getCreatePanel() {
        if (this.createP == null) {
            this.createP = new JPanel();
            this.createP.setOpaque(false);
            this.createP.setLayout(new GridLayout());
            this.createP.add(this.createBtn);
            this.add(this.createP);
        }
        return this.createP;
    }

    @Override
    protected final void setEditPanel() {
        if (this.createP != null) {
            this.createP.setVisible(false);
        }
        this.getEditPanel().setVisible(true);
        this.getEditPanel().requestFocusInWindow();
        this.getSQLChild().resetValue();
        this.revalidate();
        this.repaint();
        this.expand(true);
    }

    private final JPanel getEditPanel() {
        if (this.editP == null) {
            this.editP = new JPanel();
            this.editP.setLayout(new GridBagLayout());
            this.editP.setOpaque(false);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 0.001;
            c.weighty = 0.0;
            c.anchor = 23;
            this.editP.add((Component)this.expandBtn, c);
            ++c.gridy;
            this.editP.add((Component)this.supprBtn, c);
            c.gridx = 2;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridheight = 0;
            c.fill = 1;
            this.getSQLChild().uiInit();
            this.editP.add((Component)this.getSQLChild(), c);
            if (this.isSeparatorVisible) {
                c.gridx = 1;
                c.gridy = 0;
                c.weightx = 0.0;
                c.insets = new Insets(2, 2, 2, 2);
                this.separator = new JSeparator(1);
                this.editP.add((Component)this.separator, c);
            }
            this.add(this.editP);
        }
        return this.editP;
    }

    @Override
    protected void compChanged() {
        this.expandBtn.setEnabled(this.getCurrentID() != -1 && this.getValidState().isValid());
    }

    private final Boolean isExpanded() {
        return this.isCreated() ? Boolean.valueOf(this.expanded) : null;
    }

    private void expand(boolean b) {
        if (!this.isCreated()) {
            throw new IllegalStateException("cannot expand if not created");
        }
        this.expanded = b;
        this.updateBtns();
        this.getSQLChild().setVisible(b);
        this.validate();
    }

    private void toggleExpand() {
        this.expand(this.isExpanded() == false);
    }

    @Override
    public void setEditable(boolean enabled) {
        super.setEditable(enabled);
        this.createBtn.setEnabled(enabled);
        this.supprBtn.setEnabled(enabled);
    }
}

