/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.SetMap;
import org.openconcerto.utils.cc.ITransformer;

final class ArchivedGraph {
    private static final EnumSet<SQLTable.VirtualFields> ARCHIVE_AND_FOREIGNS = EnumSet.of(SQLTable.VirtualFields.FOREIGN_KEYS, SQLTable.VirtualFields.ARCHIVE);
    private final SQLElementDirectory dir;
    private final SQLRowValues graph;
    private final Map<SQLRow, SQLRowValues> graphRows;
    private final Set<SQLRow> toExpand;

    ArchivedGraph(SQLElementDirectory dir, SQLRowValues graph) {
        if (dir == null) {
            throw new NullPointerException("Null SQLElementDirectory");
        }
        this.dir = dir;
        this.graph = graph;
        this.graphRows = new HashMap<SQLRow, SQLRowValues>();
        for (SQLRowValues v : this.graph.getGraph().getItems()) {
            SQLRowValues prev = this.graphRows.put(v.asRow(), v);
            if (prev == null) continue;
            throw new IllegalStateException("Duplicated row : " + v.asRow());
        }
        assert (this.graphRows.size() == this.graph.getGraph().size());
        this.toExpand = new HashSet<SQLRow>(this.graphRows.keySet());
    }

    private final SQLElement getElement(SQLTable t) {
        return this.dir.getElement(t);
    }

    private void expandPrivates() {
        SetMap<SQLTable, Number> idsToExpandPrivate = new SetMap<SQLTable, Number>();
        for (SQLRow sQLRow : this.toExpand) {
            idsToExpandPrivate.add(sQLRow.getTable(), sQLRow.getIDNumber());
        }
        for (Map.Entry entry : idsToExpandPrivate.entrySet()) {
            SQLElement elem = this.getElement((SQLTable)entry.getKey());
            Set ids = (Set)entry.getValue();
            SQLRowValues privateGraph = elem.getPrivateGraph(ARCHIVE_AND_FOREIGNS);
            if (privateGraph.getGraph().size() <= 1) continue;
            SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(privateGraph, false);
            this.setWhereAndArchivePolicy(fetcher, ids, SQLSelect.ArchiveMode.BOTH);
            List<SQLRowValues> fetchedRows = fetcher.fetch();
            assert (fetchedRows.size() == ids.size());
            for (SQLRowValues valsFetched : fetchedRows) {
                for (SQLRowValues v : new ArrayList<SQLRowValues>(valsFetched.getGraph().getItems())) {
                    SQLRow row = v.asRow();
                    if (v == valsFetched) {
                        SQLRowValues toExpandVals = this.graphRows.get(row);
                        toExpandVals.load(valsFetched, null);
                        assert (valsFetched.getFields().isEmpty());
                        for (Map.Entry refEntry : new ListMap(valsFetched.getReferentsMap()).entrySet()) {
                            for (SQLRowValues ref : (Collection)refEntry.getValue()) {
                                ref.put(((SQLTable)entry.getKey()).getName(), toExpandVals);
                            }
                        }
                        assert (valsFetched.getGraph().size() == 1);
                        continue;
                    }
                    this.toExpand.add(row);
                    this.graphRows.put(row, v);
                }
            }
        }
    }

    final SQLRowValues expand() {
        this.expandPrivates();
        while (!this.toExpand.isEmpty()) {
            SetMap<SQLTable, Number> toFetch = new SetMap<SQLTable, Number>();
            SetMap<SQLTable, Number> privateToFetch = new SetMap<SQLTable, Number>();
            HashMap<SQLTable, Set<Link>> foreignFields = new HashMap<SQLTable, Set<Link>>();
            SetMap<SQLRow, String> nonEmptyFieldsPointingToPrivates = new SetMap<SQLRow, String>();
            for (SQLRow rowToExpand : this.toExpand) {
                SQLTable t = rowToExpand.getTable();
                Set ffs = (Set)foreignFields.get(t);
                if (ffs == null) {
                    ffs = t.getDBSystemRoot().getGraph().getForeignLinks(t);
                    foreignFields.put(t, ffs);
                }
                for (Link link : ffs) {
                    SetMap<SQLTable, Number> map;
                    String fieldName = link.getLabel().getName();
                    if (rowToExpand.isForeignEmpty(fieldName)) continue;
                    SQLRow foreignRow = new SQLRow((SQLTable)link.getTarget(), rowToExpand.getInt(fieldName));
                    SQLRowValues existingRow = this.graphRows.get(foreignRow);
                    if (existingRow != null) {
                        this.graphRows.get(rowToExpand).put(fieldName, existingRow);
                        continue;
                    }
                    SQLElement elem = this.getElement(foreignRow.getTable());
                    if (elem.getPrivateParentReferentFields().size() > 0) {
                        nonEmptyFieldsPointingToPrivates.add(rowToExpand, fieldName);
                        map = privateToFetch;
                    } else {
                        map = toFetch;
                    }
                    map.add(foreignRow.getTable(), foreignRow.getIDNumber());
                }
            }
            Map<SQLRow, SQLRowValues> archivedForeignRows = this.fetch(toFetch);
            HashMap<SQLRow, SQLRowValues> added = new HashMap<SQLRow, SQLRowValues>();
            for (SQLRow rowToExpand : this.toExpand) {
                SQLTable sQLTable = rowToExpand.getTable();
                Set ffs = (Set)foreignFields.get(sQLTable);
                assert (ffs != null);
                for (Link ff : ffs) {
                    SQLRow foreignRow;
                    SQLRowValues valsFetched;
                    String fieldName = ff.getLabel().getName();
                    if (rowToExpand.isForeignEmpty(fieldName) || (valsFetched = archivedForeignRows.get(foreignRow = new SQLRow((SQLTable)ff.getTarget(), rowToExpand.getInt(fieldName)))) == null || !valsFetched.isArchived()) continue;
                    this.attach(rowToExpand, fieldName, valsFetched, added);
                    nonEmptyFieldsPointingToPrivates.remove(rowToExpand, fieldName);
                    privateToFetch.remove(foreignRow.getTable(), foreignRow.getIDNumber());
                }
            }
            Map<SQLRow, SQLRowValues> privateFetched = this.fetch(privateToFetch);
            toFetch.clear();
            for (SQLRow r : privateFetched.keySet()) {
                SQLRowValues privateRoot = this.getElement(r.getTable()).getPrivateRoot(r, SQLSelect.ArchiveMode.BOTH);
                toFetch.add(privateRoot.getTable(), ((SQLRowAccessor)privateRoot).getIDNumber());
            }
            Map<SQLRow, SQLRowValues> mainRowFetched = this.fetch(toFetch, SQLSelect.ArchiveMode.BOTH);
            for (Map.Entry entry : nonEmptyFieldsPointingToPrivates.entrySet()) {
                SQLRow rowToExpand = (SQLRow)entry.getKey();
                SQLTable t = rowToExpand.getTable();
                for (String fieldName : (Set)entry.getValue()) {
                    assert (!rowToExpand.isForeignEmpty(fieldName));
                    SQLRow foreignRow = new SQLRow(t.getForeignTable(fieldName), rowToExpand.getInt(fieldName));
                    SQLRowValues valsFetched = mainRowFetched.get(foreignRow);
                    if (valsFetched == null) continue;
                    assert (valsFetched.isArchived());
                    this.attach(rowToExpand, fieldName, valsFetched, added);
                }
            }
            this.toExpand.clear();
            this.toExpand.addAll(added.keySet());
        }
        return this.graph;
    }

    private void attach(SQLRow rowToExpand, String fieldName, SQLRowValues valsFetched, Map<SQLRow, SQLRowValues> added) {
        boolean alreadyLinked = this.graph.getGraph() == valsFetched.getGraph();
        this.graphRows.get(rowToExpand).put(fieldName, valsFetched);
        if (!alreadyLinked) {
            for (SQLRowValues v : valsFetched.getGraph().getItems()) {
                SQLRow row = v.asRow();
                added.put(row, v);
                this.graphRows.put(row, v);
            }
        }
        assert (this.graphRows.size() == this.graph.getGraph().size());
    }

    private void setWhereAndArchivePolicy(final SQLRowValuesListFetcher fetcher, final Set<Number> ids, final SQLSelect.ArchiveMode archiveMode) {
        for (final SQLRowValuesListFetcher f : fetcher.getFetchers(true).allValues()) {
            f.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                @Override
                public SQLSelect transformChecked(SQLSelect input) {
                    if (f == fetcher) {
                        input.andWhere(new Where(fetcher.getGraph().getTable().getKey(), ids));
                    }
                    input.setArchivedPolicy(archiveMode);
                    return input;
                }
            });
        }
    }

    private Map<SQLRow, SQLRowValues> fetch(SetMap<SQLTable, Number> toFetch) {
        return this.fetch(toFetch, SQLSelect.ArchiveMode.ARCHIVED);
    }

    private Map<SQLRow, SQLRowValues> fetch(SetMap<SQLTable, Number> toFetch, SQLSelect.ArchiveMode archiveMode) {
        HashMap<SQLRow, SQLRowValues> res = new HashMap<SQLRow, SQLRowValues>();
        for (Map.Entry e : toFetch.entrySet()) {
            Set ids = (Set)e.getValue();
            SQLTable table = (SQLTable)e.getKey();
            SQLElement elem = this.getElement(table);
            SQLRowValuesListFetcher fetcher = elem.getPrivateParentReferentFields().isEmpty() ? SQLRowValuesListFetcher.create(elem.getPrivateGraph(ARCHIVE_AND_FOREIGNS)) : new SQLRowValuesListFetcher(new SQLRowValues(table).putNulls(table.getFieldsNames(ARCHIVE_AND_FOREIGNS)));
            this.setWhereAndArchivePolicy(fetcher, ids, archiveMode);
            for (SQLRowValues fetchedVals : fetcher.fetch()) {
                for (SQLRowValues v : fetchedVals.getGraph().getItems()) {
                    SQLRow r = v.asRow();
                    res.put(r, v);
                    assert (!this.graphRows.containsKey(r)) : "already in graph : " + r;
                }
            }
        }
        return res;
    }
}

