/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.correct;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLUtils;

public class DeletePrivateOrphans
extends Changer<SQLTable> {
    public DeletePrivateOrphans(DBSystemRoot b) {
        super(b);
    }

    @Override
    protected void changeImpl(final SQLTable t) throws SQLException {
        this.getStream().print(t);
        if (Configuration.getInstance() == null || Configuration.getInstance().getDirectory() == null) {
            throw new IllegalStateException("no directory");
        }
        final SQLElement elem = Configuration.getInstance().getDirectory().getElement(t);
        if (elem == null) {
            this.getStream().println(" : no element");
            return;
        }
        final Set<SQLField> privateParentReferentFields = elem.getPrivateParentReferentFields();
        if (privateParentReferentFields.size() == 0) {
            this.getStream().println(" : not a private table");
            return;
        }
        if (elem.getParentForeignFieldName() != null) {
            throw new IllegalStateException("Private with a parent : " + elem.getParentForeignFieldName());
        }
        Set<SQLField> referentKeys = t.getDBSystemRoot().getGraph().getReferentKeys(t);
        if (!referentKeys.equals(privateParentReferentFields)) {
            throw new IllegalStateException("Table is not only private : " + referentKeys);
        }
        this.getStream().println("... ");
        SQLUtils.executeAtomic(this.getDS(), new SQLUtils.SQLFactory<Object>(){

            @Override
            public Object create() throws SQLException {
                SQLCreateTable createTable = new SQLCreateTable(t.getDBRoot(), "TO_DELETE_IDS");
                createTable.setTemporary(true);
                createTable.setPlain(true);
                String pkName = "ID";
                createTable.addColumn("ID", t.getKey());
                createTable.setPrimaryKey(t.getKey().getName());
                DeletePrivateOrphans.this.getDS().execute(createTable.asString());
                SQLName toDeleteIDsName = new SQLName(createTable.getName());
                SQLSelect selAllIDs = new SQLSelect(true).addSelect(t.getKey());
                selAllIDs.setExcludeUndefined(true);
                DeletePrivateOrphans.this.getDS().execute("INSERT INTO " + toDeleteIDsName.quote() + " " + selAllIDs.asString());
                long total = DeletePrivateOrphans.this.getCount(toDeleteIDsName);
                if (total == 0L) {
                    DeletePrivateOrphans.this.getStream().println("nothing to delete");
                } else {
                    for (SQLField pp : privateParentReferentFields) {
                        DeletePrivateOrphans.this.getDS().execute(t.getBase().quote("DELETE from %i where %i in ( " + new SQLSelect(true).addSelect(pp).asString() + ")", toDeleteIDsName, "ID"));
                    }
                    DeletePrivateOrphans.this.getStream().println("deleting " + DeletePrivateOrphans.this.getCount(toDeleteIDsName) + " / " + total);
                    DeletePrivateOrphans.this.getDS().execute(t.getBase().quote("DELETE from %f where %n in ( select %i from %i )", t, t.getKey(), "ID", toDeleteIDsName));
                }
                DeletePrivateOrphans.this.getDS().execute("DROP TABLE " + toDeleteIDsName.quote());
                if (total > 0L) {
                    HashSet<SQLTable> privateTables = new HashSet<SQLTable>();
                    for (SQLRowValues privateVals : elem.getPrivateGraph().getGraph().getItems()) {
                        privateTables.add(privateVals.getTable());
                    }
                    privateTables.remove(t);
                    for (SQLTable privateTable : privateTables) {
                        DeletePrivateOrphans.this.changeImpl(privateTable);
                    }
                }
                return null;
            }
        });
        this.getStream().println(t + " done");
    }

    private final long getCount(SQLName toDeleteIDsName) {
        return ((Number)this.getDS().execute("SELECT count(*) from " + toDeleteIDsName.quote(), new IResultSetHandler(SQLDataSource.SCALAR_HANDLER, false))).longValue();
    }
}

