/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.convert;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.utils.CompareUtils;

public class SetFKDefault
extends Changer<SQLTable> {
    public SetFKDefault(DBSystemRoot b) {
        super(b);
    }

    @Override
    protected void changeImpl(SQLTable t) throws SQLException {
        Set<Link> foreignLinks = t.getDBSystemRoot().getGraph().getForeignLinks(t);
        AlterTable alter = new AlterTable(t);
        for (Link link : foreignLinks) {
            List<Object> correctDefaults;
            int colCount = link.getCols().size();
            SQLTable target = (SQLTable)link.getTarget();
            SQLField singleField = link.getSingleField();
            if (singleField != null && link.getRefFields().get(0).isPrimaryKey()) {
                Number undefinedID = target.getUndefinedIDNumber();
                correctDefaults = Collections.singletonList(undefinedID == null ? null : singleField.getType().toString(undefinedID));
            } else {
                correctDefaults = new ArrayList(colCount);
                for (SQLField rf : link.getRefFields()) {
                    correctDefaults.add(rf.getDefaultValue());
                }
            }
            assert (correctDefaults.size() == colCount);
            int i = 0;
            for (SQLField ff : link.getFields()) {
                String correctDef = (String)correctDefaults.get(i);
                if (ff.getDefaultValue() == null && !CompareUtils.equals(ff.getDefaultValue(), correctDef)) {
                    this.getStream().println("will change " + ff + " from " + ff.getDefaultValue() + " to " + correctDef);
                    alter.alterColumnDefault(ff.getName(), correctDef);
                }
                ++i;
            }
            assert (i == colCount);
        }
        if (!alter.isEmpty()) {
            this.getDS().execute(alter.asString());
            t.getSchema().updateVersion();
        }
    }
}

