/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import org.openconcerto.erp.generationDoc.DocumentLocalStorageManager;
import org.openconcerto.erp.preferences.TemplateNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.preferences.DefaultPreferencePanel;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.text.SimpleDocumentListener;

public abstract class AbstractGenerationDocumentPreferencePanel
extends DefaultPreferencePanel {
    protected Map<Tuple2<String, String>, String> mapKeyLabel = new HashMap<Tuple2<String, String>, String>();
    private final Map<Tuple2<String, String>, JTextField> mapKeyTextOO = new HashMap<Tuple2<String, String>, JTextField>();
    private final Map<Tuple2<String, String>, JTextField> mapKeyTextPDF = new HashMap<Tuple2<String, String>, JTextField>();
    private JFileChooser fileChooser;
    private static final String formatOO = "Format Open Office : ";
    private static final String formatPDF = "Format PDF : ";
    private static final String parcourir = "...";
    private static final String defaut = "D\u00e9finir l'emplacement suivant pour tous";

    public static String getLabelFromTable(String tableName) {
        String pluralName = Configuration.getInstance().getDirectory().getElement(tableName).getPluralName();
        pluralName = StringUtils.firstUp(pluralName);
        return pluralName;
    }

    @Override
    public void uiInit() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        DefaultGridBagConstraints cDefault = new DefaultGridBagConstraints();
        JLabel labelDefaut = new JLabel(defaut);
        final JTextField textDefault = new JTextField();
        textDefault.setEditable(false);
        JButton buttonDefault = new JButton(parcourir);
        buttonDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractGenerationDocumentPreferencePanel.this.directoryChoose(textDefault);
            }
        });
        final JButton buttonSetDefaut = new JButton("Appliquer");
        buttonSetDefaut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String folder = textDefault.getText();
                for (Map.Entry entry : AbstractGenerationDocumentPreferencePanel.this.mapKeyTextOO.entrySet()) {
                    ((JTextField)entry.getValue()).setText(String.valueOf(folder) + File.separator + AbstractGenerationDocumentPreferencePanel.this.mapKeyLabel.get(entry.getKey()));
                }
                for (Map.Entry entry : AbstractGenerationDocumentPreferencePanel.this.mapKeyTextPDF.entrySet()) {
                    ((JTextField)entry.getValue()).setText(String.valueOf(folder) + File.separator + AbstractGenerationDocumentPreferencePanel.this.mapKeyLabel.get(entry.getKey()));
                }
            }
        });
        textDefault.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                buttonSetDefaut.setEnabled(textDefault.getText().trim().length() > 0);
            }
        });
        buttonSetDefaut.setEnabled(false);
        cDefault.gridx = -1;
        JPanel panelDefaut = new JPanel(new GridBagLayout());
        panelDefaut.add((Component)labelDefaut, cDefault);
        cDefault.weightx = 1.0;
        panelDefaut.add((Component)textDefault, cDefault);
        cDefault.weightx = 0.0;
        panelDefaut.add((Component)buttonDefault, cDefault);
        panelDefaut.add((Component)buttonSetDefaut, cDefault);
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.add((Component)panelDefaut, c);
        ArrayList<Tuple2<String, String>> list = new ArrayList<Tuple2<String, String>>(this.mapKeyLabel.keySet());
        Collections.sort(list, new Comparator<Tuple2<String, String>>(){

            @Override
            public int compare(Tuple2<String, String> o1, Tuple2<String, String> o2) {
                return o1.get0().compareTo(o2.get0());
            }
        });
        JPanel panelGlobal = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cGlobal = new DefaultGridBagConstraints();
        int size = list.size();
        int i = 0;
        while (i < size) {
            final Tuple2 key = (Tuple2)list.get(i);
            cGlobal.gridwidth = 1;
            cGlobal.weightx = 1.0;
            ++cGlobal.gridy;
            cGlobal.gridx = 0;
            cGlobal.anchor = 18;
            if (i == size - 1) {
                cGlobal.weighty = 1.0;
            }
            JPanel panel = new JPanel();
            panel.setOpaque(false);
            panel.setBorder(BorderFactory.createTitledBorder(this.mapKeyLabel.get(key)));
            panel.setLayout(new GridBagLayout());
            DefaultGridBagConstraints cPanel = new DefaultGridBagConstraints();
            panel.add((Component)new JLabel(formatOO), cPanel);
            ++cPanel.gridx;
            cPanel.weightx = 1.0;
            JTextField text = new JTextField();
            text.setEditable(false);
            this.mapKeyTextOO.put(key, text);
            panel.add((Component)text, cPanel);
            JButton button = new JButton(parcourir);
            ++cPanel.gridx;
            cPanel.weightx = 0.0;
            cPanel.fill = 0;
            panel.add((Component)button, cPanel);
            cPanel.fill = 2;
            cPanel.weightx = 0.0;
            ++cPanel.gridy;
            cPanel.gridx = 0;
            cPanel.gridwidth = 1;
            panel.add((Component)new JLabel(formatPDF), cPanel);
            ++cPanel.gridx;
            cPanel.weightx = 1.0;
            JTextField textPDF = new JTextField();
            textPDF.setEditable(false);
            this.mapKeyTextPDF.put(key, textPDF);
            panel.add((Component)textPDF, cPanel);
            JButton buttonPDF = new JButton(parcourir);
            ++cPanel.gridx;
            cPanel.weightx = 0.0;
            cPanel.fill = 0;
            panel.add((Component)buttonPDF, cPanel);
            panelGlobal.add((Component)panel, cGlobal);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractGenerationDocumentPreferencePanel.this.directoryChoose((JTextField)AbstractGenerationDocumentPreferencePanel.this.mapKeyTextOO.get(key));
                }
            });
            buttonPDF.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractGenerationDocumentPreferencePanel.this.directoryChoose((JTextField)AbstractGenerationDocumentPreferencePanel.this.mapKeyTextPDF.get(key));
                }
            });
            ++i;
        }
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        ++c.gridy;
        c.gridx = 0;
        c.fill = 1;
        this.add((Component)new JScrollPane(panelGlobal), c);
        this.setValues();
    }

    @Override
    public void storeValues() {
        try {
            File f;
            File z = new File(".");
            for (Map.Entry<Tuple2<String, String>, JTextField> entry : this.mapKeyTextOO.entrySet()) {
                f = new File(entry.getValue().getText());
                TemplateNXProps.getInstance().setProperty(String.valueOf(entry.getKey().get1()) + "OO", FileUtils.relative(z, f));
                DocumentLocalStorageManager.getInstance().addDocumentDirectory(entry.getKey().get0(), new File(FileUtils.relative(z, f)));
            }
            for (Map.Entry<Tuple2<String, String>, JTextField> entry : this.mapKeyTextPDF.entrySet()) {
                f = new File(entry.getValue().getText());
                TemplateNXProps.getInstance().setProperty(String.valueOf(entry.getKey().get1()) + "PDF", FileUtils.relative(z, f));
                DocumentLocalStorageManager.getInstance().addPDFDirectory(entry.getKey().get0(), new File(FileUtils.relative(z, f)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TemplateNXProps.getInstance().store();
    }

    @Override
    public void restoreToDefaults() {
        JTextField textField;
        File f;
        Color foregroundColor = UIManager.getColor("TextField.foreground");
        for (Map.Entry<Tuple2<String, String>, JTextField> entry : this.mapKeyTextOO.entrySet()) {
            f = DocumentLocalStorageManager.getInstance().getDocumentOutputDirectory("Default");
            textField = entry.getValue();
            if (f.exists()) {
                textField.setForeground(foregroundColor);
            } else {
                textField.setForeground(Color.RED);
            }
            try {
                textField.setText(f.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (Map.Entry<Tuple2<String, String>, JTextField> entry : this.mapKeyTextPDF.entrySet()) {
            f = DocumentLocalStorageManager.getInstance().getDocumentOutputDirectory("Default");
            textField = entry.getValue();
            if (f.exists()) {
                textField.setForeground(foregroundColor);
            } else {
                textField.setForeground(Color.RED);
            }
            try {
                textField.setText(f.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void setValues() {
        try {
            this.updateTextFields(this.mapKeyTextOO, "OO");
            this.updateTextFields(this.mapKeyTextPDF, "PDF");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void updateTextFields(Map<Tuple2<String, String>, JTextField> map, String format) throws IOException {
        Color foregroundColor = UIManager.getColor("TextField.foreground");
        DocumentLocalStorageManager storage = DocumentLocalStorageManager.getInstance();
        for (Map.Entry<Tuple2<String, String>, JTextField> entry : map.entrySet()) {
            File f = format.equalsIgnoreCase("PDF") ? storage.getPDFOutputDirectory(entry.getKey().get0()) : storage.getDocumentOutputDirectory(entry.getKey().get0());
            JTextField textField = entry.getValue();
            if (f.exists()) {
                textField.setForeground(foregroundColor);
            } else {
                textField.setForeground(Color.RED);
            }
            textField.setText(f.getCanonicalPath());
        }
    }

    private void directoryChoose(final JTextField field) {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setFileSelectionMode(1);
        }
        this.fileChooser.setCurrentDirectory(new File(field.getText()));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AbstractGenerationDocumentPreferencePanel.this.fileChooser.showDialog(AbstractGenerationDocumentPreferencePanel.this, "S\u00e9lectionner") == 0) {
                    File selectedFile = AbstractGenerationDocumentPreferencePanel.this.fileChooser.getSelectedFile();
                    if (selectedFile.exists()) {
                        field.setForeground(UIManager.getColor("TextField.foreground"));
                    } else {
                        field.setForeground(Color.RED);
                    }
                    field.setText(selectedFile.getAbsolutePath());
                }
            }
        });
    }
}

