/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.panel.compta;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.panel.compta.AbstractExport;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.StringUtils;

public class ExportEBP_ComptaPro
extends AbstractExport {
    private static final Charset CHARSET = StringUtils.Cp1252;
    private static final char SEP = '\u000e';
    private static final int[] WIDTHS = new int[]{6, 8, 40, 8, 15, 60, 15, 60, 14};
    private static final String SPACES = "                                                       ";
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("##0.00", DecimalFormatSymbols.getInstance(Locale.UK));
    private List<Object[]> data;

    private static String formatCents(Number n) {
        return DECIMAL_FORMAT.format(BigDecimal.valueOf(n.longValue()).movePointLeft(2));
    }

    public ExportEBP_ComptaPro(DBRoot rootSociete) {
        super(rootSociete, "EBPPro", ".txt");
    }

    @Override
    protected int fetchData(Date from, Date to, SQLRow selectedJournal, boolean onlyNew) {
        List l;
        SQLTable tableEcriture = this.getEcritureT();
        SQLTable tableMouvement = tableEcriture.getForeignTable("ID_MOUVEMENT");
        SQLTable tableCompte = tableEcriture.getForeignTable("ID_COMPTE_PCE");
        SQLTable tableJrnl = tableEcriture.getForeignTable("ID_JOURNAL");
        SQLSelect sel = this.createSelect(from, to, selectedJournal, onlyNew);
        sel.addSelect(tableJrnl.getField("CODE"));
        sel.addSelect(tableJrnl.getField("NOM"));
        sel.addSelect(tableEcriture.getField("DATE"));
        sel.addSelect(tableCompte.getField("NUMERO"));
        sel.addSelect(tableCompte.getField("NOM"));
        sel.addSelect(tableMouvement.getField("NUMERO"));
        sel.addSelect(tableEcriture.getField("NOM"));
        sel.addSelect(tableEcriture.getField("DEBIT"));
        sel.addSelect(tableEcriture.getField("CREDIT"));
        sel.addFieldOrder(tableJrnl.getField("CODE"));
        sel.addFieldOrder(tableEcriture.getField("DATE"));
        sel.addFieldOrder(tableMouvement.getField("NUMERO"));
        this.data = l = (List)this.getRootSociete().getDBSystemRoot().getDataSource().execute(sel.asString(), new ArrayListHandler());
        return l == null ? 0 : l.size();
    }

    private final String align(Object o, int widthIndex) {
        return this.align(o, widthIndex, false);
    }

    private final String align(Object o, int widthIndex, boolean allowTruncate) {
        String s = String.valueOf(o).trim();
        return StringUtils.getFixedWidthString(s, WIDTHS[widthIndex], StringUtils.Side.LEFT);
    }

    @Override
    protected void export(OutputStream out) throws IOException {
        OutputStreamWriter bufOut = new OutputStreamWriter(out, CHARSET);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        String firstField = SPACES.substring(0, WIDTHS[0]);
        for (Object[] array : this.data) {
            int sign;
            long cents;
            int fieldIndex = 0;
            bufOut.write(this.align(firstField, fieldIndex++));
            ((Writer)bufOut).write(14);
            bufOut.write(this.align(array[0], fieldIndex++));
            ((Writer)bufOut).write(14);
            bufOut.write(this.align(array[1], fieldIndex++, true));
            ((Writer)bufOut).write(14);
            bufOut.write(this.align(dateFormat.format(array[2]), fieldIndex++));
            ((Writer)bufOut).write(14);
            bufOut.write(this.align(array[3], fieldIndex++));
            ((Writer)bufOut).write(14);
            bufOut.write(this.align(array[4], fieldIndex++, true));
            ((Writer)bufOut).write(14);
            System.err.println("ExportEBP_Pro.export() " + array[5]);
            bufOut.write(this.align(array[5], fieldIndex++));
            ((Writer)bufOut).write(14);
            bufOut.write(this.align(array[6], fieldIndex++, true));
            ((Writer)bufOut).write(14);
            long debit = ((Number)array[7]).longValue();
            long credit = ((Number)array[8]).longValue();
            if (debit > 0L && credit > 0L) {
                throw new IllegalStateException("Both credit and debit");
            }
            if (credit > 0L) {
                cents = credit;
                sign = 45;
            } else {
                cents = debit;
                sign = 32;
            }
            ((Writer)bufOut).write(sign);
            bufOut.write(StringUtils.getFixedWidthString(ExportEBP_ComptaPro.formatCents(cents), WIDTHS[fieldIndex++] - 1, StringUtils.Side.RIGHT, false));
            bufOut.write("\r\n");
        }
    }
}

