/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.panel;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.preferences.GenerationDocGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.cc.ITransformer;

public class PanelOOSQLComponent
extends JPanel {
    private final JCheckBox checkImpression = new JCheckBox("Imprimer");
    private final JCheckBox checkVisu = new JCheckBox("Visualiser");
    private final JCheckBox checkAbo = new JCheckBox("Cr\u00e9er l'abonnement associ\u00e9");

    public PanelOOSQLComponent(BaseSQLComponent comp) {
        super(new GridBagLayout());
        SQLPreferences prefs;
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = -1;
        this.setOpaque(false);
        final SQLTable tableComp = comp.getElement().getTable();
        if (tableComp.getName().equals("SAISIE_VENTE_FACTURE") && tableComp.getDBRoot().contains("ABONNEMENT")) {
            this.add((Component)this.checkAbo, c);
        }
        if ((prefs = SQLPreferences.getMemCached(((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete())).getBoolean(GenerationDocGlobalPreferencePanel.MULTIMOD, false)) {
            if (tableComp.getFieldsName().contains("ID_MODELE")) {
                String labelFor = comp.getLabelFor("ID_MODELE");
                if (labelFor == null || labelFor.trim().length() == 0) {
                    labelFor = "Mod\u00e9les";
                }
                JLabel labelModele = new JLabel(labelFor);
                ElementComboBox boxModele = new ElementComboBox(true, 25);
                SQLElement modeleElement = Configuration.getInstance().getDirectory().getElement("MODELE");
                boxModele.init(modeleElement, modeleElement.getComboRequest(true));
                comp.addView(boxModele, "ID_MODELE");
                boxModele.getRequest().setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

                    @Override
                    public SQLSelect transformChecked(SQLSelect input) {
                        SQLTable table = Configuration.getInstance().getDirectory().getElement("TYPE_MODELE").getTable();
                        Where w = new Where(input.getAlias(table.getField("TABLE")), "=", (Object)tableComp.getName());
                        input.setWhere(w);
                        return input;
                    }
                });
                this.add((Component)labelModele, c);
                DefaultGridBagConstraints.lockMinimumSize(boxModele);
                this.add((Component)boxModele, c);
            } else {
                System.err.println("Impossible d'ajouter la combo pour le choix des mod\u00e8les car le champ ID_MODELE n'est pas pr\u00e9sent dans la table " + tableComp.getName());
                Thread.dumpStack();
            }
        }
        this.add((Component)this.checkImpression, c);
        this.add((Component)this.checkVisu, c);
    }

    public JCheckBox getCheckAbo() {
        return this.checkAbo;
    }

    public boolean isVisualisationSelected() {
        return this.checkVisu.isSelected();
    }

    public boolean isImpressionSelected() {
        return this.checkImpression.isSelected();
    }

    public boolean isCheckAboSelected() {
        return this.checkAbo.isSelected();
    }
}

