/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.panel;

import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;

public class ITreeSelectionNode
extends DefaultMutableTreeNode {
    private SQLRowAccessor row;

    public ITreeSelectionNode(SQLRowAccessor row) {
        this.row = row;
    }

    @Override
    public String toString() {
        if (this.row == null) {
            return "";
        }
        List<SQLField> fields = Configuration.getInstance().getShowAs().getFieldExpand(this.row.getTable());
        if (fields == null) {
            throw new IllegalStateException("no field to expand for table " + this.row.getTable());
        }
        StringBuffer result = new StringBuffer();
        for (SQLField s : fields) {
            result.append(String.valueOf(this.row.getObject(s.getName()).toString()) + " ");
        }
        return result.toString().trim();
    }

    public int getId() {
        return this.row == null ? 1 : this.row.getID();
    }

    public void setRow(SQLRow row) {
        this.row = row;
    }
}

