/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.panel;

import javax.swing.UIManager;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.preferences.UserProps;
import org.openconcerto.ui.tips.Tip;
import org.openconcerto.ui.tips.TipsFrame;

public class ComptaTipsFrame
extends TipsFrame {
    private static ComptaTipsFrame f;

    private ComptaTipsFrame(boolean checked) {
        super(checked);
    }

    @Override
    protected void checkBoxModified(boolean selected) {
        System.err.println("CheckBox changed to " + selected);
        UserProps.getInstance().setProperty("HideTips", String.valueOf(!selected));
        UserProps.getInstance().store();
    }

    public static ComptaTipsFrame getFrame(boolean checked) {
        if (f != null) {
            return f;
        }
        f = new ComptaTipsFrame(checked);
        Tip t1 = new Tip();
        t1.addText("Les fonctions de gestion courante se trouvent dans le menu 'Saisie'.");
        t1.addText("  ");
        t1.addText("Vous y trouverez les interfaces de cr\u00e9ation :");
        t1.addText("- des devis et factures");
        t1.addText("- des achats, livraisons et mouvements stocks");
        t1.addText("- des commandes et bons de r\u00e9ception");
        t1.addText("  ");
        t1.addImage(ComptaTipsFrame.class.getResource("tips_gnx.png"));
        f.addTip(t1);
        Tip t2 = new Tip();
        t2.addText("Le logiciel int\u00e8gre un module de cartographie.");
        t2.addText("  ");
        t2.addImage(ComptaTipsFrame.class.getResource("tips_map.png"));
        f.addTip(t2);
        Tip t3 = new Tip();
        t3.addText(String.valueOf(Configuration.getInstance().getAppName()) + " fonctionne sous Windows 7, Vista et XP");
        t3.addText("et aussi sous Linux et MacOS...");
        t3.addText("  ");
        t3.addImage(ComptaTipsFrame.class.getResource("tips_os.png"));
        f.addTip(t3);
        Tip t4 = new Tip();
        t4.addText("Les s\u00e9lecteurs int\u00e8grent l'auto-compl\u00e9tion.");
        t4.addText(" ");
        t4.addText("Vous commencez \u00e0 \u00e9crire, le logiciel sugg\u00e8re les possibilit\u00e9s!");
        t4.addText(" ");
        t4.addImage(ComptaTipsFrame.class.getResource("tips_auto.png"));
        f.addTip(t4);
        Tip t5 = new Tip();
        t5.addText("Un clic droit sur une ligne...");
        t5.addText("et les fonctionnalit\u00e9s contextuelles apparaissent.");
        t5.addImage(ComptaTipsFrame.class.getResource("tips_click.png"));
        f.addTip(t5);
        Tip t6 = new Tip();
        t6.addText("Le logiciel peut m\u00e9moriser des valeurs (textes).");
        t6.addText(" ");
        t6.addText("Un clic droit sur les s\u00e9lecteurs vous permet d'ajouter et de supprimer des \u00e9l\u00e9ments.");
        t6.addText(" ");
        t6.addImage(ComptaTipsFrame.class.getResource("tips_combo.png"));
        f.addTip(t6);
        Tip t7 = new Tip();
        t7.addText("Les listes poss\u00e8dent une recherche int\u00e9gr\u00e9e.");
        t7.addText("Les r\u00e9sutats sont visibles en temps r\u00e9el.");
        t7.addText(" ");
        t7.addImage(ComptaTipsFrame.class.getResource("tips_search.png"));
        t7.addText(" ");
        t7.addText("Dans cet exemple, nous avons imm\u00e9diatement les \u00e9l\u00e9ments relatifs");
        t7.addText("\u00e0 M. Blanc en 2010 !");
        f.addTip(t7);
        Tip t8 = new Tip();
        t8.addText("Tous les documents cr\u00e9\u00e9s par le logiciel sont standards.");
        t8.addText("");
        t8.addText("Nous utilisons pour cela : ");
        t8.addText("- format PDF  ");
        t8.addText("- format OpenDocument utilisable avec OpenOffice");
        t8.addText(" ");
        t8.addImage(ComptaTipsFrame.class.getResource("tips_oo.png"));
        f.addTip(t8);
        Tip t9 = new Tip();
        t9.addText("Vous pouvez envoyer directement les documents par email.");
        t9.addText(" ");
        t9.addText("Le logiciel est compatible avec :");
        t9.addText("- Outlook, Outlook Express et Mail");
        t9.addText("- Thunderbird ");
        t9.addText(" ");
        t9.addImage(ComptaTipsFrame.class.getResource("tips_firefox.png"));
        f.addTip(t9);
        Tip t10 = new Tip();
        t10.addText("Le logiciel est bas\u00e9 sur la technologie SQL.");
        t10.addText(" ");
        t10.addText("Le logiciel fonctionne avec les bases de donn\u00e9es :");
        t10.addText("- postgreSQL");
        t10.addText("- MySQL ");
        t10.addText("- H2 ");
        t10.addText(" ");
        t10.addImage(ComptaTipsFrame.class.getResource("tips_db.png"));
        f.addTip(t10);
        Tip t11 = new Tip();
        t11.addText("Le logiciel bloque les saisies incorrectes.");
        t11.addText(" ");
        t11.addText("Si le bouton ajouter reste gris\u00e9, un clic affiche la cause.");
        t11.addText(" ");
        t11.addImage(ComptaTipsFrame.class.getResource("tips_add.png"));
        f.addTip(t11);
        f.setCurrentTip(0);
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(2);
        return f;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ComptaTipsFrame f = ComptaTipsFrame.getFrame(true);
        f.setLocationRelativeTo(null);
        f.setCurrentTip(0);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }
}

