/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.beans.DefaultPersistenceDelegate;
import java.beans.PersistenceDelegate;
import java.util.Comparator;
import java.util.regex.Pattern;
import org.openconcerto.erp.modules.ModuleVersion;
import org.openconcerto.utils.CompareUtils;

public class ModuleReference {
    public static final PersistenceDelegate PERSIST_DELEGATE = new DefaultPersistenceDelegate(new String[]{"ID", "version"});
    public static final Comparator<ModuleReference> COMP_ID_ASC_VERSION_DESC = new Comparator<ModuleReference>(){

        @Override
        public int compare(ModuleReference o1, ModuleReference o2) {
            int res = o1.getID().compareTo(o2.getID());
            if (res != 0) {
                return res;
            }
            return -o1.getVersion().compareTo(o2.getVersion());
        }
    };
    static final Pattern javaIdentifiedPatrn = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
    static final Pattern qualifiedPatrn;
    static final Pattern idPatrn;
    private final String id;
    private final ModuleVersion version;

    static {
        idPatrn = qualifiedPatrn = Pattern.compile(String.valueOf(javaIdentifiedPatrn.pattern()) + "(\\." + javaIdentifiedPatrn.pattern() + ")*");
    }

    static String checkMatch(Pattern p, String s, String name) {
        if (!p.matcher(s).matches()) {
            throw new IllegalArgumentException(String.valueOf(name) + " doesn't match " + p.pattern());
        }
        return s;
    }

    public ModuleReference(String id, ModuleVersion version) {
        if (id == null) {
            throw new NullPointerException();
        }
        this.id = ModuleReference.checkMatch(idPatrn, id.trim(), "ID");
        this.version = version;
    }

    public final String getID() {
        return this.id;
    }

    @Deprecated
    public final String getId() {
        return this.getID();
    }

    public final ModuleVersion getVersion() {
        return this.version;
    }

    public String toString() {
        return "Module " + this.id + " " + (this.version == null ? "no version" : this.version);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleReference other = (ModuleReference)obj;
        return this.id.equals(other.id) && CompareUtils.equals(this.version, other.version);
    }
}

