/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.util.Collections;
import java.util.List;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.erp.modules.ModuleReference;

public abstract class ModuleElement
extends ComptaSQLConfElement {
    private final AbstractModule module;

    public ModuleElement(AbstractModule module, String tableName) {
        super(tableName, DEFERRED_CODE);
        this.module = module;
        this.setL18nLocation(module.getClass());
        for (String id : this.getAdditionalIDsForMDPath()) {
            this.addToMDPath(ModuleManager.getMDVariant(new ModuleReference(id, null)));
        }
        this.addToMDPath(ModuleManager.getMDVariant(this.getFactory()));
    }

    protected List<String> getAdditionalIDsForMDPath() {
        return Collections.emptyList();
    }

    public final ModuleFactory getFactory() {
        return this.module.getFactory();
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.module.getFactory().getID()) + '/' + this.createCodeSuffix();
    }

    protected String createCodeSuffix() {
        return this.getTable().getName();
    }
}

