/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jopendocument.link.Component;
import org.jopendocument.model.OpenDocument;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.PreviewFrame;
import org.openconcerto.erp.generationDoc.DefaultNXDocumentPrinter;
import org.openconcerto.erp.generationDoc.SheetInterface;
import org.openconcerto.erp.generationDoc.SheetUtils;
import org.openconcerto.erp.generationDoc.SpreadSheetGeneratorListener;
import org.openconcerto.erp.preferences.TemplateNXProps;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.spreadsheet.MutableCell;
import org.openconcerto.openoffice.spreadsheet.Sheet;
import org.openconcerto.openoffice.spreadsheet.SpreadSheet;
import org.openconcerto.task.config.ComptaBasePropsConfiguration;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.StreamUtils;

public abstract class SpreadSheetGenerator
implements Runnable {
    private Map mCell;
    private Map mapStyleRow;
    private static String modelDir;
    private String modele;
    private String destFileName;
    private File destDirOO;
    private File destDirPDF;
    protected int nbPage;
    protected int nbRowsPerPage;
    private boolean visu;
    private boolean impression;
    private String printer;
    private boolean exportPDF;
    private Map mapReplaceText;
    private String fODSP = null;
    protected static final String defaultLocationTemplate = "/Configuration/Template/Default/";
    private final List<SpreadSheetGeneratorListener> listeners = new ArrayList<SpreadSheetGeneratorListener>();

    static {
        String loc = TemplateNXProps.getInstance().getStringProperty("LocationTemplate");
        if (loc.trim().length() == 0) {
            loc = defaultLocationTemplate;
        }
        SpreadSheetGenerator.setModelDir(loc);
    }

    public static void setModelDir(String loc) {
        modelDir = loc;
        System.err.println("Repertoire des template : " + modelDir);
    }

    protected void searchStyle(Sheet sheet, Map<String, Map<Integer, String>> mapStyleDef, int colEnd, int rowEnd) {
        int columnCount = colEnd == -1 ? sheet.getColumnCount() : colEnd + 1;
        System.err.println("End column search : " + columnCount);
        int rowCount = rowEnd > 0 ? rowEnd : sheet.getRowCount();
        int i = 0;
        while (i < rowCount) {
            int x = 0;
            HashMap<Integer, String> mapCellStyle = new HashMap<Integer, String>();
            String style = "";
            int j = 0;
            while (j < columnCount) {
                if (sheet.isCellValid(j, i)) {
                    MutableCell c = sheet.getCellAt(j, i);
                    String cellStyle = c.getStyleName();
                    if (mapStyleDef.containsKey(c.getValue().toString())) {
                        style = c.getValue().toString();
                    }
                    mapCellStyle.put(new Integer(x), cellStyle);
                    if (style.trim().length() != 0) {
                        c.clearValue();
                    }
                }
                ++x;
                ++j;
            }
            if (style.length() > 0) {
                mapStyleDef.put(style, mapCellStyle);
            }
            ++i;
        }
    }

    protected void fill(Sheet sheet, Map<String, Map<Integer, String>> mapStyleDef) {
        for (Object o : this.mCell.keySet()) {
            Map<Integer, String> styleToApply;
            if (this.mCell.get(o) == null) continue;
            final Point p = sheet.resolveHint(o.toString());
            Object value = this.mCell.get(o);
            boolean cellValid = false;
            try {
                cellValid = sheet.isCellValid(p.x, p.y);
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            if (!cellValid) continue;
            MutableCell cell = sheet.getCellAt(p.x, p.y);
            if (value != null && value.toString().indexOf(10) >= 0) {
                String stringValue = value.toString();
                String firstPart = stringValue.substring(0, stringValue.indexOf(10));
                String secondPart = stringValue.substring(stringValue.indexOf(10) + 1, stringValue.length());
                secondPart = secondPart.replace('\n', ',');
                cell.setValue((Object)firstPart);
                try {
                    MutableCell cellSec = sheet.getCellAt(p.x, p.y + 1);
                    cellSec.setValue((Object)secondPart);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(null, "Impossible d'acc\u00e9der \u00e0 la cellule " + p.x + ";" + (p.y + 1), "Erreur acc\u00e9s cellule", 1);
                        }
                    });
                }
                continue;
            }
            cell.setValue((Object)(value == null ? "" : value));
            Object sty = this.mapStyleRow.get(new Integer(p.y + 1));
            if (sty == null || (styleToApply = mapStyleDef.get(sty.toString())) == null || styleToApply.get(new Integer(p.x)) == null) continue;
            cell.setStyleName(styleToApply.get(new Integer(p.x)));
        }
    }

    protected void replace(Sheet sheet) {
        for (Object o : this.mapReplaceText.keySet()) {
            if (this.mapReplaceText.get(o) == null) continue;
            Object value = this.mapReplaceText.get(o);
            MutableCell cell = sheet.getCellAt(o.toString());
            cell.replaceBy("_", value == null ? "" : value.toString());
        }
    }

    protected SpreadSheet loadTemplate() throws IOException {
        InputStream f = ComptaBasePropsConfiguration.getStreamStatic(String.valueOf(modelDir) + File.separator + this.modele);
        this.fODSP = String.valueOf(modelDir) + File.separator + this.modele + "p";
        if (f == null) {
            f = ComptaBasePropsConfiguration.getStreamStatic(defaultLocationTemplate + File.separator + this.modele);
            this.fODSP = defaultLocationTemplate + File.separator + this.modele + "p";
            if (f == null) {
                ExceptionHandler.handle("Modele " + this.modele + " introuvable. Impossible de g\u00e9n\u00e9rer le document.");
                System.err.println("Modele introuvable : " + defaultLocationTemplate + File.separator + this.modele);
                this.fODSP = null;
                return null;
            }
        }
        SpreadSheet res = new ODPackage(f).getSpreadSheet();
        f.close();
        return res;
    }

    protected File save(SpreadSheet ssheet) throws IOException {
        File fDest = new File(this.destDirOO, String.valueOf(this.destFileName) + ".ods");
        int i = 0;
        String destName = this.destFileName;
        File oldPath = new File(this.destDirOO, "Historique");
        oldPath.mkdirs();
        while (fDest.exists()) {
            destName = String.valueOf(this.destFileName) + "_" + i;
            fDest = new File(oldPath, String.valueOf(destName) + ".ods");
            ++i;
        }
        File fTmp = new File(this.destDirOO, String.valueOf(this.destFileName) + ".ods");
        fTmp.renameTo(fDest);
        fDest = new File(this.destDirOO, String.valueOf(this.destFileName) + ".ods");
        InputStream stream = ComptaBasePropsConfiguration.getStreamStatic(this.fODSP);
        if (stream != null) {
            File odspOut = new File(this.destDirOO, String.valueOf(this.destFileName) + ".odsp");
            StreamUtils.copy(stream, odspOut);
            stream.close();
        }
        try {
            ssheet.saveAs(fDest);
        }
        catch (FileNotFoundException e) {
            final File file = fDest;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        ExceptionHandler.handle("Le fichier " + (file == null ? "" : file.getCanonicalPath()) + " n'a pu \u00eatre cr\u00e9\u00e9. \n V\u00e9rifiez qu'il n'est pas d\u00e9j\u00e0 ouvert.");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            e.printStackTrace();
        }
        return fDest;
    }

    public SpreadSheetGenerator(SheetInterface sheet, String destFileName, boolean impr, boolean visu) {
        this(sheet, destFileName, impr, visu, true);
    }

    public SpreadSheetGenerator(SheetInterface sheet, String destFileName, boolean impr, boolean visu, boolean exportPDF) {
        this.modele = sheet.modele;
        this.mCell = sheet.mCell;
        this.destDirOO = sheet.getDocumentOutputDirectory();
        this.destDirOO.mkdirs();
        this.destDirPDF = sheet.getPDFOutputDirectory();
        this.destDirPDF.mkdirs();
        this.nbPage = sheet.nbPage;
        this.nbRowsPerPage = sheet.nbRowsPerPage;
        this.destFileName = destFileName;
        this.mapStyleRow = sheet.mapStyleRow;
        this.mapReplaceText = sheet.mapReplace;
        this.visu = visu;
        this.impression = impr;
        this.printer = sheet.getPrinter();
        this.exportPDF = exportPDF;
    }

    protected abstract File generateWithStyle() throws IOException;

    @Override
    public void run() {
        File f = null;
        try {
            f = this.generateWithStyle();
            File pdfFileToCreate = new File(this.destDirPDF.getAbsolutePath(), String.valueOf(this.destFileName) + ".pdf");
            try {
                if (!Boolean.getBoolean("org.openconcerto.oo.useODSViewer")) {
                    Component doc = ComptaPropsConfiguration.getOOConnexion().loadDocument(f, !this.visu);
                    if (this.exportPDF) {
                        doc.saveToPDF(pdfFileToCreate);
                    }
                    if (this.impression) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("Name", this.printer);
                        doc.printDocument(map);
                    }
                    doc.close();
                } else {
                    OpenDocument doc = new OpenDocument(f);
                    if (this.visu) {
                        PreviewFrame.show(f);
                    }
                    SheetUtils.convert2PDF(doc, pdfFileToCreate);
                    if (this.impression) {
                        DefaultNXDocumentPrinter printer = new DefaultNXDocumentPrinter();
                        printer.print(doc);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ExceptionHandler.handle("Impossible de charger le document OpenOffice", e);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("Fichier d\u00e9j\u00e0 ouvert!");
            final File ff = f;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExceptionHandler.handle("Le fichier " + (ff == null ? "" : ff.getAbsolutePath()) + " n'a pu \u00eatre cr\u00e9\u00e9. \n V\u00e9rifiez qu'il n'est pas d\u00e9j\u00e0 ouvert.");
                }
            });
        }
        this.fireGenerateEnd();
    }

    private void fireGenerateEnd() {
        for (SpreadSheetGeneratorListener listener : this.listeners) {
            listener.taskEnd();
        }
    }

    public void addGenerateListener(SpreadSheetGeneratorListener l) {
        this.listeners.add(l);
    }
}

