/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jopendocument.link.Component;
import org.jopendocument.link.OOConnexion;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.generationDoc.DocumentLocalStorageManager;
import org.openconcerto.erp.generationDoc.MetaDataSheet;
import org.openconcerto.erp.generationDoc.SheetUtils;
import org.openconcerto.erp.generationDoc.TemplateManager;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.erp.preferences.TemplateNXProps;
import org.openconcerto.odtemplate.Template;
import org.openconcerto.odtemplate.TemplateException;
import org.openconcerto.odtemplate.engine.DataModel;
import org.openconcerto.odtemplate.engine.OGNLDataModel;
import org.openconcerto.openoffice.ODSingleXMLDocument;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;

public abstract class AbstractJOOReportsSheet {
    private static final String defaultLocationTemplate = "/Configuration/Template/Default/";
    protected static final DateFormat dateFormat = new SimpleDateFormat("dd MMMM yyyy");
    protected static final DateFormat dateFormat2 = new SimpleDateFormat("dd/MM/yy");
    protected static final DateFormat yearFormat = new SimpleDateFormat("yyyy");
    private String year;
    protected String locationTemplate = TemplateNXProps.getInstance().getStringProperty("LocationTemplate");
    protected String templateId;
    private String printer;
    protected boolean askOverwriting = false;
    MetaDataSheet meta;

    protected abstract Map createMap();

    protected abstract String getName();

    public String getFileName() {
        return AbstractJOOReportsSheet.getValidFileName(this.getName());
    }

    public void setMetaGeneration(MetaDataSheet meta) {
        this.meta = meta;
    }

    public MetaDataSheet getMetaGeneration() {
        return this.meta;
    }

    static String getValidFileName(String fileName) {
        StringBuffer result = new StringBuffer(fileName.length());
        int i = 0;
        while (i < fileName.length()) {
            char ch = fileName.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '_' || ch == ' ') {
                result.append(ch);
            } else {
                result.append('-');
            }
            ++i;
        }
        return result.toString();
    }

    public abstract String getDefaultTemplateID();

    public abstract String getDefaultLocationProperty();

    protected void init(String year, String templateId, String attributePrinter) {
        this.year = year;
        this.templateId = templateId;
        this.printer = PrinterNXProps.getInstance().getStringProperty(attributePrinter);
    }

    public final void generate(boolean print, boolean show, String printer) {
        this.generate(print, show, printer, false);
    }

    public void generate(boolean print, boolean show, String printer, boolean overwrite) {
        block17: {
            if (this.locationTemplate.trim().length() == 0) {
                this.locationTemplate = defaultLocationTemplate;
            }
            try {
                String fileName = this.getFileName();
                InputStream fileTemplate = TemplateManager.getInstance().getTemplate(this.templateId);
                File outputDir = DocumentLocalStorageManager.getInstance().getDocumentOutputDirectory(this.getDefaultTemplateID());
                File fileOutOO = this.getDocumentFile();
                if (fileOutOO.exists() && overwrite) {
                    if (this.askOverwriting) {
                        int answer = JOptionPane.showConfirmDialog(null, "Voulez vous \u00e9craser le document ?", "Remplacement d'un document", 0);
                        if (answer == 0) {
                            SheetUtils.convertToOldFile(((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete(), fileName, outputDir, fileOutOO, ".odt");
                        }
                    } else {
                        SheetUtils.convertToOldFile(((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete(), fileName, outputDir, fileOutOO, ".odt");
                    }
                }
                if (!fileOutOO.exists()) {
                    fileOutOO.getParentFile().mkdirs();
                    Template template = new Template((InputStream)new BufferedInputStream(fileTemplate));
                    Map createMap = this.createMap();
                    OGNLDataModel model = new OGNLDataModel((Object)createMap);
                    model.putAll(createMap);
                    ODSingleXMLDocument createDocument = template.createDocument((DataModel)model);
                    if (this.meta != null) {
                        this.meta.applyTo(createDocument.getPackage().getMeta(true));
                    }
                    createDocument.saveToPackageAs(fileOutOO);
                }
                if (!show && !print) break block17;
                try {
                    OOConnexion ooConnexion = ComptaPropsConfiguration.getOOConnexion();
                    if (ooConnexion == null) {
                        return;
                    }
                    Component doc = ooConnexion.loadDocument(fileOutOO, !show);
                    if (this.savePDF()) {
                        File pdfOutputDir = DocumentLocalStorageManager.getInstance().getPDFOutputDirectory(this.getDefaultTemplateID());
                        doc.saveToPDF(new File(pdfOutputDir, String.valueOf(fileName) + ".pdf"), "writer_pdf_Export");
                    }
                    if (print) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("Name", printer);
                        doc.printDocument(map);
                    }
                    if (!show) {
                        doc.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ExceptionHandler.handle("Impossible de charger le document OpenOffice", e);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                ExceptionHandler.handle("Impossible de trouver le mod\u00e9le.", e);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TemplateException e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean savePDF() {
        return false;
    }

    public void showDocument() {
        File fileOutOO = this.getDocumentFile();
        if (fileOutOO.exists()) {
            try {
                OOConnexion ooConnexion = ComptaPropsConfiguration.getOOConnexion();
                if (ooConnexion == null) {
                    return;
                }
                ooConnexion.loadDocument(fileOutOO, false);
            }
            catch (LinkageError e) {
                JOptionPane.showMessageDialog(new JFrame(), "Merci d'installer OpenOffice ou LibreOffice");
            }
            catch (Exception e) {
                e.printStackTrace();
                ExceptionHandler.handle("Impossible de charger le document OpenOffice", e);
            }
        } else {
            this.generate(false, true, "");
        }
    }

    private File getDocumentFile() {
        File outputDir = DocumentLocalStorageManager.getInstance().getDocumentOutputDirectory(this.getDefaultTemplateID());
        return new File(outputDir, String.valueOf(this.getFileName()) + ".odt");
    }

    public void printDocument() {
        File fileOutOO = this.getDocumentFile();
        if (fileOutOO.exists()) {
            try {
                OOConnexion ooConnexion = ComptaPropsConfiguration.getOOConnexion();
                if (ooConnexion == null) {
                    return;
                }
                Component doc = ooConnexion.loadDocument(fileOutOO, true);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("Name", this.printer);
                doc.printDocument(map);
                doc.close();
            }
            catch (LinkageError e) {
                JOptionPane.showMessageDialog(new JFrame(), "Merci d'installer OpenOffice ou LibreOffice");
            }
            catch (Exception e) {
                e.printStackTrace();
                ExceptionHandler.handle("Impossible de charger le document OpenOffice", e);
            }
        } else {
            this.generate(true, false, this.printer);
        }
    }

    public void fastPrintDocument() {
        File f = this.getDocumentFile();
        if (!f.exists()) {
            this.generate(true, false, this.printer);
        } else {
            try {
                OOConnexion ooConnexion = ComptaPropsConfiguration.getOOConnexion();
                if (ooConnexion == null) {
                    return;
                }
                Component doc = ooConnexion.loadDocument(f, true);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("Name", this.printer);
                HashMap<String, Integer> map2 = new HashMap<String, Integer>();
                map2.put("CopyCount", 1);
                doc.printDocument(map, map2);
                doc.close();
            }
            catch (LinkageError e) {
                JOptionPane.showMessageDialog(new JFrame(), "Merci d'installer OpenOffice ou LibreOffice");
            }
            catch (Exception e) {
                ExceptionHandler.handle("Impossible de charger le document OpentOffice", e);
                e.printStackTrace();
            }
        }
    }

    protected String getInitiales(SQLRow row) {
        String init = "";
        if (row != null) {
            String stringNom;
            String stringPrenom = row.getString("PRENOM");
            if (stringPrenom != null && stringPrenom.trim().length() != 0) {
                init = String.valueOf(init) + stringPrenom.trim().charAt(0);
            }
            if ((stringNom = row.getString("NOM")) != null && stringNom.trim().length() != 0) {
                init = String.valueOf(init) + stringNom.trim().charAt(0);
            }
        }
        return init;
    }

    public void exportToPdf() {
        String fileName = this.getFileName();
        File fileOutOO = this.getDocumentFile();
        File outputPDFDirectory = DocumentLocalStorageManager.getInstance().getPDFOutputDirectory(this.templateId);
        File fileOutPDF = new File(outputPDFDirectory, String.valueOf(fileName) + ".pdf");
        if (!fileOutOO.exists()) {
            this.generate(false, false, "");
        }
        try {
            OOConnexion ooConnexion = ComptaPropsConfiguration.getOOConnexion();
            if (ooConnexion == null) {
                return;
            }
            Component doc = ooConnexion.loadDocument(fileOutOO, true);
            doc.saveToPDF(fileOutPDF, "writer_pdf_Export");
            doc.close();
        }
        catch (LinkageError e) {
            JOptionPane.showMessageDialog(new JFrame(), "Merci d'installer OpenOffice ou LibreOffice");
        }
        catch (Exception e) {
            e.printStackTrace();
            ExceptionHandler.handle("Impossible de charger le document OpenOffice", e);
        }
        int result = JOptionPane.showOptionDialog(null, "Ouvrir le pdf ?", "Ouverture du PDF", 0, 3, null, null, null);
        if (result == 0) {
            Gestion.openPDF(fileOutPDF);
        } else {
            try {
                FileUtils.openFile(fileOutPDF.getParentFile());
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "Impossible d'ouvrir le dossier : " + fileOutPDF.getParentFile() + ".");
            }
        }
    }
}

