/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.supplier.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.core.common.ui.IListTotalPanel;
import org.openconcerto.erp.core.finance.payment.element.ReglerMontantSQLComponent;
import org.openconcerto.erp.core.supplychain.order.ui.ListPanelEcheancesFourn;
import org.openconcerto.erp.rights.ComptaUserRight;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class ListeDesEcheancesFournPanel
extends JPanel
implements TableModelListener {
    private ListPanelEcheancesFourn panelEcheances;
    private JButton regler;
    private SQLElement eltRegler = Configuration.getInstance().getDirectory().getElement("REGLER_MONTANT");

    public ListeDesEcheancesFournPanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.panelEcheances = new ListPanelEcheancesFourn();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        c.fill = 1;
        this.add((Component)this.panelEcheances, c);
        IListe liste = this.panelEcheances.getListe();
        IListFilterDatePanel datePanel = new IListFilterDatePanel(liste, liste.getRequest().getPrimaryTable().getField("DATE"), IListFilterDatePanel.getDefaultMap());
        c.weighty = 0.0;
        ++c.gridy;
        c.weightx = 1.0;
        this.add((Component)datePanel, c);
        IListTotalPanel totalPanel = new IListTotalPanel(liste, Arrays.asList(this.panelEcheances.getElement().getTable().getField("MONTANT")));
        c.weighty = 0.0;
        ++c.gridy;
        c.anchor = 13;
        c.weightx = 0.0;
        c.fill = 0;
        this.add((Component)totalPanel, c);
        c.anchor = 17;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.fill = 0;
        c.weightx = 0.0;
        final JCheckBox checkRegCompta = new JCheckBox("Voir les r\u00e9gularisations de comptabilit\u00e9");
        if (UserRightsManager.getCurrentUserRights().haveRight(ComptaUserRight.MENU)) {
            this.add((Component)checkRegCompta, c);
        }
        checkRegCompta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeDesEcheancesFournPanel.this.panelEcheances.setShowRegCompta(checkRegCompta.isSelected());
            }
        });
        c.anchor = 13;
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.regler = new JButton("R\u00e9gler");
        this.regler.setHorizontalAlignment(4);
        this.add((Component)this.regler, c);
        this.regler.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int answer;
                List<Integer> selectedIds = ListeDesEcheancesFournPanel.this.panelEcheances.getListe().getSelection().getSelectedIDs();
                ArrayList<SQLRow> selectedRows = new ArrayList<SQLRow>(selectedIds.size());
                int idCpt = -1;
                int idFournisseur = -1;
                boolean showMessage = false;
                String numeroFact = "";
                for (Integer integer : selectedIds) {
                    SQLRow row = ListeDesEcheancesFournPanel.this.panelEcheances.getListe().getSource().getPrimaryTable().getRow(integer);
                    selectedRows.add(row);
                    String nom = row.getForeignRow("ID_MOUVEMENT").getForeignRow("ID_PIECE").getString("NOM");
                    numeroFact = String.valueOf(numeroFact) + " " + nom;
                    SQLRow rowFournisseur = row.getForeignRow("ID_FOURNISSEUR");
                    int idTmp = rowFournisseur.getInt("ID_COMPTE_PCE");
                    int idCliTmp = rowFournisseur.getID();
                    if (idCpt > -1 && idCpt != idTmp) {
                        JOptionPane.showMessageDialog(null, "Impossible d'effectuer un encaissement sur plusieurs factures ayant des fournisseurs avec des comptes diff\u00e9rents.");
                        return;
                    }
                    idCpt = idTmp;
                    if (idFournisseur > -1 && idFournisseur != idCliTmp) {
                        showMessage = true;
                        continue;
                    }
                    idFournisseur = idCliTmp;
                }
                if (showMessage && (answer = JOptionPane.showConfirmDialog(null, "Attention vous avez s\u00e9lectionn\u00e9 des factures ayant des fournisseurs diff\u00e9rents. Voulez vous continuer?")) != 0) {
                    return;
                }
                SQLElement encaisseElt = Configuration.getInstance().getDirectory().getElement("REGLER_MONTANT");
                EditFrame edit = new EditFrame(encaisseElt);
                SQLRowValues rowVals = new SQLRowValues(encaisseElt.getTable());
                rowVals.put("ID_FOURNISSEUR", idFournisseur);
                rowVals.put("NOM", numeroFact);
                ReglerMontantSQLComponent sqlComponent = (ReglerMontantSQLComponent)edit.getSQLComponent();
                sqlComponent.resetValue();
                sqlComponent.select(rowVals);
                sqlComponent.loadEcheancesFromRows(selectedRows);
                edit.pack();
                edit.setVisible(true);
            }
        });
        ++c.gridx;
        c.weightx = 0.0;
        JButton fermer = new JButton("fermer");
        this.add((Component)fermer, c);
        fermer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame tmpF = (JFrame)SwingUtilities.getRoot(ListeDesEcheancesFournPanel.this);
                tmpF.setVisible(false);
                tmpF.dispose();
            }
        });
        this.panelEcheances.getListe().addListener(this);
    }

    public ListPanelEcheancesFourn getListPanelEcheanceFourn() {
        return this.panelEcheances;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.regler.setEnabled(this.panelEcheances.getJTable().getRowCount() > 0);
    }
}

