/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.credit.component;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.MontantPanel;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.generationEcritures.GenerationMvtAvoirFournisseur;
import org.openconcerto.erp.model.ISQLCompteSelector;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.utils.ExceptionHandler;

public class AvoirFournisseurSQLComponent
extends TransfertBaseSQLComponent
implements ActionListener {
    private JTextField textNom;
    private JDate date;
    private ElementComboBox selectFournisseur;
    private MontantPanel montantPanel;
    private JTextField textNumero = new JTextField(16);
    private JCheckBox boxAdeduire = new JCheckBox(this.getLabelFor("A_DEDUIRE"));
    private JCheckBox boxImmo = new JCheckBox(this.getLabelFor("IMMO"));
    private ElementSQLObject eltModeRegl;
    private PropertyChangeListener listenerModeReglDefaut = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SQLRow rowSelected = AvoirFournisseurSQLComponent.this.selectFournisseur.getSelectedRow();
            if (rowSelected != null && !rowSelected.isUndefined()) {
                rowSelected = rowSelected.asRow();
                AvoirFournisseurSQLComponent.this.montantPanel.setUE(rowSelected.getBoolean("UE"));
                int idModeRegl = rowSelected.getInt("ID_MODE_REGLEMENT");
                if (idModeRegl > 1 && AvoirFournisseurSQLComponent.this.eltModeRegl != null) {
                    SQLElement sqlEltModeRegl = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
                    SQLRow rowModeRegl = sqlEltModeRegl.getTable().getRow(idModeRegl);
                    SQLRowValues rowVals = rowModeRegl.createUpdateRow();
                    rowVals.clearPrimaryKeys();
                    AvoirFournisseurSQLComponent.this.eltModeRegl.setValue(rowVals);
                }
            } else {
                AvoirFournisseurSQLComponent.this.montantPanel.setUE(false);
            }
        }
    };

    @Override
    protected SQLRowValues createDefaults() {
        SQLRowValues vals = new SQLRowValues(this.getTable());
        vals.put("A_DEDUIRE", Boolean.TRUE);
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
        SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
        int idCompteAchat = rowPrefsCompte.getInt("ID_COMPTE_PCE_ACHAT");
        if (idCompteAchat <= 1) {
            try {
                idCompteAchat = ComptePCESQLElement.getIdComptePceDefault("Achats");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        vals.put("ID_COMPTE_PCE", idCompteAchat);
        vals.put("ID_TAXE", TaxeCache.getCache().getFirstTaxe().getID());
        vals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), new Date()));
        return vals;
    }

    public AvoirFournisseurSQLComponent() {
        super(Configuration.getInstance().getDirectory().getElement("AVOIR_FOURNISSEUR"));
    }

    @Override
    public void addViews() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = ComptaSQLConfElement.createAdditionalPanel();
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 2));
        this.add((Component)addP, c);
        ++c.gridy;
        c.gridwidth = 1;
        this.textNom = new JTextField();
        this.date = new JDate(true);
        this.selectFournisseur = new ElementComboBox();
        this.montantPanel = new MontantPanel();
        this.add((Component)new JLabel(this.getLabelFor("NUMERO"), 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        DefaultGridBagConstraints.lockMinimumSize(this.textNumero);
        this.add((Component)this.textNumero, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel("Date", 4), c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.add((Component)((Object)this.date), c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        ++c.gridy;
        c.fill = 2;
        c.gridx = 0;
        JLabel labelLib = new JLabel(this.getLabelFor("NOM"), 4);
        this.add((Component)labelLib, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 3;
        this.add((Component)this.textNom, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 0.0;
        c.gridwidth = 1;
        JLabel labelFourn = new JLabel(this.getLabelFor("ID_FOURNISSEUR"), 4);
        this.add((Component)labelFourn, c);
        ++c.gridx;
        c.fill = 0;
        c.gridwidth = 0;
        c.weightx = 0.0;
        this.add((Component)this.selectFournisseur, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 2;
        c.gridwidth = 1;
        this.add((Component)new JLabel("Montant", 4), c);
        c.weighty = 0.0;
        c.anchor = 17;
        c.gridwidth = 0;
        ++c.gridx;
        this.montantPanel = new MontantPanel();
        this.add((Component)this.montantPanel, c);
        TitledSeparator title = new TitledSeparator("Comptabilit\u00e9");
        c.gridx = 0;
        c.fill = 2;
        ++c.gridy;
        c.gridwidth = 4;
        this.add((Component)title, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        c.fill = 0;
        c.gridwidth = 1;
        ISQLCompteSelector compteSel = new ISQLCompteSelector();
        this.add((Component)new JLabel(this.getLabelFor("ID_COMPTE_PCE")), c);
        c.gridwidth = 0;
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)compteSel, c);
        c.gridwidth = 1;
        c.anchor = 17;
        c.gridwidth = 0;
        c.gridx = 1;
        ++c.gridy;
        c.weighty = 0.0;
        this.add((Component)this.boxImmo, c);
        c.gridheight = 1;
        c.gridx = 0;
        ++c.gridy;
        c.fill = 2;
        c.gridwidth = 0;
        this.add((Component)new TitledSeparator(this.getLabelFor("INFOS")), c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        c.gridwidth = 0;
        ITextArea infos = new ITextArea(4, 4);
        infos.setBorder(null);
        JScrollPane scrollPane = new JScrollPane(infos);
        DefaultGridBagConstraints.lockMinimumSize(scrollPane);
        this.add((Component)scrollPane, c);
        if (this.getTable().contains("INFOS")) {
            this.addSQLObject(infos, "INFOS");
        }
        JPanel p = new JPanel();
        p.setOpaque(false);
        ++c.gridy;
        c.weighty = 1.0;
        this.add((Component)p, c);
        this.addSQLObject(this.textNom, "NOM");
        this.addRequiredSQLObject(this.textNumero, "NUMERO");
        this.addRequiredSQLObject((JComponent)((Object)this.date), "DATE");
        this.addRequiredSQLObject(this.selectFournisseur, "ID_FOURNISSEUR");
        this.addRequiredSQLObject(this.montantPanel.getMontantHT(), "MONTANT_HT");
        this.addRequiredSQLObject(this.montantPanel.getMontantTVA(), "MONTANT_TVA");
        this.addRequiredSQLObject(this.montantPanel.getMontantTTC(), "MONTANT_TTC");
        this.addRequiredSQLObject(this.montantPanel.getChoixTaxe(), "ID_TAXE");
        this.addSQLObject(compteSel, "ID_COMPTE_PCE");
        this.addSQLObject(this.boxImmo, "IMMO");
        this.selectFournisseur.addValueListener(this.listenerModeReglDefaut);
        this.montantPanel.setChoixTaxe(TaxeCache.getCache().getFirstTaxe().getID());
    }

    @Override
    public int insert(SQLRow order) {
        int id = this.getSelectedID();
        id = super.insert(order);
        try {
            SQLTable tableNum = this.getTable().getBase().getTable("NUMEROTATION_AUTO");
            SQLRow row = this.getTable().getRow(id);
            if (NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), row.getDate("DATE").getTime()).equalsIgnoreCase(this.textNumero.getText().trim())) {
                SQLRowValues rowVals = new SQLRowValues(tableNum);
                int val = tableNum.getRow(2).getInt("AVOIR_F_START");
                rowVals.put("AVOIR_F_START", (Object)(++val));
                rowVals.update(2);
            }
            GenerationMvtAvoirFournisseur gen = new GenerationMvtAvoirFournisseur(row);
            gen.genereMouvement();
        }
        catch (Exception e) {
            ExceptionHandler.handle("Erreur d'insertion", e);
        }
        return id;
    }

    @Override
    public void select(SQLRowAccessor r) {
        SQLRowAccessor rowFourn;
        int i;
        this.selectFournisseur.rmValueListener(this.listenerModeReglDefaut);
        super.select(r);
        if (r != null && r.getID() > 1 && (i = r.getInt("ID_FOURNISSEUR")) > 1 && (rowFourn = r.getForeign("ID_FOURNISSEUR")) != null && rowFourn.getID() > 1) {
            this.montantPanel.setUE(rowFourn.getBoolean("UE"));
        }
        this.selectFournisseur.addValueListener(this.listenerModeReglDefaut);
    }

    @Override
    public void update() {
        super.update();
        try {
            SQLRow row = this.getTable().getRow(this.getSelectedID());
            int idMvt = row.getInt("ID_MOUVEMENT");
            EcritureSQLElement eltEcr = (EcritureSQLElement)Configuration.getInstance().getDirectory().getElement("ECRITURE");
            eltEcr.archiveMouvementProfondeur(idMvt, false);
            GenerationMvtAvoirFournisseur gen = new GenerationMvtAvoirFournisseur(row, idMvt);
            gen.genereMouvement();
        }
        catch (Exception e) {
            ExceptionHandler.handle("Erreur Archivage des fils", e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.boxAdeduire && this.eltModeRegl != null) {
            this.eltModeRegl.setEditable(!this.boxAdeduire.isSelected());
            this.eltModeRegl.setCreated(!this.boxAdeduire.isSelected());
        }
    }
}

